; vactivepage
; sets active page.i.e. the page on drawings will be performed
; input    : page no
; on return: -
; call type: procedure vactivepage(page:word);
public vactivepage
vactivepage     proc far
@@page          equ <[bp+06]>
                prefix
                mov ax,pagelen
                mul wptr @@page
                mov actstart,ax
                postfix
                ret 2
vactivepage     endp

; vvisualpage
; sets visual page.i.e. the page which is seen
; input    : page no
; on return: -
; call type: procedure vvisualpage(page:word);
public vvisualpage
vvisualpage     proc far
@@page          equ <[bp+06]>
                prefix
                mov ax,pagelen
                mul wptr @@page
                mov visstart,ax
                mov sdx,ax
                mov dx,ax
                mov cx,scx
                mov bx,0000h
                mov ax,04f07h
                int 10h
                postfix
                ret 2
vvisualpage     endp

; vclearpage
; clears active page
; input    : -
; on return: -
; call type: procedure vclearpage(fillwith:byte);
public vclearpage
vclearpage      proc far
@@fillwith      equ <[bp+06]>
                prefix
                postfix
                ret 2
vclearpage      endp

; vcopypage
; copies one page to another.Uses latch copy for speed
; input    : source page,destination page
; on return: -
; call type: procedure vcopypage(source,dest:word);
public vcopypage
vcopypage       proc far
@@source        equ <[bp+08]>
@@destination   equ <[bp+06]>
                prefix
                postfix
                ret 4
vcopypage       endp
