; vprint
; prints given string on given location by given color
; input    : string,x,y and color
; on return: -
; call type: procedure vprint(text:String;x,y:Word;Color:Byte)
public vprint
vprint       proc far
             prefix
             mov es,[bp+14]     ; segment of text
             mov di,[bp+12]     ; offset of text
             mov ch,0
             mov cl,es:[di]     ; number of chars
             cmp cl,0
             jz @@done
@@loop:
             inc di
             push cx
             mov al,es:[di]     ; character
             mov dx,[bp+10]     ; x
             mov cx,[bp+8]      ; y
             mov bl,[bp+6]      ; color
             call vchar
             add word ptr [bp+10],8
             pop cx
             loop @@loop
@@done:
             postfix
             ret 10
vprint       endp

; vchar
; puts specified char to the specified position by given color
; input    : al=char,dx=x;cx=y;bl=color
; on return: -
; call type: for internal use
charcolor    db 0
row          dw 0
col          dw 0
vchar        proc near
             pusha
             push ds
             push es
             cmp al,127
             ja  @@top
             mov ds,charseg1
             mov si,charofs1
             jmp @@bottom
@@top:
             mov ds,charseg2
             mov si,charofs2
             sub al,128
@@bottom:
             mov charcolor,bl
             mov ah,0           ; clear ah
             shl ax,3           ; ax = ax * 8 since 8x8 font
             add si,ax          ; now di points to char data
             mov ax,cx          ; row
             mov bx,dx          ; column
             mov row,ax
             mov col,bx
             call vsetoffset
             mov es,winaseg     ; segment of screen memory
             mov di,ax          ; offset
             mov cx,charh          ; height of chars
@@loop:
             push cx
             push di
             push col
             mov  al,ds:[si]
             mov  bl,charcolor
             mov  cx,charw
@@loop2:
             shl  al,1
             jnc  @@noadd
             mov  es:[di],bl
@@noadd:
             inc di
             inc col
             jnz @@goon2
             push ax
             push bx
             mov ax,row
             mov bx,col
             call vsetoffset
             mov di,ax
             pop bx
             pop ax
@@goon2:
             loop @@loop2
             pop ax
             mov col,ax
             pop  di
             inc row
             add di,bytesperscan
             jnc @@goon
             push ax
             push bx
             mov ax,row
             mov bx,col
             call vsetoffset
             mov di,ax
             pop ax
             pop bx
@@goon:
             inc si
             pop cx
             loop @@loop
             pop es
             pop ds
             popa
             ret
vchar        endp
