/**********************************************************
 *   TMusic CMF Background Music Class Library v1.0       *
 *           Copyright (C) 1994 Peter Moore               *
 *                All Rights Reserved                     *
 *                                                        *
 *   File: CMFPLAY.CPP                                    *
 *   Description: Example Program.  To compile, type      *
 *        bcc -ml cmfplay.cpp tmusic.lib                  *
 *   To run it, type:                                     *
 *        cmfplay [filename]                              *
 *     where filename is the CMF File Name.  The song     *
 *     will begin to play.  While it's playing, the       *
 *     following commands work:                           *
 *        s    Shells to DOS                              *
 *        q    Quits the program                          *
 *        +    Transposes to +1                           *
 *        -    Transposes to -1                           *
 *        =    Transposes to 0                            *
 *        p    Pauses playback                            *
 *        r    Resumes playback                           *
 *                                                        *
 *   License: You have a royaltee-free right to use any   *
 *        portion of this example program in your own     *
 *        programs.                                       *
 **********************************************************/

#include "tmusicsw.h"
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

void main (int argc, signed char *argv[]) {
     if (argc != 2) {
          printf ("Usage: cmfplay [filename]\n");
          exit(0);
     }
     TMusic cmf (argv[1]);
     printf ( "CMFPlay v2.0 Example Program for TMusic\n" );
     word errorc = cmf.getErrorCode();
     if ( errorc ) {
          printf ("An error has occurred.\n");
          goto end;
     }
     cmf.Play();
     do {
          switch (getch()) {
               case 's':
                    printf ("Type EXIT to return.\n");
                    system ("command.com");
                    printf ("\nReturned to CMFPLAY");
                    break;
               case 'q':
                    cmf.Stop();
                    goto end;
               case '+':
                    ++cmf;
                    break;
               case '-':
                    --cmf;
                    break;
               case '=':
                    cmf.Transpose(0);
                    break;
               case 'p':
                    cmf.Pause();
                    break;
               case 'r':
                    cmf.Resume();
                    break;
          }
     } while ( cmf.getStatus() != CMF_STATUS_NO_EVENT );
     end:;
}
     
