/*
 *    TVoice VOC Player Class Library
 *    Version 1.0
 *    (C) Copyright 1995 Peter Moroe
 *    All Rights Reserved
 */

#ifndef __TVOICE_H
#define __TVOICE_H

#ifndef  byte
   #define  byte  unsigned char
#endif

#ifndef  word
   #define  word  unsigned short
#endif

#ifndef  false
   #define  false (0)
#endif

#ifndef  true
   #define  true  (!(false))
#endif

const int   VOC_ERROR_NONE = 0,
            VOC_ERROR_OUT_OF_MEMORY = 1,
            VOC_ERROR_CANT_FIND_DRIVER = 2,
            VOC_ERROR_FILE_NOT_FOUND = 3,
            VOC_ERROR_CANT_READ_FILE = 5,
            VOC_ERROR_BAD_FILE_FORMAT = 6,
            VOC_ERROR_BAD_DRIVER = 7,
            VOC_STATUS_STOPPED = 0,
            VOC_STATUS_PAUSED = 1;



typedef struct {
   byte  Description[20];        // "Creative Voice File\x1A"
   word  wDataOffset;
   word  wVersion;
   word  wID;                     // Not currently used in TVoice
} VOCHDR;

class TVoice {
   protected:
      byte __far* Driver;
      byte __far* File;
      word  Status;
      int   Error;
      VOCHDR   VocHeader;         
      char __far* PathToDriver;
      word  wAddress;
      byte  bIRQ;

      int SetupAll (void);
      int LoadDriver (void);
      int InitDriver (void);
      int SetSpeaker (int Speaker);
      int TerminateDriver (void);
      int SetStatusWord (void);
      int SetPort (word PortAddress);
      int SetInterrupt (byte IRQ);

      byte __far* GetMemory (unsigned long size);
      void FreeMemory (byte __far* block);

   public:
      TVoice (char __far* sFileName, char __far* sPathToDriver, word
            Address = 0x220, byte IRQ = 7);
      TVoice (char __far* sPathToDriver, word Address = 0x220, 
            byte IRQ = 7);
      
      ~TVoice (void);            
      
      int LoadFile (char __far* sFileName);
      void GetVersion (byte& Major, byte& Minor);

      void Play(void);
      void Stop(void);
      void Pause(void);
      void Continue(void);
      void Wait (void);      

      int GetError(void);
      word GetStatus(void);
      
};    
      
#endif
