/*
 *    TVoice VOC Player Class Library
 *    Version 1.0
 *    (C) Copyright 1995 Peter Moroe
 *    All Rights Reserved
 */

/*
 *    VOCPLAY - TVoice Example Program
 *    Usage: vocplay filename
 *    
 *    Key Commands:
 *    =======================================
 *    q           Ends play and program quits
 *    p           Pauses output
 *    c           Continues paused output
 */

#include <stdio.h>
#include <conio.h>
#include "tvoice.h"

void main (int argc, char** argv) {
   if (argc != 2) {
      printf ("Usage: VOCPLAY filename\n");
      return;
   }
   
   TVoice Voice( argv[1], "ct-voice.drv" );

   word wError;
   if ( (wError = Voice.GetError()) != VOC_ERROR_NONE )  {
      printf ("VOC Driver Error: %d\n", wError);
      return;
   }

   printf ( "TVoice Sample VOC File Player\n" );
   printf ( "(C) Copyright 1995 Peter Moore\n" );
   printf ( "All Rights Reserved\n" );
   
   byte Major, Minor;
   Voice.GetVersion (Major, Minor);
   printf ( "\nVOC Driver Version %d.%d\n", Major, Minor );
   
   printf ( "Proceeding to play file %s\n\n", argv[1] );

   Voice.Play();
   
   if ( (wError = Voice.GetError()) == true ) {
      printf ("VOC Driver Error: %d\n", wError);
      return;
   }
   
   printf ( "Playing.\n" );

   char Input;
   while ( Voice.GetStatus() != VOC_STATUS_STOPPED ) { 
      if ( kbhit() ) {
         Input = getch();
         switch (Input) {
            case 'q':
               Voice.Stop();
               return;
            case 'p':
               printf ("Pausing.\n");
               Voice.Pause();
               break;
            case 'c':
               printf ("Continuing.\n");
               Voice.Continue();
               break;
            default:;
         }
      }
   };
}

