comment *

        Purpose:
        Test if Adlib API works

        Author:
        Yousuf J. Khan

        *
include adlib.inc

.model tiny
.data
crlf    equ     13,10
crlfe   equ     crlf,"$"
noadl           db      "No AdLib card", crlfe
yadl            db      "Found AdLib", crlfe
sbport          dw      ?       ;address where SB port was found
nosb            db      "No SoundBlaster card", crlfe
ysb             db      "SoundBlaster found at port "
address         db      4 dup(" "),"h", crlfe
noise           db      "Where's that noise coming from?",crlfe
presskey        db      "Press any key to stop noise", crlfe
.code
        org     100h
start:
        extrn   detect_adlib:near
        call    detect_adlib            ;procedure returns AX=1
        cmp     ax, 1                   ; if AdLib present
        je      short sb_detect
        lea     dx, noadl
        mov     ah, 9
        int     21h
        mov     ax, 4c01h               ;exit, errorlevel 1
        int     21h
sb_detect:
        lea     dx, yadl
        mov     ah, 9
        int     21h
        extrn   detect_sb:near
        lea     di, sbport      ;where to store i/o address
        call    detect_sb
        cmp     ax, 1           ;if SB present, AX=1
        jne     short no_sb_found
        mov     ax, [di]        ;load hex num to convert
        lea     di, address     ;where ASCII will be stored (4 bytes)
        call    hex2text        ;convert to hex num to text num
        lea     dx, ysb
        mov     ah, 9
        int     21h
        jmp     short initcard  ;start initializing card
no_sb_found:
        lea     dx, nosb
        mov     ah, 9
        int     21h
initcard:
        extrn   adlibinit:near  ;procedure to initialize all
        call    adlibinit       ; AdLib registers to zero
        extrn   sbdelay:near    ;proc to add i/o wait states
        ;
        ;let's start making noise
        ;
        lea     dx, noise
        mov     ah, 9
        int     21h
        .radix 16
        ;Set the modulator's multiple to 1
        setadlib        20, 01
        ;Set the modulator's level to about 40 dB
        setadlib        40, 10
        ;Modulator attack:  quick;   decay:   long
        setadlib        60, 0F0
        ;Modulator sustain: medium;  release: medium
        setadlib        80, 77
        ;Set voice frequency's LSB (it'll be a D#)
        setadlib        0A0, 98
        ;Set the carrier's multiple to 1
        setadlib        23, 01
        ;Set the carrier to maximum volume (about 47 dB)
        setadlib        43, 00
        ;Carrier attack:  quick;   decay:   long
        setadlib        63, 0F0
        ;Carrier sustain: medium;  release: medium
        setadlib        83, 77
        ;Turn the voice on; set the octave and freq MSB
        setadlib        0B0, 31
        .radix 10
        ;
        ;wait till key pressed
        ;
        lea     dx, presskey    ;print string interrupt
        mov     ah, 9
        int     21h
        mov     ah, 7           ;direct STDIN input interrupt
        int     21h
        ;
        ;let's turn off the noise by running the init over again
        ;
        call    adlibinit       ;calling init to turn off sound
        mov     ax, 4c00h       ;exit, errorlevel 0
        int     21h

hex2text        proc    near
comment *

        Purpose:
        To convert a true hex number to an ASCII hex number

        Entry:
        AX: hex num to convert
        DI: start address to store converted ASCII number

        Exit:
        DI-> points to where last ASCII number stored

        *
        push    dx              ;save DX
        xor     dx, dx
        push    bx              ;save BX
        mov     bx, 1000h
        div     bx              ;divide by 1000h
        call    hexascii
        mov     ax, dx          ;move remainder in
        xor     dx, dx
        mov     bx, 100h
        div     bx              ;div by 100h
        inc     di
        call    hexascii
        mov     ax, dx          ;move remainder in
        xor     dx, dx
        mov     bx, 10h
        div     bx              ;div by 10h
        inc     di
        call    hexascii
        mov     ax, dx
        inc     di
        call    hexascii
        pop     bx              ;restore BX
        pop     dx              ;restore DX
        ret
        endp

hexascii        proc    near
comment *

        Purpose:
        A subprocedure for internal use by HEX2TEXT procedure only

        Entry:
        AL: byte value to convert to ASCII
        DI: pointer to store ASCII to

        Exit:
        AL: destroyed
        [DI]: location modified

        *
        cmp     al, 0Ah
        jb      numerical
        sub     al, 0Ah
        add     al, "A"
        jmp     short store
numerical:
        add     al, "0"
store:
        mov     [di], al
        ret
        endp
        end     start
