#include <windows.h>
#include <stdlib.h>  		// for atol conversion  
#include "filters.h" 
#include "resource.h"

#define AVERAGESIZE 128

typedef struct output_tag  // any special vars associated with output file
	{short nFile;         
	 long lSize;
	 DWORD dwDataOffset;
	 long lSamprate;
	 WORD wBitsPerSample;
	 WORD wChannels;
	 DWORD dwFormat;
	 BOOL bWroteHeader;
	 char szNAME[256];
	} MYOUTPUT;

typedef struct input_tag // any special vars associated with input file
{	short nFile;
	long lSize;    
	DWORD dwFormat;  
	WORD wChannels;
	DWORD dwDataOffset;		   
	WORD wBitsPerSample;
	char szNAME[256];
} MYINPUT;


short mulaw[256]=
{ -8031,-7775,-7519,-7263,-7007,-6751,-6495,-6239,-5983,-5727,
  -5471,-5215,-4959,-4703,-4447,-4191,-3999,-3871,-3743,-3615,
  -3487,-3359,-3231,-3103,-2975,-2847,-2719,-2591,-2463,-2335,
  -2207,-2079,-1983,-1919,-1855,-1791,-1727,-1663,-1599,-1535,
  -1471,-1407,-1343,-1279,-1215,-1151,-1087,-1023,-975, -943,
  -911, -879, -847, -815, -783, -751, -719, -687, -655, -623,
  -591, -559, -527, -495, -471, -455, -439, -423, -407, -391,
  -375, -359, -343, -327, -311, -295, -279, -263, -247, -231,
  -219, -211, -203, -195, -187, -179, -171, -163, -155, -147,
  -139, -131, -123, -115, -107, -99,  -93,  -89,  -85,  -81,
  -77,  -73,  -69,  -65,  -61,  -57,  -53,  -49,  -45,  -41,
  -37,  -33,  -30,  -28,  -26,  -24,  -22,  -20,  -18,  -16,
  -14,  -12,  -10,  -8,   -6,   -4,   -2,   0,   8031,  7775,
  7519, 7263, 7007, 6751, 6495, 6239, 5983, 5727, 5471, 5215,
  4959, 4703, 4447, 4191, 3999, 3871, 3743, 3615, 3487, 3359,
  3231, 3103, 2975, 2847, 2719, 2591, 2463, 2335, 2207, 2079,
  1983, 1919, 1855, 1791, 1727, 1663, 1599, 1535, 1471, 1407, 1343, 1279, 1215, 1151, 1087, 1023, 
  975,  943,  911,  879,  847,  815,  783,  751,  719,  687,  655,  623,  591,  559,  527,  495,  
  471,  455,  439,  423,  407,  391,  375,  359,  343,  327,  311,  295,  279,  263,  247,  231,   // <480, =207- (sig-224)/16  
  219,  211,  203,  195,  187,  179,  171,  163,  155,  147,  139,  131,  123,  115,  107,  99,    // <224, =223- (sig-96)/8
  93,   89,   85,   81,   77,   73,   69,   65,   61,   57,   53,   49,   45,   41,   37,   33,    // <96,  =239- (sig-32)/4    for 224-239
  30,   28,   26,   24,   22,   20,   18,   16,   14,   12,   10,   8,    6,    4,    2,    0};    // <32,  =255-sig/2          for 240-255

unsigned char mulawfxn(short sig)
{   static short error=0;
	short maxdif=20000;
	short minat=0;
	short lo=0;
	short hi=255;             
	short addin=0;
	//short signal;
	 
	if (sig<0)
	{	sig=-sig;
		addin=128;
	} 
	if (sig<32)
	{	minat=255-(sig>>1);
	}
	else if (sig<96)
	{	minat=239-((sig-32)>>2);
	}
	else if (sig<224)
	{	minat=223-((sig-96)>>3);
	}                        
	else if (sig<480)
	{	minat=207-((sig-224)>>4);
	}
	else if (sig<992)
	{	minat=191-((sig-480)>>5);
	}
	else if (sig<2016)
	{	minat=175-((sig-992)>>6);
	}
	else if (sig<4064)
	{	minat=159-((sig-2016)>>7);
	}                            
	else if (sig<8160)
	{	minat=143-((sig-4064)>>8);
	}                            
	else
	{	minat=128;
	}
	return (unsigned char)(minat-addin);
	 

}

short alaw[256]=
{-688,-656,-752,-720,-560,-528,-624,-592,-944,-912,-1008,-976,
-816,-784,-880,-848,-344,-328,-376,-360,-280,-264,-312,-296,
-472,-456,-504,-488,-408,-392,-440,-424,-2752,-2624,-3008,-2880,
-2240,-2112,-2496,-2368,-3776,-3648,-4032,-3904,-3264,-3136,
-3520,-3392,-1376,-1312,-1504,-1440,-1120,-1056,-1248,-1184,
-1888,-1824,-2016,-1952,-1632,-1568,-1760,-1696,-43,-41,-47,-45,
-35,-33,-39,-37,-59,-57,-63,-61,-51,-49,-55,-53,-11,-9,-15,
-13,-3,-1,-7,-5,-27,-25,-31,-29,-19,-17,-23,-21,-172,-164,
-188,-180,-140,-132,-156,-148,-236,-228,-252,-244,-204,-196,
-220,-212,-86,-82,-94,-90,-70,-66,-78,-74,-118,-114,-126,-122,
-102,-98,-110,-106,688,656,752,720,560,528,624,592,944,912,
1008,976,816,784,880,848,344,328,376,360,280,264,312,296,472,
456,504,488,408,392,440,424,2752,2624,3008,2880,2240,2112,
2496,2368,3776,3648,4032,3904,3264,3136,3520,3392,1376,1312,
1504,1440,1120,1056,1248,1184,1888,1824,2016,1952,1632,1568,
1760,1696,43,41,47,45,35,33,39,37,59,57,63,61,51,49,55,53,
11,9,15,13,3,1,7,5,27,25,31,29,19,17,23,21,172,164,188,
180,140,132,156,148,236,228,252,244,204,196,220,212,
86,82,94,90,70,66,78,74,118,114,126,122,102,98,110,106};
     
unsigned char alawfxn(short wSample)
{   BYTE	alaw;
    
    // We'll init our A-law value per the sign of the PCM sample.  A-law
    // characters have the MSB=1 for positive PCM data.  Also, we'll
    // convert our signed 16-bit PCM value to it's absolute value and
    // then work on that to get the rest of the A-law character bits.
  	if (wSample < 0)
    {   alaw = 0x00;
    	wSample = -wSample;
    	if (wSample < 0) 
    		wSample = 0x7FFF;
    }
   	else
    {   alaw = 0x80;
    }
                            
    // Now we test the PCM sample amplitude and create the A-law character.
    // Study the CCITT A-law for more detail.
        
  	if (wSample >= 2048)	// 2048 <= wSample < 32768	
	{   if (wSample >= 8192)  // 8192 <= wSample < 32768	    
	    {   if (wSample >= 16384)  // 16384 <= wSample < 32768	        
	        {   alaw |= 0x70 | ((wSample >> 10) & 0x0F);
	        }	                    
	    	else	// 8192 <= wSample < 16384	        
	    	{   alaw |= 0x60 | ((wSample >> 9) & 0x0F);
	        }
	    }
		else	// 2048 <= wSample < 8192	    
	    {   if (wSample >= 4096)  // 4096 <= wSample < 8192	        
	        {   alaw |= 0x50 | ((wSample >> 8) & 0x0F);
	        }	                    
	    	else  // 2048 <= wSample < 4096	        
	        {   alaw |= 0x40 | ((wSample >> 7) & 0x0F);
	        }
	    }
	}
	else    // 0 <= wSample < 2048            
    {	if (wSample >= 512)   // 512 <= wSample < 2048		
		{   if (wSample >= 1024)  // 1024 <= wSample < 2048		    
            {   alaw |= 0x30 | ((wSample >> 6) & 0x0F);
            }
            else    // 512 <= wSample < 1024
            {   alaw |= 0x20 | ((wSample >> 5) & 0x0F);
           	}
     	}
        else  // 0 <= wSample < 512
        {   alaw |= 0x00 | ((wSample >> 4) & 0x1F);
        }
 	}
                
    return alaw ^ 0x55;      // Invert even bits
}

long ReverseLong(long l)
{	long newl;
	newl=((long)HIBYTE(HIWORD(l))) + ((long)(LOBYTE(HIWORD(l)))<<8) + ((long)(HIBYTE(LOWORD(l)))<<16) + ((long)(LOBYTE(LOWORD(l)))<<24);
    return newl;
}

short ReverseShort(short i)
{	short newi;
	newi=(short)HIBYTE(i) + ((short)LOBYTE(i)<<8);
	return newi;
}


BOOL WINAPI DllMain (HANDLE hModule, DWORD fdwReason, LPVOID lpReserved)
{
   switch (fdwReason)
   {
      case DLL_PROCESS_ATTACH:
        /* Code from LibMain inserted here.  Return TRUE to keep the
            DLL loaded or return FALSE to fail loading the DLL.
 
            You may have to modify the code in your original LibMain to
            account for the fact that it may be called more than once.
            You will get one DLL_PROCESS_ATTACH for each process that
            loads the DLL. This is different from LibMain which gets
            called only once when the DLL is loaded. The only time this
            is critical is when you are using shared data sections.
            If you are using shared data sections for statically
            allocated data, you will need to be careful to initialize it
            only once. Check your code carefully.
 
            Certain one-time initializations may now need to be done for
            each process that attaches. You may also not need code from
            your original LibMain because the operating system may now
            be doing it for you.
         */
         break;
 
      case DLL_THREAD_ATTACH:
         /* Called each time a thread is created in a process that has
            already loaded (attached to) this DLL. Does not get called
            for each thread that exists in the process before it loaded
            the DLL.
 
            Do thread-specific initialization here.
         */
         break;
 
      case DLL_THREAD_DETACH:
         /* Same as above, but called when a thread in the process
            exits.
 
            Do thread-specific cleanup here.
         */
         break;
 
      case DLL_PROCESS_DETACH:
         /* Code from _WEP inserted here.  This code may (like the
            LibMain) not be necessary.  Check to make certain that the
            operating system is not doing it for you.
         */
         break;
   }
 
   /* The return value is only used for DLL_PROCESS_ATTACH; all other
      conditions are ignored.  */
   return TRUE;   // successful DLL_PROCESS_ATTACH
}


// Fill COOLQUERY structure with information regarding this file filter

__declspec(dllexport) short FAR PASCAL QueryCoolFilter(COOLQUERY far * cq)
{   lstrcpy(cq->szName,"Next/Sun");		
	lstrcpy(cq->szCopyright,"Next/Sun Audio Format");
	lstrcpy(cq->szExt,"AU"); 
	lstrcpy(cq->szExt2,"SND"); 
	cq->lChunkSize=16384; 
	cq->dwFlags=QF_READSPECIALLAST|QF_WRITESPECIALFIRST|QF_RATEADJUSTABLE|QF_CANSAVE|QF_CANLOAD|QF_HASOPTIONSBOX;
 	cq->Stereo8=0xFF; // supports all rates of stereo 8
 	cq->Stereo16=0xFF;
 	cq->Stereo24=0xFF;
 	cq->Stereo32=0xFF;
 	cq->Mono8=0xFF; // supports all rates of stereo 8
 	cq->Mono16=0xFF;
 	cq->Mono24=0xFF;
 	cq->Mono32=0xFF;
 	cq->Quad32=0xFF;
 	cq->Quad16=0xFF;
 	cq->Quad8=0xFF;
 	return C_VALIDLIBRARY;
}

__declspec(dllexport) long FAR PASCAL FilterGetFileSize(HANDLE hInput)
{	long lSize=0L;
	if (hInput)
	{	MYINPUT far *mi;
	 	mi=(MYINPUT far *)GlobalLock(hInput);
	 	lSize=mi->lSize;
	 	GlobalUnlock(hInput);
	}
    return lSize;
}

__declspec(dllexport) BOOL FAR PASCAL FilterUnderstandsFormat(LPSTR filename)
{	short nFile;
	BOOL bUnderstands=FALSE;
	
	nFile=_lopen(filename,OF_READ);
  	if (nFile!=-1)
  	{   char m[13];
  		DWORD dwDataOffset;
  		long lSize;
  		DWORD dwFormat;
  		
  		_lread(nFile,m,4);
  		m[4]=0x00;
  		if (lstrcmp(m,".snd")==0)
  		{
	  		_lread(nFile,&dwDataOffset,4);
	    	_lread(nFile,&lSize,4);
	    	_lread(nFile,&dwFormat,4);
	    	dwDataOffset=ReverseLong(dwDataOffset);
	    	lSize=ReverseLong(lSize);
	    	dwFormat=ReverseLong(dwFormat);
	    	
	    	switch (dwFormat)
	    	{	case 1:
				case 27: 
				case 2:
				case 3:
			    	bUnderstands=TRUE;
					break;
			    default:
			    	break;
			}
    	}
    		
  		_lclose(nFile);
  	}	
  	
  	return bUnderstands;	
}


__declspec(dllexport) DWORD FAR PASCAL FilterGetOptions(HWND hWnd, HINSTANCE hInst, long lSamprate, WORD wChannels, WORD wBitsPerSample, DWORD dwOptions) // return 0 if no options box
{	long nDialogReturn=0L;
	FARPROC lpfnDIALOGMsgProc;
	lpfnDIALOGMsgProc = GetProcAddress(hInst,(LPCSTR)MAKELONG(20,0));			
			
	if (dwOptions==0)
		nDialogReturn=1;
	else
		nDialogReturn=dwOptions;
	
	if (nDialogReturn==3)  // 8-bit/16-bit linear, get 8/16 from original sample type
		nDialogReturn=2;
	
			
	nDialogReturn = (long)DialogBoxParam((HINSTANCE)hInst,(LPCSTR)MAKEINTRESOURCE(IDD_COMPRESSION), (HWND)hWnd, (DLGPROC)lpfnDIALOGMsgProc,nDialogReturn);
	
	return nDialogReturn;
}
__declspec(dllexport) DWORD FAR PASCAL FilterOptions(HANDLE hInput)
{   MYINPUT far *mi;
	DWORD options;
	if (!hInput) return 0;
	mi=(MYINPUT far *)GlobalLock(hInput);
    
    options=(DWORD)mi->dwFormat;
    if (options==3)
    	options=2;
    
    GlobalUnlock(hInput);
     
    return options;
}	    

__declspec(dllexport) DWORD FAR PASCAL FilterOptionsString(HANDLE hInput, LPSTR szString)
{   MYINPUT far *mi;
	DWORD options;
	if (!hInput) return 0;
	mi=(MYINPUT far *)GlobalLock(hInput);
    options=(DWORD)mi->dwFormat;
    //if (options==3)
    //	options=2;
    
    //wsprintf(szString,"Option %ld RealAudio",options);
	switch (options)
	{	case 1:	lstrcpy(szString,"8-bit mu-Law Encoded Next/Sun AU");
				break;	
		case 27: lstrcpy(szString,"8-bit A-Law Encoded Next/Sun AU");
				break;		
		case 2: lstrcpy(szString,"8-bit Linear PCM Next/Sun AU");
				break;
		case 3: lstrcpy(szString,"16-bit Linear PCM Next/Sun AU");
				break;		
	}
    
    GlobalUnlock(hInput);
    return options;
}

__declspec(dllexport) BOOL FAR PASCAL DIALOGMsgProc(HWND hWndDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{switch(Message)
   {case WM_INITDIALOG:
         {	 long nDialogReturn;
         	 nDialogReturn=(long)lParam;
             
	         if (nDialogReturn==1)
	         {	CheckDlgButton(hWndDlg,IDC_RADIO1,TRUE);
	         }
	         else if ((nDialogReturn==2) || (nDialogReturn==3))
	         {  CheckDlgButton(hWndDlg,IDC_RADIO2,TRUE);
	         }
	         else if (nDialogReturn==27)
	         {	CheckDlgButton(hWndDlg,IDC_RADIO4,TRUE);
	         }                          
	         else
	         {	CheckDlgButton(hWndDlg,IDC_RADIO1,TRUE);
	         }	         
         }         
         break; /* End of WM_INITDIALOG                                 */

    case WM_CLOSE:
         /* Closing the Dialog behaves the same as Cancel               */
         PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
         break; /* End of WM_CLOSE                                      */

    case WM_COMMAND:
	{     switch(LOWORD(wParam))
           {case IDOK:
            	 {long nDialogReturn;
            	  if (IsDlgButtonChecked(hWndDlg,IDC_RADIO4))
            	  {	nDialogReturn=27;
            	  }
            	  else if (IsDlgButtonChecked(hWndDlg,IDC_RADIO2))
            	  {	nDialogReturn=2;
            	  }
            	  else
            	  {	nDialogReturn=1;
            	  }
            	  EndDialog(hWndDlg, (short)nDialogReturn);
            	 }
                 break;
            case IDCANCEL:
                 /* Ignore data values entered into the controls        */
                 /* and dismiss the dialog window returning FALSE       */
                 EndDialog(hWndDlg, FALSE);
                 break;
           }
         break;    /* End of WM_COMMAND                                 */
	}
    default:
        return FALSE;
   }
 return TRUE;
} /* End of DIALOGSMsgProc                                      */


__declspec(dllexport) DWORD FAR PASCAL FilterGetNextSpecialData(HANDLE hInput, SPECIALDATA * psp)
{	return 0; // only has 1 special data!  Otherwise we would use psp->hSpecialData
			  // as either a counter to know which item to retrieve next, or as a
			  // structure with other state information in it.
}

__declspec(dllexport) DWORD FAR PASCAL FilterGetFirstSpecialData(HANDLE hInput, 
	SPECIALDATA * psp)
{	MYINPUT * mi;
	DWORD dwSuccess=0;

	if (!hInput)
		return 0;  // return is boolean
	mi=(MYINPUT *)GlobalLock(hInput);

	if (lstrlen(mi->szNAME))
	{	char * pData;
		psp->hSpecialData=NULL;
		psp->hData=GlobalAlloc(GMEM_MOVEABLE|GMEM_ZEROINIT,lstrlen(mi->szNAME)+2);
		pData=(char *)GlobalLock(psp->hData);
		psp->dwSize=lstrlen(mi->szNAME)+1;
		psp->dwExtra=1;
		lstrcpy(psp->szListType,"INFO");
		lstrcpy(psp->szType,"INAM");
		lstrcpy(pData,mi->szNAME);
		GlobalUnlock(pData);
		dwSuccess=1;
	}
	
	GlobalUnlock(hInput);
	return dwSuccess;
}
    

__declspec(dllexport) DWORD FAR PASCAL FilterWriteSpecialData(HANDLE hOutput,
	LPCSTR szListType, LPCSTR szType, char * pData,DWORD dwSize)
{
	if ((lstrcmp(szListType,"INFO")==0) && (lstrcmp(szType,"INAM")==0))
	{	MYOUTPUT far *mo;
 		mo=(MYOUTPUT far *)GlobalLock(hOutput);
 		
		lstrcpy(mo->szNAME,pData);

 		GlobalUnlock(hOutput);
 		return 1;
	}	
	return 0;
}


 

__declspec(dllexport) HANDLE FAR PASCAL OpenFilterOutput(LPSTR lpstrFilename,long lSamprate,WORD wBitsPerSample,WORD wChannels,long lSize, long far *lpChunkSize, DWORD dwOptions)
{	HANDLE hOutput;
	short nFile;
	nFile=_lcreat(lpstrFilename,0);
	
	if (nFile==-1) return NULL;
    hOutput=GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE,sizeof(MYOUTPUT));
    if (hOutput)
    {	MYOUTPUT far *mo;
    	DWORD dw;
    	mo=(MYOUTPUT far *)GlobalLock(hOutput);
    	mo->nFile=nFile;
    	mo->lSize=lSize; // size in bytes 16-bit PCM
    	mo->lSamprate=lSamprate;
	 	mo->wBitsPerSample=wBitsPerSample;
	 	mo->wChannels=wChannels;
	 	dw=0x646e732e;
	 	_lwrite(mo->nFile,(LPCSTR)&dw,4);
	 	mo->dwFormat=dwOptions;
	 	FillMemory(mo->szNAME,255,0);
	 	
    	mo->bWroteHeader=FALSE;
    	//dw=0;
    	//_lwrite(mo->nFile,&dw,4);
		
    	GlobalUnlock(hOutput);		
    }
    *lpChunkSize=16384;    
    return hOutput;
}

__declspec(dllexport) void FAR PASCAL CloseFilterOutput(HANDLE hOutput)
{   if (hOutput)
	{	MYOUTPUT far *mo;
	 	mo=(MYOUTPUT far *)GlobalLock(hOutput);
	 	
	 	// Output actual number of bytes written
	 	
	 	if (mo->nFile!=-1)
	 	{	_lclose(mo->nFile);
	 		mo->nFile=-1;
	 	}        
	 	
	 	GlobalUnlock(hOutput);
	 	GlobalFree(hOutput);
	}
}              
  

__declspec(dllexport) DWORD FAR PASCAL WriteFilterOutput(HANDLE hOutput, unsigned char far *buf, long lBytes)
{	DWORD written=0L;
 	if (hOutput)
	{	MYOUTPUT far *mo;
	 	long length; 
	 	long offset;   
	 	short far * ibuf;
	 	
	 	mo=(MYOUTPUT far *)GlobalLock(hOutput);
	 	ibuf=(short far *)buf;
	 	
	 	if (!mo->bWroteHeader)
	 	{   short iTextSize=lstrlen(mo->szNAME);
	 		DWORD dw;
	 		//if (iTextSize==1)
	 		//	iTextSize=0;
	 		iTextSize=((iTextSize+3)/4)*4;
	 		dw=ReverseLong(24+iTextSize);
		 	_lwrite(mo->nFile,(LPCSTR)&dw,4);
	    	
	    	if (mo->dwFormat==0)
	    		mo->dwFormat=1;
	    	
	    	if ((mo->dwFormat==1) || (mo->dwFormat==27)) // compressed 16-bit to 8-bit
	    		dw=mo->lSize*8/mo->wBitsPerSample;
	    	else
	    		dw=mo->lSize;  
	    	dw=ReverseLong(dw);
	    	_lwrite(mo->nFile,(LPCSTR)&dw,4);
	    	dw=mo->dwFormat;    	
	    	if ((dw==2) && (mo->wBitsPerSample==16))
	    		dw=3;
	    	if ((dw==3) && (mo->wBitsPerSample==8))
	    		dw=2;
	    	dw=ReverseLong(dw);
	    	_lwrite(mo->nFile,(LPCSTR)&dw,4);
	    	dw=ReverseLong(mo->lSamprate);
	    	_lwrite(mo->nFile,(LPCSTR)&dw,4);
	    	dw=(long)mo->wChannels;
	    	dw=ReverseLong(dw);
	    	_lwrite(mo->nFile,(LPCSTR)&dw,4);
	    	if (iTextSize)
	    		_lwrite(mo->nFile,mo->szNAME,iTextSize);
	 	 	mo->bWroteHeader=TRUE;
	 	}
	 	
	 	if (mo->dwFormat==1)
	 	{	if (mo->wBitsPerSample==8)
			{	for(offset=0;offset<lBytes;++offset)
					buf[offset]=mulawfxn((short)((buf[offset]-128)*64));
				written=(long)_lwrite(mo->nFile,buf,(unsigned)lBytes);
			}
			else if (mo->wBitsPerSample==16)
			{	length=lBytes/2;    // length in samples
				for(offset=0;offset<length;++offset)
				    buf[offset]=mulawfxn((short)(ibuf[offset]/4));
				written=2*(long)_lwrite(mo->nFile,buf,(unsigned)length);
			}	 	    
		}
		else if (mo->dwFormat==27)
		{	if (mo->wBitsPerSample==8)
			{	for(offset=0;offset<lBytes;++offset)
					buf[offset]=alawfxn((short)((buf[offset]-128)*256));
				written=(long)_lwrite(mo->nFile,buf,(unsigned)lBytes);				
			}
			else if (mo->wBitsPerSample==16)
			{	long length;
				length=lBytes/2;    // length in samples
				for(offset=0;offset<length;++offset)
				    buf[offset]=alawfxn(ibuf[offset]);			
				written=2*(unsigned)_lwrite(mo->nFile,buf,(unsigned)length);
			}	         
		}
		else if ((mo->dwFormat==2) || (mo->dwFormat==3))
		{	// sign change 8-bit, reverse 16-bit words???
		    if (mo->wBitsPerSample==8)
		    {	short t;
		    	for (t=0;t<(short)lBytes;t++)
		    	{
		    		buf[t]=buf[t]+128;
		    	}
		    }
		    else if (mo->wBitsPerSample==16)
		    {	short t;
		    	unsigned char tmp;
		    	for (t=0;t<(short)lBytes;t+=2)
		 	 	{	tmp=buf[t];
		 	 		buf[t]=buf[t+1];
		 	 		buf[t+1]=tmp;
		 	 	}
		    }
		    written=_lwrite(mo->nFile,buf,(unsigned int)lBytes);		
		}
		GlobalUnlock(hOutput);
 	}
 	return written;	
}

// return handle that will be passed in to close, and write routines
__declspec(dllexport) HANDLE FAR PASCAL OpenFilterInput( LPSTR lpstrFilename,
											long far *lSamprate,
											WORD far *wBitsPerSample,
											WORD far *wChannels,
											HWND hWnd,
											long far *lChunkSize)
{	HANDLE hInput;
	short nFile;
	
	nFile=_lopen(lpstrFilename,OF_READ);
    if (nFile==-1) 
    {	return NULL;    
    }   
    
    hInput=GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE,sizeof(MYINPUT));
    if (hInput)
    {	MYINPUT far *mi;
    	DWORD dwMagic;
    	
    	mi=(MYINPUT far *)GlobalLock(hInput);
    	mi->nFile=nFile;
    	_lread(mi->nFile,&dwMagic,4);
    	if (dwMagic!=0x646e732e)
    	{	_lclose(mi->nFile);
    		GlobalUnlock(hInput);
    		GlobalFree(hInput);
    		return NULL;    	
    	}    	
    	
    	_lread(mi->nFile,&mi->dwDataOffset,4);
    	_lread(mi->nFile,&mi->lSize,4);
    	_lread(mi->nFile,&mi->dwFormat,4);
    	_lread(mi->nFile,lSamprate,4);
    	_lread(mi->nFile,wChannels,2);
    	_lread(mi->nFile,wChannels,2);
    	
    	mi->dwDataOffset=ReverseLong(mi->dwDataOffset);
    	mi->lSize=ReverseLong(mi->lSize);
    	mi->dwFormat=ReverseLong(mi->dwFormat);
    	*lSamprate=ReverseLong(*lSamprate);
    	*wChannels=ReverseShort(*wChannels);
    	mi->wChannels=*wChannels;
		{	int iNameLen=mi->dwDataOffset-24;

    		if (iNameLen)
			{	_lread(mi->nFile,mi->szNAME,iNameLen);
				mi->szNAME[iNameLen]=0x00;
			}
    		else
    			lstrcpy(mi->szNAME,"");
		}	
    	
    	if ((mi->lSize==-1) || (mi->lSize==0))
    	{	// Calculate size from size of file
    		long lEnd;
    		lEnd=_llseek(mi->nFile,0,2);
    		mi->lSize=lEnd-mi->dwDataOffset;    	
    	}
    	
    	switch ((short)mi->dwFormat)
	    {	case 0: *wBitsPerSample=16;
	    			break;
	    	case 1: *wBitsPerSample=16;
	    			mi->lSize*=2;
	    			break;
	    	case 2: *wBitsPerSample=8;
	    			break;
	    	case 3: *wBitsPerSample=16;
	    			break;
	    	case 27:*wBitsPerSample=16;
	    			mi->lSize*=2;
	    			break; 
	    	default:	_lclose(mi->nFile);
			    		GlobalUnlock(hInput);
			    		GlobalFree(hInput);
			    		return NULL;			    		    
	    }
 		
 		mi->wBitsPerSample=*wBitsPerSample;
 		
 		_llseek(mi->nFile,mi->dwDataOffset,0);
 		
 		//g72x_init_state(&mi->state);
 		
    	GlobalUnlock(hInput);	    
    } 
    
    *lChunkSize=16384;
    
    return hInput;
}

__declspec(dllexport) void FAR PASCAL CloseFilterInput(HANDLE hInput)
{   if (hInput)
	{	MYINPUT far *mi;
	 	mi=(MYINPUT far *)GlobalLock(hInput);
	 	if (mi->nFile!=-1)
	 	{	_lclose(mi->nFile);
	 		mi->nFile=-1;
	 	}
	 	GlobalUnlock(hInput);
	 	GlobalFree(hInput);
	}
}


short unpack_input( unsigned char *code, short bits, unsigned char far *buf, short *ofset)
{
	static unsigned long	in_buffer = 0;
	static long		in_bits = 0;
	unsigned char		in_byte;

	if (in_bits < bits) {
		
		in_byte=buf[*ofset];
		*ofset++;
		in_buffer |= (in_byte << in_bits);
		in_bits += 8;
	}
	*code = (unsigned char)(in_buffer & ((1 << bits) - 1));
	in_buffer >>= bits;
	in_bits -= bits;
	return (in_bits > 0);
}


__declspec(dllexport) DWORD FAR PASCAL ReadFilterInput(HANDLE hInput, unsigned char far *buf, long lBytes)
{	DWORD read=0L;
    // expecting bytes as array of 16-bit samples
	
 	if (hInput)
	{	MYINPUT far *mi;
		long readlength;
		unsigned short far *ibuf;       
		long offset;	// offset into the current read buffer
	    long length;
	    
	    mi=(MYINPUT far *)GlobalLock(hInput);
		
		if (mi->dwFormat==1) // muLaw
		{	unsigned char *cbuf;
			ibuf=(unsigned short far *)buf;
			readlength=lBytes/2L;                                       
			cbuf=buf+readlength;
			length=_lread(mi->nFile,cbuf,(unsigned)readlength);		
	        for(offset=0;offset<length;++offset)
			{	
				ibuf[offset]=mulaw[cbuf[offset]]*4;			
			}
		    read=length*2;
	    }
	    else if (mi->dwFormat==27) // A-Law
	    {	unsigned char *cbuf;
	    	ibuf=(unsigned short far *)buf;
			readlength=lBytes/2L;                                       
			cbuf=buf+readlength;
			length=_lread(mi->nFile,cbuf,(unsigned)readlength);		
	        for(offset=0;offset<length;++offset)
			{	
				ibuf[offset]=alaw[cbuf[offset]]*8;			
			}
		    read=length*2;
	    }
		else if (mi->dwFormat==2) // 8-bit linear
	    {	short t;
		    _lread(mi->nFile,buf,(unsigned)lBytes);
    		for (t=0;t<(short)lBytes;t++)
	    	{
	    		buf[t]=buf[t]+128;
	    	}
	    	read=lBytes;		    	    
	    }
	    else if (mi->dwFormat==3) // 16-bit linear
	    {	short t;
		    unsigned char tmp;  
		    _lread(mi->nFile,buf,(unsigned)lBytes);	    
        	for (t=0;t<(short)lBytes;t+=2)
	 	 	{	tmp=buf[t];
	 	 		buf[t]=buf[t+1];
	 	 		buf[t+1]=tmp;
	 	 	}           
	 	 	read=lBytes;
	    }
	    
		GlobalUnlock(hInput);
 	}
 	return read;	
}