#include "xfms.h"

short TestFunction(COOLINFO *ci, short i, DWORD dw)
{
 	return (short)(*ci->lpTestFunction)(i,dw);
}

short ReadData(COOLINFO *ci, char *data, long offset, long amount)
{
 	return (short)(*ci->lpReadData)(data,offset,amount);
}

short WriteData(COOLINFO *ci, char *data, long offset, long amount)
{
 	return (short)(*ci->lpWriteData)(data,offset,amount);
}
            
short CutData(COOLINFO *ci, DWORD dwOffset, DWORD dwBytes)
{
 	return (short)(*ci->lpCutData)(dwOffset,dwBytes);
}   

short InsertBlankData(COOLINFO *ci, DWORD dwOffset, DWORD dwBytes)
{	
	return (short)(*ci->lpInsertBlankData)(dwOffset,dwBytes);
}         
            
void DelayWriteInit(COOLINFO *ci, WORD uiSize, long lOffset, long lLength)
{
 	(*ci->lpDelayWriteInit)(uiSize, lOffset, lLength);
 	return;
}

void DelayWriteDestroy(COOLINFO *ci)
{
 	(*ci->lpDelayWriteDestroy)();
 	return;
}          

void DelayWrite(COOLINFO *ci, char far *data,WORD uiBytes)
{	(*ci->lpDelayWrite)(data, uiBytes);
	return;
}

BOOL ProgressMeter(COOLINFO *ci, DWORD dwCurrent, DWORD dwTotal)
{
 	if (ci->lpProgressMeter)
		return (BOOL)(*ci->lpProgressMeter)(dwCurrent, dwTotal);
	else
		return (!(*ci->lpProgressCanceled));
}                                                           

void ProgressCreate(COOLINFO *ci, LPCSTR szText, HWND hWndParent)
{
 	if (ci->lpProgressCreate)
		(*ci->lpProgressCreate)(szText, hWndParent);
}                                   

void ProgressDestroy(COOLINFO *ci)
{
 	if (ci->lpProgressDestroy)
		(*ci->lpProgressDestroy)();
}

void CenterDialog(COOLINFO *ci, HWND hWndDlg)
{
 	(*ci->lpCenterDialog)(hWndDlg,0);
}

BOOL PresetsInit(COOLINFO FAR *ci, HWND hWndDlg, LPCSTR szGroupName)
{
	return (*ci->lpPresetsInit)(hWndDlg, szGroupName, ci->szIniFile);
}

BOOL HandleID_PRESETS(COOLINFO FAR *ci, HWND hWndDlg, LPCSTR szGroupName, WPARAM wParam, LPARAM lParam)
{
 	return (*ci->lpHandleID_PRESETS)(ci, hWndDlg, szGroupName, wParam, lParam);
}

void HandleID_ADD(COOLINFO FAR *ci, HWND hWndDlg, LPCSTR szGroupName)
{
 	(*ci->lpHandleID_ADD)(ci, hWndDlg, szGroupName);
}   

void HandleID_DEL(COOLINFO FAR *ci, HWND hWndDlg, LPCSTR szGroupName)
{
 	(*ci->lpHandleID_DEL)(hWndDlg, szGroupName);
}

void HandleID_PRESETNAME(COOLINFO FAR *ci, HWND hWndDlg)
{   
	(*ci->lpHandleID_PRESETNAME)(hWndDlg);
}
              
WORD GraphCreate(COOLINFO FAR *ci, short left, short right, 
				   short min, short max, short leftval, short rightval)
{	
	return (WORD)(*ci->lpGraphCreate)(left,right,min,max,leftval,rightval);
}   

void GraphSetDialog(COOLINFO FAR *ci, WORD hGraph, HWND hWndDlg, WORD uiControl, WORD uiDisplay)
{
 	(*ci->lpGraphSetDialog)(hGraph, hWndDlg, uiControl, uiDisplay);
}

short GraphCount(COOLINFO FAR *ci, WORD hGraph)
{
 	return (short)(*ci->lpGraphCount)(hGraph);
}          

POINT GraphGetPoint(COOLINFO FAR *ci, WORD hGraph, short iIndex)
{   POINT point;
 	(*ci->lpGraphGetPoint)(hGraph, iIndex, (POINT FAR *)&point);
 	return point;
}

void GraphSetPoint(COOLINFO FAR *ci, WORD hGraph, short iWhich, POINT point, BOOL bEndPoint)
{	
	(*ci->lpGraphSetPoint)(hGraph,iWhich,point,bEndPoint);
}

double GraphGetValueAt(COOLINFO FAR *ci, WORD hGraph, double xvalue)
{   double y;
 	(*ci->lpGraphGetValueAt)(hGraph, xvalue, (double far *)&y);
 	return y;
}

void GraphDraw(COOLINFO FAR *ci, WORD hGraph, HDC hDC)
{
 	(*ci->lpGraphDraw)(hGraph, hDC);
}

void GraphClear(COOLINFO FAR *ci, WORD hGraph)
{
	(*ci->lpGraphClear)(hGraph);
}

void GraphCopy(COOLINFO FAR *ci, WORD hDest, WORD hSrc)
{
	(*ci->lpGraphCopy)(hDest,hSrc);
}

void GraphInverse(COOLINFO FAR *ci, WORD hGraph)
{
	(*ci->lpGraphInverse)(hGraph);
}

void GraphDestroy(COOLINFO FAR *ci, WORD hGraph)
{
 	(*ci->lpGraphDestroy)(hGraph);
}

short GraphHandleWM_LBUTTONDOWN(COOLINFO FAR *ci, WORD hGraph, POINT pCursor)
{
 	return (short)(*ci->lpGraphHandleWM_LBUTTONDOWN)(hGraph, pCursor);
}

short GraphHandleWM_LBUTTONUP(COOLINFO FAR *ci, WORD hGraph, POINT pCursor)
{
 	return (short)(*ci->lpGraphHandleWM_LBUTTONUP)(hGraph, pCursor);
}

short GraphHandleWM_LBUTTONDBLCLK(COOLINFO FAR *ci, WORD hGraph, POINT pCursor)
{
 	return (short)(*ci->lpGraphHandleWM_LBUTTONDBLCLK)(hGraph, pCursor);
}

short GraphHandleWM_MOUSEMOVE(COOLINFO FAR *ci, WORD hGraph, POINT pCursor)
{
 	return (short)(*ci->lpGraphHandleWM_MOUSEMOVE)(hGraph, pCursor);
}

void GraphSetDblClkScales(COOLINFO FAR *ci, WORD hGraph, double sc1,double of1,short mag1,double sc2,double of2, short mag2,WORD wStyle)
{
 	(*ci->lpGraphSetDblClkScales)(hGraph,sc1,of1,mag1,sc2,of2,mag2,wStyle);
}

void GraphSetDblClkNames(COOLINFO FAR *ci, WORD hGraph,LPCSTR ept1, LPCSTR epu1, LPCSTR ept2, LPCSTR epu2)
{
 	(*ci->lpGraphSetDblClkNames)(hGraph,ept1,epu1,ept2,epu2);
}

void GetTempName(COOLINFO FAR *ci, LPSTR szThree, LPSTR szFilename)
{
 	(*ci->lpGetTempName)(szThree,szFilename);
} 

void SetWindowType(COOLINFO FAR *ci, short type)
{	
	(*ci->lpSetWindowType)(type);
}   

void WindowFFT(COOLINFO FAR *ci, float far *data, short size, BOOL bStereo)
{
 	(*ci->lpWindowFFT)(data, size, bStereo);
}   

void IWindowFFT(COOLINFO FAR *ci, float far *data, BOOL bStereo)
{
 	(*ci->lpIWindowFFT)(data, bStereo);
}

void FFT(COOLINFO FAR *ci, float far *data, short nn, short isign)
{
 	(*ci->lpFFT)(data,nn,isign,0,nn-1);
}  

void LFFT(COOLINFO FAR *ci, double *real, double *imag, long nn, short isign)
{
 	(*ci->lpLFFT)(real,imag,nn,isign);
}

void SetFFT16bit(COOLINFO FAR *ci, float far *data, short far *in, short iSamples)
{
 	(*ci->lpSetFFT16bit)(data, in, iSamples);
}

void SetFFT8bit(COOLINFO FAR *ci, float far *data, unsigned char far *in, short iSamples)
{
 	(*ci->lpSetFFT8bit)(data, in, iSamples);
}   

void SetStereoFFT16bit(COOLINFO FAR *ci, float far *data, short far *left, short far *right, short iSamples)
{
 	(*ci->lpSetStereoFFT16bit)(data,left,right,iSamples);
}   

void SetStereoFFT8bit(COOLINFO FAR *ci, float far *data, unsigned char far *left, unsigned char far *right, short iSamples)
{
 	(*ci->lpSetStereoFFT8bit)(data,left,right,iSamples);
}   
                
void SetStereoFFT16bitInterleaved(COOLINFO FAR *ci, float FAR *data, short far *in, short iSamples)
{	
	(*ci->lpSetStereoFFT16bitInterleaved)(data, in, iSamples);
}

void SetStereoFFT8bitInterleaved(COOLINFO FAR *ci, float FAR *data, unsigned char far *in, short iSamples)
{
	(*ci->lpSetStereoFFT8bitInterleaved)(data, in, iSamples);
}

void GetStereoFFT16bitInterleaved(COOLINFO FAR *ci, float FAR *data, short far *in, short iSamples, short iOperation)
{
	(*ci->lpGetStereoFFT16bitInterleaved)(data, in, iSamples, iOperation);
}

void GetStereoFFT8bitInterleaved(COOLINFO FAR *ci, float FAR *data, unsigned char far *in, short iSamples, short iOperation)
{
	(*ci->lpGetStereoFFT8bitInterleaved)(data, in, iSamples, iOperation);
}  

void SetXfmVar(COOLINFO FAR *ci, HANDLE hVars, short offset, short length, void far *mem)
{
 	(*ci->lpSetXfmVar)(hVars, offset, length, mem);
}

long CallXfm(COOLINFO FAR *ci, LPCSTR szXfmName, HANDLE hVars, DWORD losamp, DWORD hisamp, BOOL bShowMeter)
{
 	return (long)(*ci->lpCallXfm)(szXfmName,hVars,losamp,hisamp,bShowMeter,0L);
}

HANDLE CreateXfmVars(COOLINFO FAR *ci, LPCSTR szXfmName)
{
 	return (HANDLE)(*ci->lpCreateXfmVars)(szXfmName);
}

short DeleteXfmVars(COOLINFO FAR *ci, LPCSTR szXfmName, HANDLE hXfmVars)
{
 	return (short)(*ci->lpDeleteXfmVars)(szXfmName,hXfmVars);
}

DWORD Convolute(COOLINFO FAR *ci,WORD wChannels, WORD wBlockAlign, DWORD dwLoSample, 
	DWORD dwHiSample, BOOL bCombine, WORD wNumImpulses,HANDLE hImpulseIn, long lImpulseSize, 
	long lDelaySamples, LPCSTR szProgressText, FARPROC lpfnReadData, FARPROC lpfnWriteData)
{
	return (DWORD)(*ci->lpConvolute)(wChannels,wBlockAlign,dwLoSample,dwHiSample,bCombine, wNumImpulses, hImpulseIn,lImpulseSize,
		lDelaySamples, szProgressText,lpfnReadData, lpfnWriteData);
}	
