/**************************************************************************
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 *  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
 *  PURPOSE.
 *
 *  Copyright (c) 1992-1996 Syntrillium Software Corporation.  All Rights Reserved.
 * 
 **************************************************************************/
#include <windows.h>
#include <math.h>        

#include "xfmsdll.c" 
#include "resource.h"

#pragma pack(1)

// Usa an Internal Structure for your function, and access it through a handle
typedef struct distort_tag
{	WORD		hGraph;					/* Graphical input device */
} DISTORT;

#pragma pack()
// Structure Definition for Preset and Script handling
// list variable types as:  c char
//							b BOOL
//							i short or WORD 
//							f float
//							l long or DWORD
//							d double
//							g GRAPH
//							h Global Handle  
//							s String of 256 chars
//
// Structure Preset Vars: 'y' to include in presets, 'n' to ignore.

#define STRUCTDEFINITION "g"
#define PRESETDEFINITION "y"
#define TRANSFORMNAME "Distortion"

//#define dsetitem(Id,dVal) sprintf(tmp,"%g",dVal); SetDlgItemText(hWndDlg,Id,tmp)

#define MEMSIZE 64000

//HANDLE hAmp;
//DISTORT far * pAmp;

BOOL WINAPI DllMain (HANDLE hModule, DWORD fdwReason, LPVOID lpReserved)
{
   switch (fdwReason)
   {
      case DLL_PROCESS_ATTACH:
        /* Code from LibMain inserted here.  Return TRUE to keep the
            DLL loaded or return FALSE to fail loading the DLL.
 
            You may have to modify the code in your original LibMain to
            account for the fact that it may be called more than once.
            You will get one DLL_PROCESS_ATTACH for each process that
            loads the DLL. This is different from LibMain which gets
            called only once when the DLL is loaded. The only time this
            is critical is when you are using shared data sections.
            If you are using shared data sections for statically
            allocated data, you will need to be careful to initialize it
            only once. Check your code carefully.
 
            Certain one-time initializations may now need to be done for
            each process that attaches. You may also not need code from
            your original LibMain because the operating system may now
            be doing it for you.
         */
         break;
 
      case DLL_THREAD_ATTACH:
         /* Called each time a thread is created in a process that has
            already loaded (attached to) this DLL. Does not get called
            for each thread that exists in the process before it loaded
            the DLL.
 
            Do thread-specific initialization here.
         */
         break;
 
      case DLL_THREAD_DETACH:
         /* Same as above, but called when a thread in the process
            exits.
 
            Do thread-specific cleanup here.
         */
         break;
 
      case DLL_PROCESS_DETACH:
         /* Code from _WEP inserted here.  This code may (like the
            LibMain) not be necessary.  Check to make certain that the
            operating system is not doing it for you.
         */
         break;
   }
 
   /* The return value is only used for DLL_PROCESS_ATTACH; all other
      conditions are ignored.  */
   return TRUE;   // successful DLL_PROCESS_ATTACH
}
// Fill XFMQUERY structure with information regarding this file filter

__declspec(dllexport) short FAR PASCAL QueryXfm(XFMQUERY far * cq)
{   lstrcpy(cq->szName,TRANSFORMNAME);         
	lstrcpy(cq->szCopyright,"");                            
	
	cq->wSupports=XFM_MONO16|XFM_STEREO16;
	cq->dwFlags=XF_TRANSFORM|XF_USESPRESETSAPI|XF_USESGRAPHAPI|XF_MUSTHIGHLIGHT;
	cq->dwUserDataLength = sizeof(DISTORT);
	lstrcpy(cq->szStructDef,STRUCTDEFINITION);
	lstrcpy(cq->szPresetDef,PRESETDEFINITION);
	lstrcpy(cq->szToolHelp,"Add Distortion/Grunge/Overdrive effects");
	return XFM_VALIDLIBRARY;
} 

__declspec(dllexport) BOOL FAR PASCAL XfmInit(COOLINFO far *ci)
{	DISTORT FAR * lpAmp;
	HANDLE hDistort;
	hDistort=ci->hUserData;         
	lpAmp=(DISTORT FAR *)GlobalLock(hDistort);
	if (!lpAmp)
		return FALSE;
	lpAmp->hGraph=GraphCreate(ci,0,16384,0,16384,0,16384); 
	GlobalUnlock(hDistort);
	return TRUE;
}

__declspec(dllexport) BOOL FAR PASCAL XfmDestroy(COOLINFO far *ci)
{   DISTORT FAR * lpAmp;
	HANDLE hDistort;
	hDistort=ci->hUserData;         
	lpAmp=(DISTORT FAR *)GlobalLock(hDistort);
	if (!lpAmp)
		return FALSE;
 	if (lpAmp->hGraph)
 	{	GraphDestroy(ci,lpAmp->hGraph);
 		lpAmp->hGraph=(WORD)-1;
 	}                   
 	GlobalUnlock(hDistort);
 	
}

__declspec(dllexport) BOOL FAR PASCAL XfmSetup(HWND hWnd, HINSTANCE hInst, COOLINFO far *ci)
{	short nRc;
	FARPROC lpfnDIALOGMsgProc;
	
	lpfnDIALOGMsgProc = GetProcAddress(hInst,(LPCSTR)MAKELONG(100,0));
	
	nRc = DialogBoxParam((HINSTANCE)hInst,(LPCSTR)MAKEINTRESOURCE(IDD_TRANSFORM), (HWND)hWnd, (DLGPROC)lpfnDIALOGMsgProc,(DWORD)ci);
	
	return nRc;
}

#define LIMIT 2048
#define GOTO 32767

__declspec(dllexport) BOOL FAR PASCAL XfmDo(COOLINFO far *ci)
{	DISTORT FAR * lpAmp = NULL;
	HANDLE hDistort = NULL;
	DWORD losamp, hisamp;
	
	HANDLE hBigMem=NULL;
	unsigned char *data;
	short *datai;
	DWORD length;
	DWORD offset;
	DWORD origsize;                
	DWORD maxsize; 
	
	HANDLE hInts=NULL;
	short far *pInts=NULL;   
	short i;
	
    hInts=GlobalAlloc(GMEM_MOVEABLE,16385*sizeof(short));
    if (!hInts) return 1;
    pInts=(short far *)GlobalLock(hInts);
    if (!pInts)
    {	GlobalFree(hInts);
    	return 1;
    }
    
    hDistort=ci->hUserData;         
	lpAmp=(DISTORT FAR *)GlobalLock(hDistort);
	losamp=ci->dwLoSample;
	hisamp=ci->dwHiSample;
	
	maxsize=MEMSIZE/4;
 	maxsize=(maxsize/16)*16;
    
	hBigMem=GlobalAlloc(GMEM_MOVEABLE,(DWORD)MEMSIZE+1000);
	if (hBigMem==NULL)
		return 1;
  
 	data=GlobalLock(hBigMem);
	if (data==NULL) 
	{	GlobalFree(hBigMem);
		hBigMem=0;
		return 1;
	}
	datai=(short *)data;
    
    ProgressCreate(ci,"Distorting Selection",NULL);
    
    origsize=length=(hisamp-losamp+1)*ci->wBlockAlign;
 	offset=losamp*ci->wBlockAlign;
 	
// build short conversion table
	for (i=0;i<16385;i++)
	{	pInts[i]=min(16383,(short)GraphGetValueAt(ci,lpAmp->hGraph,(double)i/16384.0));
		
 	}
 	
	while (length!=0)
 	{	DWORD amount,amount2;
 	 	DWORD t;
		short value;
 		short m2;
 		
		amount=length;
		if (amount>maxsize) amount=maxsize;
		amount2=amount/2;
		length-=amount;
		ReadData(ci,data,offset,amount);
		
		if (ci->wChannels==1)
 	 	{	for (t=0;t<amount2;t++)
 	        {	value=datai[t];
 	         	if (value<0)
 	         	{	value=-value; 	         	    	
					m2=value&1;
 	         		value=(short)(((pInts[value>>1])<<1)+m2);
 	         		datai[t]=-value; 	         			
 	         	}
				else
				{	m2=value&1;
 	         		value=(short)(((pInts[value>>1])<<1)+m2);
 	         		datai[t]=value; 	         		
				}
 	        }
 	    }
 	 	else
 	 	{	for (t=0;t<amount2;)
 	    	{	
 	    	 	value=datai[t];
 	         	if (value<0)
 	         	{	value=-value; 	         	    	
					m2=value&1; 	         		
 	         		value=(short)(((pInts[value>>1])<<1)+m2);
 	         		datai[t]=-value; 	         			
				}
				else
				{	m2=value&1; 	         		
 	         		value=(short)(((pInts[value>>1])<<1)+m2);
 	         		datai[t]=value; 	         			
				}
 	         	
 	    	 	t++;
 	    	 	
 	    	 	value=datai[t];
 	         	if (value<0)
 	         	{	value=-value; 	         	    	
 	         		m2=value&1; 	         		
 	         		value=(short)(((pInts[value>>1])<<1)+m2);
 	         		datai[t]=-value; 	         			
				}                
 	         	else
				{	m2=value&1; 	         		
 	         		value=(short)(((pInts[value>>1])<<1)+m2);
 	         		datai[t]=value;
				}
 	    	 	t++;
 	    	} 	        
 	    }           
 	    
 	 	WriteData(ci,data,offset,amount);
 	 	offset+=amount;
 	 	ProgressMeter(ci,(origsize-length),origsize);
		if (*(ci->lpProgressCanceled)) 
			break;
 	 
	}
    
    ProgressDestroy(ci);
    
	GlobalUnlock(hInts);
	GlobalFree(hInts);
	
	GlobalUnlock(hBigMem);
	GlobalFree(hBigMem);
	hBigMem=0;
    
 	GlobalUnlock(hDistort);
    return 0;
}
    
void DialogToStruct(COOLINFO FAR *ci, HWND hWndDlg, DISTORT FAR * lpAmp)
{	//char tmp[30];
	                  
	
}

void StructToDialog(COOLINFO FAR *ci, DISTORT FAR *lpAmp, HWND hWndDlg)
{    //char tmp[30];                                               
	 HDC hDC;
	
	 hDC=GetDC(hWndDlg);
	 GraphDraw(ci,lpAmp->hGraph,hDC);
	 ReleaseDC(hWndDlg,hDC);    
}    
    
long longfromstring(char **cursor)
{   long l=0;
	while ((**cursor!=',') && (**cursor!=0x00))
	{	l=l*10+(long)(**cursor-'0');
		(*cursor)++;	
	}          
	if (**cursor!=0x00)  // skip over comma
		(*cursor)++;
 	
 	return l;
}
    
void CopyToDlgItem(HWND hWndDlg, short iControl,COOLINFO far *ci,HANDLE hDistort,  DISTORT FAR *lpAmp)
{   char m[80];
	wsprintf(m,"%ld,%d,%ld",lpAmp,hDistort,ci);
	SetDlgItemText(hWndDlg,iControl,m);	
}                                      

void CopyFromDlgItem(HWND hWndDlg, short iControl,  COOLINFO far **ci, HANDLE *hDistort, DISTORT FAR **lpAmp)
{	char m[80];
	char *cursor;         
	
	GetDlgItemText(hWndDlg,iControl,m,80);
	if (m[0]==0x00)
	{	*lpAmp=NULL;
		*hDistort=0;
		*ci=NULL;

		return;
	}                            
	cursor=m;
	*lpAmp=(DISTORT FAR *)longfromstring(&cursor);
	*hDistort=(HANDLE)longfromstring(&cursor);
	*ci=(COOLINFO far *)longfromstring(&cursor);
}    
    
__declspec(dllexport) BOOL FAR PASCAL DIALOGMsgProc(HWND hWndDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{   DISTORT FAR * lpAmp = NULL;
	HANDLE hDistort = NULL;
	COOLINFO far *ci=NULL;
	
	switch(Message)
   	{case WM_INITDIALOG:
		{	ci=(COOLINFO far *)lParam;
			hDistort=ci->hUserData;         
			lpAmp=(DISTORT FAR *)GlobalLock(hDistort);
			
			CenterDialog(ci,hWndDlg);
	        GraphSetDblClkScales(ci,lpAmp->hGraph,1.0/16384.0,0,100,1.0/16384.0,0,100,1);
			GraphSetDblClkNames(ci,lpAmp->hGraph,"Input Sample","dB","Output Sample","dB");
			GraphSetDialog(ci,lpAmp->hGraph,hWndDlg,IDC_RECT,IDC_DISPLAY);
	        
	        if (!PresetsInit(ci, hWndDlg, TRANSFORMNAME))
	        {   WritePrivateProfileString(TRANSFORMNAME,"Item1",
          	  	"Fuzz,3,20,0,0,1033,1033,1047,2827,1838,1838,2720,2722,2721,5011,3667,3667,4292,4294,4293,6874,5301,5301,6179,6179,6229,8802,7226,7226,7904,7902,7905,10858,8849,8849,9996,10219,9997,13042,11000,10862,16384,16384",
          	  	ci->szIniFile);
          	  	WritePrivateProfileString(TRANSFORMNAME,"Item2",	
				"Quantize,3,18,0,0,2595,2596,2596,3269,3268,3269,3269,4115,4114,4115,4115,5181,5180,5181,5181,6522,6521,6522,6522,8211,8210,8211,8211,10337,10336,10337,10337,13014,13013,13014,13014,16384,16384,16384",
				ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item3","No Distortion,3,2,0,0,16384,16384,none",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item4","Overdriven,3,9,0,0,680,3276,1570,6553,2931,9637,4763,12271,7118,14392,10102,15741,12772,16319,16384,16384",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item5","Cranked!,3,12,0,0,2826,15034,3297,16126,4030,16384,4920,16255,5862,14906,6647,12400,7642,8738,9003,4883,10992,2377,14551,514,16384,0",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item6","Bad FM Reception,3,6,0,0,522,578,523,3598,1099,3084,1413,1413,16384,16384",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item7","Light Fuzz,3,5,0,0,209,706,785,0,837,771,16384,16384",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item8","Maximum Loud,3,3,0,0,471,15355,16384,16384",ci->szIniFile);
                PresetsInit(ci,hWndDlg,TRANSFORMNAME);
          	}
	        
			CopyToDlgItem(hWndDlg,IDC_STORAGE,ci,hDistort,lpAmp);
			StructToDialog(ci, lpAmp, hWndDlg);
	        
			// using scripts, auto OK it.
	 		if ((ci->iScriptFile!=-1) && (!ci->iScriptDialogStop))
		 		PostMessage(hWndDlg,WM_COMMAND,IDOK,0L);	
		}	
    		
         break; /* End of WM_INITDIALOG                                 */

     case WM_CLOSE:
         /* Closing the Dialog behaves the same as Cancel               */
         PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
         break; /* End of WM_CLOSE                                      */
         
         
     case WM_LBUTTONDOWN:
          {	POINT here;
    	  	short whichpoint;
          	CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         	here.x=(int)((short)LOWORD(lParam));
		    here.y=(int)((short)HIWORD(lParam));
            whichpoint=GraphHandleWM_LBUTTONDOWN(ci,lpAmp->hGraph,here);
          }  
            break;
     case WM_LBUTTONUP:
          {	POINT here;
    	  	short whichpoint;
          	CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         	here.x=(int)((short)LOWORD(lParam));
		    here.y=(int)((short)HIWORD(lParam));
          	whichpoint=GraphHandleWM_LBUTTONUP(ci,lpAmp->hGraph,here);
          }  
            break; 
 	case WM_MOUSEMOVE:
          {	POINT here;
    	  	short whichpoint;
          	CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         	here.x=(int)((short)LOWORD(lParam));
		    here.y=(int)((short)HIWORD(lParam));
          	whichpoint=GraphHandleWM_MOUSEMOVE(ci,lpAmp->hGraph,here);
          }  
            break;
    case WM_LBUTTONDBLCLK:
         {	POINT here;
			CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         	here.x=(int)((short)LOWORD(lParam));
		    here.y=(int)((short)HIWORD(lParam));
			GraphHandleWM_LBUTTONDBLCLK(ci,lpAmp->hGraph,here);			
         }
    	 break;            
          
    case WM_PAINT:
    	 {HDC hDC;
    	  PAINTSTRUCT ps;
    	  CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
          hDC=BeginPaint(hWndDlg,&ps);
          GraphDraw(ci,lpAmp->hGraph,hDC);
          EndPaint(hWndDlg,&ps);
          return FALSE;
    	 };

    
   case WM_COMMAND:
         CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         switch(LOWORD(wParam))
           {  case ID_HLP:
           		 WinHelp(hWndDlg,XFM_HELPFILE,HELP_KEY,(DWORD)((LPSTR)"Distort"));
                 break;  
              case ID_PRESETS:
                 if (HandleID_PRESETS(ci, hWndDlg, TRANSFORMNAME, wParam, lParam))
                 {	StructToDialog(ci, lpAmp, hWndDlg);                    
                 }
                 break;
              case ID_ADD:
              	DialogToStruct(ci, hWndDlg, lpAmp);
              	HandleID_ADD(ci, hWndDlg, TRANSFORMNAME);       
              	break; 	 
              case ID_DEL:
              	HandleID_DEL(ci, hWndDlg, TRANSFORMNAME);
              	break;
              case ID_PRESETNAME:
              	HandleID_PRESETNAME(ci, hWndDlg);
              	break;	
                case IDOK:
              {	  if (GetFocus()==GetDlgItem(hWndDlg,ID_PRESETS))
                  {	PostMessage(hWndDlg,WM_COMMAND,ID_PRESETS,MAKELONG(GetDlgItem(hWndDlg,ID_PRESETS),LBN_DBLCLK));
                    break;
                  }
              	  DialogToStruct(ci, hWndDlg,lpAmp);
                   	
             	  GlobalUnlock(hDistort); 
             	  hDistort=NULL;
                  EndDialog(hWndDlg, TRUE);
               }
            	 break;                                                    
              case IDCANCEL:
                 /* Ignore data values entered into the controls        */
                 /* and dismiss the dialog window returning FALSE       */
                 GlobalUnlock(hDistort);
                 hDistort=NULL;
                 EndDialog(hWndDlg, FALSE);
                 break;
           }
         break;    /* End of WM_COMMAND                                 */

    default:
		return FALSE;
   }
 
 	return TRUE;
}
