///////////////////////////////////////////////////////////////////////////////
//
//  MACTOWAV.CPP - a real hack!
//
//  by Phil Hord
//  PhilHord@AOL.com
//
//	Date:		January 7, 1995
//
//	Purpose:	Converts Macintosh Sound resources to Windows .WAV files
//				Written for PC's.  Might work on a Mac.
//
//	Compiler:	Microsoft Visual C++ 1.51
//				Compiles with no errors or warnings.  
//				Use my makefile.  
//				Will need work to compile under 2.0
//
//	Disclaimer:	This code worked for me.  If it works for you, too, please
//				let me know.  If it doesn't work for you, too bad.  I never
//				said it would, and if you say I did I'll call you a liar.
//				But if it doesn't work I want to know why, so please tell
//				me under what conditions it failed.
//
///////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <dos.h>
#include <io.h>

void CrackSnd(FILE *infile, char *Name, char *alt, unsigned long oData);
void WriteWave(FILE *infile, unsigned long oData, unsigned long cbData, unsigned int Frequency, char *Name, char *alt);
void MacToWav(char *str);
int longrename(char *oldname, char *newname, char *alt);
int longremove(char *filename, char *alt);
int longexist(char *filename);


#define FALSE 0;
#define TRUE 1;

int Verbose=FALSE;
int ShortNames=FALSE;
int NoOutput=FALSE;
int DoRename=TRUE;

void MacLong(unsigned long *x)
{
	unsigned char *p=(unsigned char *)x;
	unsigned char c;
	
	c=p[0]; p[0]=p[3]; p[3]=c;
	c=p[1]; p[1]=p[2]; p[2]=c;
}

void MacShort(unsigned int *x)
{
	unsigned char *p=(unsigned char *)x;
	unsigned char c;
	
	c=p[0]; p[0]=p[1]; p[1]=c;
}

// find filename in a path string
char *fname(char *str) 
{
	char *p=strrchr(str, '\\'); 
	if (!p) p=strrchr(str,':'); 
	return p+1;
}

void main (int argc, char **argv)
{
	printf("Macintosh SND resource -> Windows .WAV converter\n");
	printf("Version 1.0 by Phillip M Hord -- January 8, 1995\n");
	if (argc<2)
	{
		printf("\nUsage:  MacToWav [-S] [-L] [-V] <filespec> <filespec> ...\n");
		printf("   -V turns on verbose mode (-V- turns it back off on subsequent files)\n");
		printf("   -S uses short filenames instead of embedded resource names\n");
		printf("   -N No Output, show information only, do not generate .WAV files\n");
		printf("   -O Overwrite existing files;\n   (default is to rename output files to avoid name collisions).\n");
		printf("   <filespec> should be a Macintosh SND file resource fork.\n\n");
		exit(1);
	}
	
	struct _find_t fileinfo;
	for (int x=1; x<argc; x++)
	{       
		if (argv[x][0]=='-' || argv[x][0]=='/')
		{
			switch(toupper(argv[x][1]))
			{
				case 'V':
					// verbose on
					Verbose=TRUE;
					if (argv[x][2]=='-')
						Verbose=FALSE;
					break;
	
				case 'S':
					// verbose on
					ShortNames=TRUE;
					if (argv[x][2]=='-')
						ShortNames=FALSE;
					break;

				case 'N':
					// verbose on
					NoOutput=TRUE;
					if (argv[x][2]=='-')
						NoOutput=FALSE;
					break;

				case 'O':
					// Rename to avoid overwrites
					DoRename=FALSE;
					if (argv[x][2]=='-')
						DoRename=TRUE;
					break;

				default:
					printf("** Unrecognized switch: \"%s\".",argv[x]);
					break;
			}
			continue;
		}

		char path[200];
		if (_dos_findfirst( argv[x], _A_NORMAL, &fileinfo )==0)
		{
			// get path into string for relative references
			strcpy(path, argv[x]);
			char *p=fname(path);
			if (p) *(p)=0;
			p=path+strlen(path);
            
			do
			{
				strcpy(p, fileinfo.name);
	            //printf("\nLooking at %s, %s, %s", argv[x], path, p);
				MacToWav(path);
			} while (_dos_findnext(&fileinfo)==0);
		}
		else
			printf("\n** Couldn't find any files matching %s", argv[x]);
	}
}

void MacToWav(char *str)
{
	FILE *infile = fopen(str, "rb");
	if (infile == NULL)
	{
		printf("\n** Unable to open input file %s.  ", str);
		return;
	}
	
	
	//
	// Read the offsets and lengths of the data and map
	//
	
	fseek(infile, 0, SEEK_END);
	unsigned long fsize = ftell(infile);
	fseek(infile, 0, SEEK_SET);
	
	unsigned long oData, oMap, cbData, cbMap;
	
	fread(&oData, sizeof(oData), 1, infile);  MacLong(&oData);
	fread(&oMap, sizeof(oMap), 1, infile);    MacLong(&oMap);
	fread(&cbData, sizeof(cbData), 1, infile);MacLong(&cbData);
	fread(&cbMap, sizeof(cbMap), 1, infile);  MacLong(&cbMap);
    
    if (oData > fsize || 
    	oMap > fsize || 
    	(oData+cbData) > fsize || 
    	(oMap+cbMap) > fsize ||
    	(oData < oMap && oData+cbData > oMap) ||		// check for overlap
    	(oMap < oData && oMap+cbMap > oData) ||
    	cbData == 0 || 
    	cbMap == 0
    	)
    {
//    	printf("Not a Mac resource file.");
    	fclose(infile);
    	return;
    }
    
	printf("\nFile: %-12s   ", str);
	
	//
	// Read the offsets of the Types and Names from the Map
	//
	unsigned int oTypeList, oNameList, nTypes;
	
	fseek(infile, oMap+24, SEEK_SET);		// go to map record, skip reserved crap
	fread(&oTypeList, sizeof(oTypeList), 1, infile);  MacShort(&oTypeList);
	fread(&oNameList, sizeof(oNameList), 1, infile);  MacShort(&oNameList);
	fread(&nTypes, sizeof(nTypes), 1, infile);        MacShort(&nTypes);
	nTypes++;								// it's 0-based.  Make it 1-based.

	//
	// Scan the types looking for "snd " types.  (Discard all others)
	//
	
	char tmpType[5];
	char Name[255];
	unsigned int nRes, oRef, oName;
	unsigned long oData2;
	
	tmpType[4]=0;
	for (unsigned int x = 0; x<nTypes; x++)	
	{
		fseek(infile, oMap + oTypeList + x*8 + 2, SEEK_SET);		// position to Xth resource type block
		fread(tmpType, 4, 1, infile);
		fread(&nRes, 2, 1, infile);		MacShort(&nRes);
		fread(&oRef, 2, 1, infile);		MacShort(&oRef);
		nRes++;
		if (Verbose)
			printf("\n  Resource type: %s;  Items: %d", tmpType, nRes);
		
		for (unsigned int y=0; y<nRes; y++)
		{
			fseek(infile, oMap + oTypeList + oRef+y*12+2, SEEK_SET);	// posn to reference record
			fread(&oName, 2, 1, infile);	MacShort(&oName);
			fread(&oData2, 4, 1, infile);	MacLong(&oData2);
			oData2 &= 0x00FFFFFFL;		// mask off first byte
		
			Name[0]=0;
			if (oName != 0xFFFF)
			{
				//
				// read name for resource
				//
			
				char cbName=0;
				fseek(infile, oMap + oNameList + oName, SEEK_SET);
				fread(&cbName, 1, 1, infile);
				fread(Name, cbName, 1, infile);
				Name[cbName]=0;
			}
			if (Verbose)
			    printf("\n    %d. Name: %-30s  Data at offset %08x", y+1, Name, oData + oData2);
			
			
			if (strcmp(tmpType, "snd ")==0)				// if it's a sound resource, go read it
				CrackSnd(infile, Name, str, oData + oData2 + 4);
		
		}
		
	}

	fclose(infile);
}


void CrackSnd(FILE *infile, char *Name, char *ShortName, unsigned long oData)
{
    if (!Verbose)
    	printf("%-20s   ", Name);
    
	fseek(infile, 0, SEEK_END);
	unsigned long fsize = ftell(infile);
	
	fseek(infile, oData, SEEK_SET);		// skip length lword
	unsigned int Format;
	fread(&Format, 2, 1, infile);	MacShort(&Format);
	if (Format!=1 && Format!=2) 
	{
		printf("Unrecognized format.");
		return;			// we only handle SND Format 1 and 2
	}
	
	unsigned int nTypes;
	fread(&nTypes, 2, 1, infile);	MacShort(&nTypes);


	if (Format==1)
	{
		// I don't know what to do with data formats, so skip them...
		fseek(infile, 6*nTypes, SEEK_CUR);
	}
	
	unsigned int nCmds;
	fread(&nCmds, 2, 1, infile);	MacShort(&nCmds);
	for (unsigned int i=0; i<nCmds; i++)
	{
		unsigned int Cmd, Param1;
		unsigned long Param2;
		fread(&Cmd, 2, 1, infile);	MacShort(&Cmd);
		fread(&Param1, 2, 1, infile);	MacShort(&Param1);
		fread(&Param2, 4, 1, infile);	MacLong(&Param2);
		
		if (Verbose)
			printf("\n      Command: %04X",Cmd);

		if (Cmd == 0x8051 || Cmd == 0x8050)			// I only handle bufferCmd, pointer to data
		{
			unsigned long pos = ftell(infile);
			
			fseek(infile, oData + Param2, SEEK_SET);
			
			unsigned long pData, cbData;
			unsigned int Rate;
			unsigned char Coding, baseFreq;
			
			fread(&pData, 4, 1, infile); 	MacLong(&pData);
			fread(&cbData, 4, 1, infile);	MacLong(&cbData);
			fread(&Rate, 2, 1, infile);		MacShort(&Rate);
			fseek(infile, 2, SEEK_CUR);
			fread(&Coding, 1, 1, infile);
			fread(&baseFreq, 1, 1, infile);
			
			if (Verbose)
				printf("        %08lx - %08lx at %uhz",oData+Param2+22+pData, oData+Param2+22+pData+cbData, Rate);
			
			if (oData+Param2+22+pData+cbData > fsize)
				printf("  Impossible data size.");
			else if (Coding == 0) 		// we only do straight PCM!
			{
				WriteWave(infile, oData+Param2+22+pData, cbData, Rate, Name, ShortName);
			}
			
			fseek(infile, pos, SEEK_SET);
		}
		else
			printf("Unrecognized sound command.  %04X", Cmd);
			
	}
		
}	
	


typedef unsigned int WORD;
typedef unsigned long DWORD;
typedef struct {
	WORD    wFormatTag;       // Format category
    WORD    nChannels;        // Number of channels
    DWORD   nSamplesPerSec;   // Sampling rate
    DWORD   nAvgBytesPerSec;  // For buffering
    WORD    nBlockAlign;      // Block alignments
    WORD	nBitsPerSample;
} WAVHeader;



void WriteWave(FILE *infile, unsigned long oData, unsigned long cbData, unsigned int Frequency, char *Name, char *ShortName)
{
	if (NoOutput) 
		return;
	
	char strName[100];
	strcpy(strName, Name);
	strcat(strName, ".WAV");

	if (DoRename && !ShortNames)
	{
		if (longexist(strName))
		{
			for (int i=1; i<100 && longexist(strName); i++)
				sprintf(strName, "%s.%d.WAV",Name, i);
		}
	}
			
	char altName[100];
	strcpy(altName, fname(ShortName));
    char *p=strrchr(altName, '.');
    if (p) *p=0;
	
	char tmpstr[100];
	strcpy(tmpstr, altName);
   	
   	strcat(altName, ".WAV");
	if (DoRename)
		if (!_access(altName,0))
		{
			for (int i=1; i<100 && !_access(altName,0); i++)
				sprintf(altName, "%0.6s%02d.WAV",tmpstr, i);
		}
    	
    
    // !!!!! Calculate Frequency to be an even divisor of 44100
	Frequency = (unsigned int)44100/(unsigned int(44100.0/float(Frequency) + 0.5));

	if (Verbose)
	{
		if (ShortNames)
			printf("\nWriting %s at %uhz.\n",altName, Frequency);
		else
			printf("\nWriting %s (or %s) at %uhz.\n",strName, altName, Frequency);
	}
	
	WAVHeader hdr;

	hdr.wFormatTag = 1;
	hdr.nChannels=1;
	hdr.nSamplesPerSec = Frequency;
	hdr.nAvgBytesPerSec = Frequency;
	hdr.nBlockAlign = 1;
	hdr.nBitsPerSample = 8;
	
	FILE *outfile = fopen("TEMPWAV.$$$", "wb+");
	if (outfile==NULL) 
	{
		printf("Error opening output file.");
		return;
	}
	
	unsigned int memblock = 30000;
	void *ptr = malloc(memblock);
	if (!ptr)
	{
		printf("Error allocating memory.");
		return;
	}

	unsigned long len;
	fwrite("RIFF",4,1,outfile);
	len = cbData + 16 + 8 + 12 + 8;
	fwrite(&len, 4, 1, outfile);
	
	fwrite("WAVEfmt ",8,1,outfile);
	len = 16;
	fwrite(&len,4,1,outfile);
	fwrite(&hdr, sizeof(hdr), 1, outfile);
	
	fwrite("data", 4, 1, outfile);
	fwrite(&cbData, 4, 1, outfile);
	
	fseek(infile, oData, SEEK_SET);
	while (cbData>0)
	{
		unsigned int i=memblock;
		if (cbData<i) i=int(cbData);
		fread(ptr, i, 1, infile);
		fwrite(ptr, i, 1, outfile);
		cbData -= i;
	}
	fclose(outfile);
	free(ptr);

	// remove any invalid characters
	unsigned int i;
	while ((i=strcspn(strName, "?*\\/'@\":;<>|=\177"))<strlen(strName)) 
		strName[i]='_';
		
	for (i=0; i<strlen(strName); i++)
		if (strName[i]<0) strName[i]='_';
	
	if (ShortNames)
	{
		remove(altName);
		if (rename("TEMPWAV.$$$", altName))     // and rename new file to it
			printf("  Could not rename to %s (%d)",altName, _doserrno);
	}
	else
	{
		longremove(strName, altName);				// try to delete old copy if any
		if (longrename("TEMPWAV.$$$", strName, altName))     // and rename new file to it
			printf("  Could not rename to %s [or %s] (%d)",strName, altName, _doserrno);
	}
	
}



int longrename(char *oldname, char *newname, char *altname)
{
	union  _REGS inregs, outregs;

	inregs.x.ax = 0x7156;
	inregs.x.dx = _FP_OFF( oldname );
	inregs.x.di = _FP_OFF( newname );
   
	_intdos( &inregs, &outregs);
   
	if (outregs.x.ax != 0x7156)			// function supported?
		return outregs.x.cflag?_doserrno:0;
		
	return rename(oldname, altname);	// try short version
}

int longremove(char *filename, char *altname)
{
	union  _REGS inregs, outregs;

	inregs.x.ax = 0x7141;
	inregs.x.dx = _FP_OFF( filename );

	_intdos( &inregs, &outregs);
   
	if (outregs.x.ax != 0x7141)			// function supported?
		return outregs.x.cflag?_doserrno:0;
		
	return remove(altname);	// try short version
}


int longexist(char *filename)
{
	union  _REGS inregs, outregs;

	inregs.x.ax = 0x7143;				// get attributes
	inregs.x.dx = _FP_OFF( filename );
    inregs.x.bx = 0;					// BL = 0 means GET ATTR
	_intdos( &inregs, &outregs);
	
	if (outregs.x.ax != 0x7143)			// function supported?
		return !outregs.x.cflag;		//  return 1 if no error (file found) or 0 if error (not found)
		
	return 0;		// if not supported, then not found
}






