VERSION 2.00
Begin Form dumpster 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Dumpster"
   ClientHeight    =   3210
   ClientLeft      =   315
   ClientTop       =   1890
   ClientWidth     =   6840
   Height          =   3900
   Icon            =   DUMPSTER.FRX:0000
   Left            =   255
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3210
   ScaleWidth      =   6840
   Top             =   1260
   Width           =   6960
   Begin CommonDialog CMDialog1 
      Left            =   5460
      Top             =   1860
   End
   Begin CommandButton cmdSend 
      Caption         =   "&Send"
      Height          =   435
      Left            =   5520
      TabIndex        =   3
      Top             =   1080
      Width           =   1035
   End
   Begin ListBox lstInstrument 
      Height          =   2760
      Left            =   120
      TabIndex        =   1
      Top             =   240
      Width           =   5055
   End
   Begin CommandButton cmdReceive 
      Caption         =   "&Receive"
      Default         =   -1  'True
      Height          =   495
      Left            =   5520
      TabIndex        =   2
      Top             =   300
      Width           =   1035
   End
   Begin MsgBlaster MsgBlaster1 
      Prop8           =   "Click on ""..."" for the About Box ---->"
   End
   Begin Label lblStatus 
      Caption         =   "lblStatus"
      Height          =   195
      Left            =   0
      TabIndex        =   4
      Top             =   3000
      Width           =   6855
   End
   Begin Label MidiNotifyControl 
      Caption         =   "MidiNotifyControl (invisible)"
      Height          =   375
      Left            =   840
      TabIndex        =   0
      Top             =   0
      Visible         =   0   'False
      Width           =   3855
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileOpen 
         Caption         =   "&Open..."
      End
      Begin Menu mnuFileSave 
         Caption         =   "&Save"
      End
      Begin Menu mnuFileSaveAs 
         Caption         =   "Save &As..."
      End
      Begin Menu mnusep2 
         Caption         =   "-"
      End
      Begin Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuSysex 
      Caption         =   "&Sysex"
      Begin Menu mnuSysexReceive 
         Caption         =   "&Receive..."
      End
      Begin Menu mnuSysexSend 
         Caption         =   "&Send,,,"
      End
   End
   Begin Menu Options 
      Caption         =   "&Options"
      Begin Menu MidiDevices 
         Caption         =   "Midi Devices..."
      End
   End
   Begin Menu mnuHelp 
      Caption         =   "&Help"
      Begin Menu mnuHelpContents 
         Caption         =   "&Contents"
      End
      Begin Menu mnusep 
         Caption         =   "-"
      End
      Begin Menu mnuHelpAbout 
         Caption         =   "&About"
      End
   End
End
Option Explicit

Sub cmdReceive_Click ()

    If gbFileModified Then
	If AskSave() = IDCANCEL Then
	    Exit Sub
	End If
    End If

    SetFilename UNTITLED_NAME
    gbFileModified = False
    
    Load frmSysexReceive
    frmSysexReceive.Show 1
    statusupdate

End Sub

Sub cmdSend_Click ()
    frmSysexSend.Show 1
End Sub

Sub Form_Load ()

    dumpsterSetup

    statusupdate

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

    If gbFileModified Then
	If AskSave() = IDCANCEL Then
	    Cancel = True
	End If
    End If

End Sub

Sub Form_Unload (Cancel As Integer)

    dumpsterCleanup

End Sub

Sub lstInstrument_DblClick ()
    cmdReceive_Click
End Sub

Sub MidiDevices_Click ()
	frmSysexDevConfig.Show
End Sub

Sub MidiNotifyControl_Change ()

    midiInputArrived
    
End Sub

Sub mnuExit_Click ()
    Unload Me
End Sub

Sub mnuFile_Click ()

    Dim bHaveSysex As Integer
    bHaveSysex = (HugeLen() > 0)
    mnuFileSave.Enabled = bHaveSysex
    mnuFileSaveAs.Enabled = bHaveSysex

End Sub

Sub mnuFileOpen_Click ()
    Dim r As Integer
	r = FileOpen()
End Sub

Sub mnuFileSave_Click ()
    Dim r As Integer
    r = FileSave()
End Sub

Sub mnuFileSaveAs_Click ()
    Dim r As Integer
    r = FileSaveAs()
End Sub

Sub mnuHelpAbout_Click ()
    DumpsterAbout.Show
End Sub

Sub mnuHelpContents_Click ()
    Dim nretcode As Integer
    nretcode = WinHelp(Dumpster.hWnd, addslash(App.Path) + App.HelpFile, HELP_CONTENTS, 0&)
End Sub

Sub mnuSysexReceive_Click ()
    cmdReceive_Click
End Sub

Sub mnuSysexSend_Click ()
    cmdSend_Click
End Sub

Sub MsgBlaster1_Message (MsgVal As Integer, wParam As Integer, lParam As Long, ReturnVal As Long)
	Call midiCallbackWndProc(MsgVal, wParam, lParam)
End Sub

