' $Header:   D:/misc/midi/vcs/huge.bas   1.1   07 Nov 1994 00:15:16   DAVEC  $
' Huge memory buffer for VB
Option Explicit
' File read and write routines based on MS KB Article ID: Q100513


' OpenFile() Structure
Type OFSTRUCT
   cBytes As String * 1
   fFixedDisk As String * 1
   nErrCode As Integer
   reserved As String * 4
   szPathName As String * 128
End Type

' Block size for memory allocation/reallocation
Const ALLOCBLOCKSIZE = &H4000

' OpenFile() Flags
Global Const OF_READ = &H0
Global Const OF_WRITE = &H1
Global Const OF_READWRITE = &H2
Global Const OF_SHARE_COMPAT = &H0
Global Const OF_SHARE_EXCLUSIVE = &H10
Global Const OF_SHARE_DENY_WRITE = &H20
Global Const OF_SHARE_DENY_READ = &H30
Global Const OF_SHARE_DENY_NONE = &H40
Global Const OF_PARSE = &H100
Global Const OF_DELETE = &H200
Global Const OF_VERIFY = &H400
Global Const OF_CANCEL = &H800

Global Const OF_CREATE = &H1000
Global Const OF_PROMPT = &H2000
Global Const OF_EXIST = &H4000
Global Const OF_REOPEN = &H8000

Declare Function OpenFile Lib "Kernel" (ByVal lpFilename As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Integer) As Integer
Declare Function hRead Lib "kernel" Alias "_hread" (ByVal hFile As Integer, lpMem As Any, ByVal lSize As Long) As Long
Declare Function hWrite Lib "Kernel" Alias "_hwrite" (ByVal hFile As Integer, lpMem As Any, ByVal lSize As Long) As Long
Declare Function lClose Lib "kernel" Alias "_lclose" (ByVal hFile As Integer) As Integer
' These funcs return 0 if pointer is OK, 1 if bad
Declare Function IsBadHugeWritePtr Lib "Kernel" (ByVal lpMem As Any, ByVal lSize As Long) As Integer
Declare Function IsBadHugeReadPtr Lib "Kernel" (ByVal lpMem As Any, ByVal lSize As Long) As Integer

' For huge pointer arithmetic
Declare Function HugeOffset Lib "vbhuge.dll" (ByVal ptr As Long, ByVal offset As Long) As Long

' These are memory handle and size for the buffer. Only one buffer supported
Dim nHugeHandle As Integer
Global lHugeSize As Long    ' Actual size of buffer contents
Global lHugeAlloc As Long   ' Allocated size of buffer, always >= lHugeSize

Sub HugeClear ()
    Dim r As Integer

	If nHugeHandle > 0 Then
		r = GlobalFree(nHugeHandle)
		nHugeHandle = 0
		lHugeSize = 0&
		lHugeAlloc = 0&
	End If
End Sub

' Get data from buffer at the specified position.
' Position is zero-based.
' Length must be <64K.
' Returns "" if past end of buffer
' If length is less than remaining bytes in buffer, returns remaining bytes only
Function HugeGet (ByVal lPos As Long, ByVal lLen As Long) As String

	Dim sReturn As String, lPtr As Long

	HugeGet = ""
	If lPos < lHugeSize Then
		
		If (lLen + lPos) > lHugeSize Then
		    lLen = (lHugeSize - lPos)
		End If

		lPtr = GlobalLock(nHugeHandle)
		If Not IsBadHugeReadPtr(lPtr, lLen) Then
			lPtr = HugeOffset(lPtr, lPos)
			If Not IsBadHugeReadPtr(lPtr, lLen) Then
				sReturn = Space$(lLen)
				Call hmemcpy(sReturn, lPtr, lLen)
				HugeGet = sReturn
			Else
				MsgBox "HugeAdd: Bad huge Read pointer! (Base address)"
			End If
		Else
			MsgBox "HugeAdd: Bad huge Read pointer! (Base address)"
		End If

	End If

End Function

Function HugeLen () As Long
	HugeLen = lHugeSize
End Function

Function HugeLoad (InpFile As String) As Integer

      Dim hFile As Integer
      Dim fileStruct As OFSTRUCT
      Dim Fsize As Long
      Dim BytesRead As Long

	Dim hMem As Integer
      Dim lpMem As Long
      Dim r As Integer

      ' Return error by default
      HugeLoad = False

	'Get the size of the file to be read
      Fsize = FileLen(InpFile)
	
      If Fsize > 0 Then

	' Empty buffer if necessary
	HugeClear

	 'Allocate a block of memory equal to the size of the input file.
	 hMem = GlobalAlloc(GMEM_MOVEABLE, Fsize)

	 If hMem <> 0 Then

	    lHugeAlloc = Fsize
	    lpMem = GlobalLock(hMem)

	    'Read the file into memory
	    hFile = OpenFile(InpFile, fileStruct, OF_READ Or OF_SHARE_DENY_NONE)
	    BytesRead = hRead(hFile, ByVal lpMem, Fsize)

	    r = lClose(hFile)
		lHugeSize = BytesRead
		nHugeHandle = hMem
		r = GlobalUnlock(hMem)
		HugeLoad = True

	 Else
	     MsgBox "Not enough memory to load file"
	 End If
      Else
	 MsgBox "Input file is empty"
      End If

End Function

' Add data to end of buffer
Function HugePut (sData As String)

	Dim lPtr As Long, r As Integer, lNewsize As Long, nDataLen As Integer, nNewHandle As Integer

	HugePut = False
	
	nDataLen = Len(sData)
	lNewsize = lHugeSize + nDataLen
	
	' Add more allocated memory if we've run out
	If lNewsize > lHugeAlloc Then

	    lHugeAlloc = ((lNewsize \ ALLOCBLOCKSIZE) + 1) * ALLOCBLOCKSIZE

	    If nHugeHandle = 0 Then
		    nNewHandle = GlobalAlloc(GMEM_MOVEABLE, lHugeAlloc)
	    Else
		    nNewHandle = GlobalRealloc(nHugeHandle, lHugeAlloc, 0)
	    End If

	Else

	    nNewHandle = nHugeHandle

	End If

	If nNewHandle = 0 Then
		MsgBox "Out of memory in HugePut, current size " & lHugeSize & ", new size " & lNewsize
	Else
		' Save in global handle
		nHugeHandle = nNewHandle
		lPtr = GlobalLock(nNewHandle)
		If Not IsBadHugeWritePtr(lPtr, lNewsize) Then

		    ' This DLL function does the huge pointer math for us
		    lPtr = HugeOffset(lPtr, lHugeSize)

		    If Not IsBadHugeWritePtr(lPtr, nDataLen) Then
			    Call hmemcpy(lPtr, sData, nDataLen)
			    lHugeSize = lHugeSize + nDataLen
			    HugePut = True
		    Else
			    MsgBox "HugeAdd: Bad huge write pointer! (Data dest address)"
		    End If
		Else
			MsgBox "HugeAdd: Bad huge write pointer! (Base address)"
		End If
		r = GlobalUnlock(nNewHandle)
	End If

End Function

Function HugeSave (sFilename As String)

	Dim hFile As Integer, fileStruct As OFSTRUCT, BytesWritten As Long, r As Integer
	Dim lPtr As Long


	HugeSave = True
	If lHugeSize > 0 Then

	    lPtr = GlobalLock(nHugeHandle)

	    hFile = OpenFile(sFilename, fileStruct, OF_CREATE Or OF_WRITE Or OF_SHARE_DENY_NONE)
	    If hFile > 0 Then

		BytesWritten = hWrite(hFile, ByVal lPtr, lHugeSize)
    
		    If BytesWritten <> lHugeSize Then
			    MsgBox "Write Error"
			    HugeSave = False
		    End If
    
		r = lClose(hFile)

	    Else

		MsgBox "Can't create file " & sFilename

	    End If

	End If

End Function

