' $Header:   D:/misc/midi/vcs/sysefile.bas   1.0   07 Nov 1994 00:08:28   DAVEC  $

Option Explicit

' Constants for common open and save dialogs
Const OFN_FILEMUSTEXIST = &H1000&
Const OFN_HIDEREADONLY = &H4&
Const OFN_OVERWRITEPROMPT = &H2&
Const OFN_NOREADONLYRETURN = &H8000&

'-----------------------------------------------------------------------
' Purpose: Ask whether to save file. If user says Yes, save it
' Returns: IDYES, IDNO, IDCANCEL
Function AskSave () As Integer
    Dim nRetcode As Integer
    nRetcode = MsgBox("Save buffer first?", MB_YESNOCANCEL Or MB_DEFBUTTON1 Or MB_ICONQUESTION)

    If nRetcode = IDYES Then
	If FileSave() = False Then
	    nRetcode = IDCANCEL
	End If
    End If
    AskSave = nRetcode
End Function

'-----------------------------------------------------------------------
' Purpose: Check that a file exists (from the VB programmer's manual)
' Returns: True if the file exists, False if it doesn't or drive isn't ready
Function FileExists (ByVal sFilename As String) As Integer

	On Error GoTo FileExistsError              ' Turn on error trapping so error handler                                                                                                                       ' responds if any error is detected.

	FileExists = (Dir$(sFilename) <> "")

	Exit Function                              ' Avoid executing error handler
							' if no error occurs.

' Branch here if ERR_DISKNOTREADY or ERR_DEVICEUNAVAILABLE
FileExistsError:
	FileExists = False
	Exit Function

End Function

'-----------------------------------------------------------------------
Function FileOpen ()

    Dim sFilename As String, r As Integer

    FileOpen = False

    ' Allow user to cancel file open if current file has been modified
    If gbFileModified Then
	If AskSave() = IDCANCEL Then
	    Exit Function
	End If
    End If

    sFilename = GetLoadFilename()
    If Len(sFilename) And FileExists(sFilename) Then
	Dumpster.MousePointer = MP_WAIT
	If HugeLoad(sFilename) Then
	    FileOpen = True
	    SetFilename sFilename
	    gbFileModified = False
	End If
	statusupdate
	Dumpster.MousePointer = MP_DEFAULT
    End If

End Function

'-----------------------------------------------------------------------
Function FileSave ()

    Dim bRetcode As Integer

    bRetcode = False
    If HugeLen() > 0 Then
	    If gsFilename = UNTITLED_NAME Or gsFilename = "" Then
		    FileSave = FileSaveAs()
	    Else
		    Dumpster.MousePointer = MP_WAIT
		    FileSave = HugeSave(gsFilename)
		    Dumpster.MousePointer = MP_DEFAULT
	    End If
    End If

    ' Clear dirty flag if save successful
    If bRetcode Then
	gbFileModified = False
    End If

    FileSave = bRetcode
End Function

'-----------------------------------------------------------------------
' Purpose: Get filename to save as, and save
' Returns: True if successful, False if user cancels
Function FileSaveAs () As Integer

    Dim sNewname As String, bRetcode As Integer

    bRetcode = False

    If HugeLen() > 0 Then
	sNewname = GetSaveAsFilename(gsFilename)
	If Len(sNewname) <> 0 And sNewname <> UNTITLED_NAME Then
	    Dumpster.MousePointer = MP_WAIT
	    If HugeSave(sNewname) Then
		Call SetFilename(sNewname)
		bRetcode = True
		gbFileModified = False
	    End If
	    Dumpster.MousePointer = MP_DEFAULT
	End If
    End If

    FileSaveAs = bRetcode

End Function

'-----------------------------------------------------------------------
' Purpose: Displays an Open dialog and returns a file name or an empty string
' if the user cancels
Function GetLoadFilename ()
	On Error GoTo Cancel_err2
	Dumpster.CMDialog1.CancelError = True
	Dumpster.CMDialog1.Filename = "*.SYX"
	Dumpster.CMDialog1.DefaultExt = "SYX"
	Dumpster.CMDialog1.Filter = "Sysex files (*.SYX)|*.SYX|All files|*.*"
	Dumpster.CMDialog1.Flags = OFN_FILEMUSTEXIST Or OFN_HIDEREADONLY Or OFN_NOREADONLYRETURN
	Dumpster.CMDialog1.Action = 1  ' Open

	GetLoadFilename = Dumpster.CMDialog1.Filename
	Exit Function

Cancel_err2:
    GetLoadFilename = ""
    Exit Function

End Function

'-----------------------------------------------------------------------
Function GetSaveAsFilename (ByVal sDefaultName As String) As String
	'Displays a Save As dialog and returns a file name
	'or an empty string if the user cancels
	If sDefaultName = "" Or sDefaultName = UNTITLED_NAME Then
		Dumpster.CMDialog1.Filename = "*.SYX"
	Else
		Dumpster.CMDialog1.Filename = sDefaultName
	End If

	On Error GoTo Cancel_err3
	Dumpster.CMDialog1.CancelError = True
	Dumpster.CMDialog1.DefaultExt = "SYX"
	Dumpster.CMDialog1.Filter = "Sysex files (*.SYX)|*.SYX|All files|*.*"
	Dumpster.CMDialog1.Flags = OFN_OVERWRITEPROMPT Or OFN_HIDEREADONLY
	Dumpster.CMDialog1.Action = 2  ' Save As
	GetSaveAsFilename = Dumpster.CMDialog1.Filename
	Exit Function

' User pressed Cancel, clear returned filename
Cancel_err3:
    GetSaveAsFilename = ""
    Exit Function
    
End Function

