' $Header:   D:/misc/midi/vcs/sysexrec.bas   1.2   29 Nov 1994 21:43:46   DAVEC  $

Option Explicit

' The counter in the dump request macro, if used. -1 if counter not in use
Dim gnCounter As Integer

' Current request string, may be used by the transform macros
Dim gsRequest As String

Function TransformMidiInput (sData As String, sTransform As String) As String

    Dim nPatchNumber As Integer

    Const CASIO_EDIT_BUFFER = &H60
    Const CASIO_RECEIVE_REQUEST = &H20

    Select Case sTransform
    Case "casio"
	' Transform the received data into a form that can be sent back to the synth:
	' Change byte 6 to 20h and insert the current patch number between byte 6 and
	' the rest of the patch

	' Get the patch number from the request
	If Len(gsRequest) Then
	    nPatchNumber = Asc(Mid$(gsRequest, 7, 1))
	Else
	    ' Don't know what the request was, set it to the edit buffer
	    nPatchNumber = CASIO_EDIT_BUFFER
	End If
	TransformMidiInput = Left$(sData, 5) & Chr$(CASIO_RECEIVE_REQUEST) & Chr$(nPatchNumber) & Mid$(sData, 7)

    Case Else
	' Don't change anything
	TransformMidiInput = sData
    End Select

End Function

'-----------------------------------------------------------------------
Sub midiInputArrived ()

    Dim sMidiData As String, nRetCode As Integer, sRequest As String
    Static sHandshake As String

    sMidiData = midiSysexGet()
    If Len(sMidiData) Then

	Select Case gnState
	Case STATE_RECEIVE

	    ' Transform incoming data if requested
	    If Len(Instrument(gnInstrument).sTransform) Then
		sMidiData = TransformMidiInput(sMidiData, Instrument(gnInstrument).sTransform)
	    End If

	    ' Add to buffer
	    If Not HugePut(sMidiData) Then
		    Exit Sub
	    End If
    
	    frmSysexReceive.lblBytesReceived.Caption = Str$(lHugeSize) + " bytes"

	    ' If buffer contains end-of-block
	    If InStr(sMidiData, Chr$(MIDI_ENDSYSEX)) Then
	    
		    ' Acknowledge if required
		    If Len(Instrument(gnInstrument).sAcknowledge) Then
			    nRetCode = vbMidiOutLongMsg(gOutputDev.Handle, Instrument(gnInstrument).sAcknowledge)
		    End If
		    
		    ' If set to automatically finish at end of sysex block and not
		    ' processing a counter loop
		    If Instrument(gnInstrument).bAutoEnd And gnCounter < 0 Then
    
			' Make sure no more input gets processed
			gnState = STATE_OFF
			ReceiveDone
	    
		    Else

			' Start timeout counter (if used) if we just received the end of a block
			If (Instrument(gnInstrument).nReceiveTimeout) And Right$(sMidiData, 1) = Chr$(MIDI_ENDSYSEX) Then
			    frmSysexReceive.tmrReceiveTimeout.Interval = Instrument(gnInstrument).nReceiveTimeout * 1000
			    frmSysexReceive.tmrReceiveTimeout.Enabled = True
			End If

		    End If
    
	    Else

		' Disable the timeout counter because we don't want it timing out in the middle
		' of a dump
		frmSysexReceive.tmrReceiveTimeout.Enabled = False

	    End If
    
	    ' If we're doing a counter loop, send the next request
	    If gnCounter >= 0 Then
		gnCounter = gnCounter + 1
		If gnCounter > Instrument(gnInstrument).nCtrEnd Then
		    ReceiveDone
		Else
		    sRequest = ProcRequest(Instrument(gnInstrument).sRequest, gnCounter)
		    Sendrequest frmSysexReceive, sRequest
		    ' Go back into receive mode and send the next one
		    gnState = STATE_RECEIVE
		End If
	    End If

	Case STATE_SEND
	' Ignore

	End Select

    End If
		
End Sub

'-----------------------------------------------------------------------
' Purpose: Return request string with special macro characters translated
Function ProcRequest (ByVal sRequest As String, nCtr As Integer)

    Dim nPos As Integer, sResponse As String

    nPos = InStr(sRequest, Chr$(MACRO_CHANNEL))
    If nPos > 0 Then
	sResponse = InputBox$("Input Channel/Unit in Hex")
	Mid$(sRequest, nPos, 1) = Chr$(Val("&H" & Trim$(sResponse)))
    End If
    nPos = InStr(sRequest, Chr$(MACRO_PATCH))
    If nPos > 0 Then
	sResponse = InputBox$("Input Patch Number in Hex")
	Mid$(sRequest, nPos, 1) = Chr$(Val("&H" & Trim$(sResponse)))
    End If
    nPos = InStr(sRequest, Chr$(MACRO_OR))
    If nPos > 0 And nPos <= Len(sRequest) - 2 Then
	' Arithmetic-or the two bytes after the macro opcode
	Mid$(sRequest, nPos, 1) = Chr$(Asc(Mid$(sResponse, nPos + 1, 1)) Or Asc(Mid$(sResponse, nPos + 2, 1)))
    End If
    nPos = InStr(sRequest, Chr$(MACRO_COUNTER))
    If nPos > 0 Then
	Mid$(sRequest, nPos, 1) = Chr$(nCtr)
    End If

    ProcRequest = sRequest

End Function

'-----------------------------------------------------------------------
Sub ReceiveClose ()
    gnState = STATE_OFF
    CloseDev
End Sub

'-----------------------------------------------------------------------
Sub ReceiveDone ()


    ReceiveClose

    ' Set file modified flag if we received anything
    gbFileModified = (HugeLen() > 0)

    Unload frmSysexReceive

End Sub

Sub ReceiveOpen ()

    Dim nSize As Integer, nBuffers As Integer

    ' Close if currently open
    CloseDev

    nSize = Instrument(gnInstrument).nBufferSize
    nBuffers = Instrument(gnInstrument).nBufferCount

    sysexInParameters nBuffers, nSize
    gnState = STATE_RECEIVE

    OpenDev
    ' Debug.Print "Opened with " & nBuffers & " buffers size " & nSize
	    
End Sub

'-----------------------------------------------------------------------
Sub Sendrequest (frmReceive As Form, sRequest As String)

    Dim nRetCode As Integer

    ' Set global so transform macros can see what request was sent
    gsRequest = sRequest

    ' Send it
    frmReceive.lblStatus.Caption = "Sending request..."
    frmReceive.lblStatus.Refresh
    nRetCode = vbMidiOutLongMsg(gOutputDev.Handle, sRequest)
    frmReceive.lblStatus.Caption = ""
    frmReceive.lblStatus.Refresh


End Sub

'-----------------------------------------------------------------------
Sub SysexReceive (frmReceive As Form, ByVal nInstrument As Integer)
    Dim nRetCode As Integer, sRequest As String, sRequestProc As String, iCtr As Integer

	' Default to Start Dump on Synth if no option selected
	If nInstrument < 0 Then
		nInstrument = 0
	End If

    gnInstrument = nInstrument
    gnCounter = -1
    frmReceive.lblBytesReceived = "0"

    ' Clear the global buffer
    HugeClear

    ' Open the MIDI device
    ReceiveOpen
    If gInputDev.Handle < 0 Or gOutputDev.Handle < 0 Then Unload frmSysexReceive

    sRequest = Instrument(nInstrument).sRequest

    If sRequest = "" Then
	frmReceive.lblStatus.Caption = "Start dump on instrument"
	frmReceive.lblStatus.Refresh
    Else
	If InStr(sRequest, Chr$(MACRO_COUNTER)) > 0 Then
	    ' Send request for first value of the counter.
	    ' Subsequent requests are sent from midiinputarrived after
	    ' results of first request are received
	    gnCounter = Instrument(nInstrument).nCtrStart
	End If
	' Send one request
	sRequestProc = ProcRequest(sRequest, gnCounter)
	Sendrequest frmReceive, sRequestProc
    End If
    
    ' The rest of the action is in midiInputArrived.

End Sub

