' $Header:   D:/misc/midi/vcs/sysexsnd.bas   1.1   07 Nov 1994 23:45:44   DAVEC  $

Option Explicit

Global glSendPos As Long, glSendLen As Long

' Purpose: Send a block, then start the timer for the next block
Sub BlockSend (SendForm As Form)

    Dim sBuf As String, nEndPos As Integer

    ' Stop timer while we send
    SendForm.tmrSysexSend.Enabled = False

    If glSendPos > glSendLen Or glSendLen = 0 Then
        ' Finished
        Unload SendForm
        Exit Sub
    End If

    sBuf = HugeGet(glSendPos, gnSendBlockSize * 1024)
    If Len(sBuf) Then

        ' If this buffer contains multiple sysex messages then
        ' stop at the end of the current one because we want to wait for the delay
        ' period between blocks.
        nEndPos = InStr(sBuf, Chr$(MIDI_ENDSYSEX))
        If nEndPos > 0 And nEndPos < Len(sBuf) Then
            sBuf = Left$(sBuf, nEndPos)
        End If

        If vbMidiOutLongMsg(gOutputdev.Handle, sBuf) <> 0 Then
            ' Error, can't continue
            Unload SendForm
            Exit Sub
        Else
            ' Update status
            SendForm.lblBytesSent.Caption = Str$(glSendPos) & " bytes"
            SendForm.lblBytesSent.Refresh
            ' Move buffer pointer for next chunk
            glSendPos = glSendPos + Len(sBuf)
        End If

        ' Re-enable the timer, next chunk will be sent
        ' when it times out
        SendForm.tmrSysexSend.Interval = gnSendDelay
        SendForm.tmrSysexSend.Enabled = True

    Else
        ' Finished
        Unload SendForm
    End If


End Sub

Sub SysexSend ()

    glSendLen = HugeLen()
    glSendPos = 0

    OpenDev
    If glSendLen <= 0 Or gOutputdev.Handle < 0 Then
        Unload frmSysexSend
    End If

    frmSysexSend.lblStatus.Caption = "Sending..."

    ' Send the first block and start the timer for subsequent blocks
    BlockSend frmSysexSend

End Sub

