'******************************************************************************
' File:      playstk.c
' Version:   1.00
' Tab stops: every 2 columns
' Project:   DiamondWare's Sound ToolKit for Windows
' Copyright: 1996 DiamondWare, Ltd.  All rights reserved.*
' Written:   95/12/11 by David Alen
' Purpose:   Contains sample application using the WIN-STK
' History:   96/03/28 KW & JCL finalized for 1.0
'            96/04/14 JCL finalized for 1.01
'            96/03/13 JCL finalized for 1.1 (no changes)
'            96/03/27 JCL finalized for 1.11 (no changes)
'            96/07/08 JCL finalized for 1.2 (no changes)
'
'*Permission is expressely granted to use this program or any derivitive made
' from it to registered users of the WIN-STK.
'******************************************************************************



Attribute VB_Name = "PLAYSTK"
Option Explicit

Declare Function CreateFile Lib "kernel32" Alias "CreateFileA" (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, lpSecurityAttributes As Any, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Declare Function GetFileSize Lib "kernel32" (ByVal hFile As Long, lpFileSizeHigh As Any) As Long
Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Declare Function GlobalLock Lib "kernel32" (ByVal hMem As Long) As Long
Declare Function ReadFile Lib "kernel32" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToRead As Long, lpNumberOfBytesRead As Long, lpOverlapped As Any) As Long
Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Declare Function GlobalUnlock Lib "kernel32" (ByVal hMem As Long) As Long
Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long

Public Const GENERIC_READ = &H80000000
Public Const FILE_SHARE_READ = &H1
Public Const OPEN_EXISTING = 3
Public Const FILE_ATTRIBUTE_NORMAL = &H80
Public Const GMEM_MOVEABLE = &H2
Public Const GMEM_SHARE = &H2000

Public Const CD_ACTION_OPEN = 1

Public Const dws_NOSUCCESS = 0

Type SoundInfo
    FileName As String
    Handle As Long
    soundnum As Integer
    Rate As Integer
End Type

Global dws_DR As dws_DETECTRESULTS
Global dws_ID As dws_IDEAL
Global dws_DP As dws_DPlay
Global dws_MP As dws_MPlay

Global giNumSounds As Integer
Global gtSI() As SoundInfo
Global gPlay As dws_DPlay

Public Sub dwsShowError()
    ' An error has occurred!  Show it!
    Dim iError As Integer
    Dim sError As String
    
    iError = dws_ErrNo()
    
    Select Case iError
        Case dws_NOTINITTED
            sError = "Not Initialized"
        Case dws_ALREADYINITTED
            sError = "Already Initialized"
        Case dws_NOTSUPPORTED
            sError = "Not Supported"
        Case dws_INTERNALERROR
            sError = "Internal Error"
        Case dws_INVALIDPOINTER
            sError = "Invalid Pointer"
        Case dws_RESOURCEINUSE
            sError = "Resource In Use"
        Case dws_MEMORYALLOCFAILED
            sError = "Memory Alloc Failed"
        Case dws_SETEVENTFAILED
            sError = "Set Event Failed"
        Case dws_BUSY
            sError = "Busy"
        Case dws_Init_BUFTOOSMALL
            sError = "Buffer Too Small"
        Case dws_D_NOTADWD
            sError = "Not a DWD"
        Case dws_D_NOTSUPPORTEDVER
            sError = "Not Supported Version"
        Case dws_D_BADDPLAY
            sError = "Bad (D) Play"
        Case dws_DPlay_NOSPACEFORSOUND
            sError = "No Space For Sound"
        Case dws_WAV2DWD_NOTAWAVE
            sError = "Not A Wave"
        Case dws_WAV2DWD_UNSUPPORTEDFORMAT
            sError = "Unsupport Format"
        Case dws_M_BADMPLAY
            sError = "Bad (M) Play"
        Case Else
            sError = "<unknown #" + CStr(iError) + ">"
    End Select
    
    MsgBox "Error '" + sError + "' occurred!"
End Sub


Public Function dwsPlayWave(piIndex As Integer, Optional vCount As Variant) As Boolean
    ' This procedure plays a loaded wave by using the passed
    ' memory handle.

    Dim tPlay As dws_DPlay
    Dim iStatus As Integer

    LSet tPlay = gPlay
    
    tPlay.snd = gtSI(piIndex).Handle
    
    If Not IsMissing(vCount) Then
        tPlay.count = CInt(vCount)
    Else
        tPlay.count = 1
    End If
    tPlay.flags = dws_dplay_SND Or dws_dplay_COUNT Or dws_dplay_LVOL Or dws_dplay_RVOL Or dws_dplay_PITCH
    
    iStatus = dws_DPlay(tPlay)
        
    gtSI(piIndex).soundnum = tPlay.soundnum
    
    If iStatus = 0 Then
        dwsShowError
        Exit Function
    End If
    
    ' MIDI?!
    
    '    mPlay.track = (UCHAR*)buffer;
    '    mPlay.count = 1;
    '    status = dws_MPlay(&mPlay);

    dwsPlayWave = True
End Function

Public Function dwsLoadWave(psFileName As String) As Integer
    ' This procedure loads the passed WAVE file and
    ' prepares it for use with the WinSTK.  It returns the INDEX of gtSI()
    ' that the wave was loaded into.

    On Error GoTo LWE

    Dim WaveDWD As Long
    Dim hWaveDWD As Long
    Dim WaveTmp As Long
    Dim hWaveTmp As Long
    Dim iStatus As Integer
    Dim lLen As Long
    Dim lTemp As Long
    Dim hFile As Long
    Dim iLoop As Integer
    Dim iIndex As Integer
    
    hFile = CreateFile(psFileName, GENERIC_READ, FILE_SHARE_READ, ByVal 0&, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0&)
    
    If hFile > 0 Then
        lLen = GetFileSize(hFile, ByVal 0&)

        hWaveTmp = GlobalAlloc(GMEM_MOVEABLE Or GMEM_SHARE, lLen)
        WaveTmp = GlobalLock(hWaveTmp)

        ReadFile hFile, ByVal WaveTmp, lLen, lTemp, ByVal 0&
        CloseHandle (hFile)
    Else
        Exit Function
    End If
    
    If InStr(UCase(psFileName), ".WAV") Then
    
        '  convert WAV to DWD
        lTemp = lLen
        iStatus = dws_WAV2DWD(ByVal WaveTmp, lTemp, ByVal 0&)
        If iStatus = False Then
            dwsShowError
            Exit Function
        End If
    
        hWaveDWD = GlobalAlloc(GMEM_MOVEABLE, lTemp)
        WaveDWD = GlobalLock(hWaveDWD)
    
        iStatus = dws_WAV2DWD(ByVal WaveTmp, lLen, ByVal WaveDWD)
    
        GlobalUnlock (hWaveTmp)
        GlobalFree (hWaveTmp)
    
        If iStatus = False Then
            GlobalUnlock (hWaveDWD)
            GlobalFree (hWaveDWD)
            dwsShowError
            Exit Function
        End If
    Else
        hWaveDWD = hWaveTmp
        WaveDWD = WaveTmp
    End If
    
    iIndex = -1
    
    giNumSounds = giNumSounds + 1
    
    ' Find an empty index if exists
    For iLoop = 0 To UBound(gtSI)
        If gtSI(iLoop).Handle = 0 Then
            ' Use this one!
            iIndex = iLoop
            Exit For
        End If
    Next iLoop
    
    If iIndex = -1 Then
        ReDim Preserve gtSI(UBound(gtSI) + 1) As SoundInfo
        iIndex = UBound(gtSI)
    End If
    
    gtSI(iIndex).FileName = psFileName
    gtSI(iIndex).Handle = WaveDWD
    
    dws_DGetRateFromDWD ByVal gtSI(iIndex).Handle, gtSI(iIndex).Rate
    
    dwsLoadWave = iIndex
    
LWER:
    Exit Function
    
LWE:
    dwsLoadWave = -1
    MsgBox "Error '" + Error + "' occurred in DWSTEST:dwsLoadWave!"
    Resume LWER
End Function

Public Function dwsUnloadWave(piIndex As Integer) As Boolean
    ' This procedure removes a loaded WAVE file via
    ' the Wave's Index.
    
    Dim iLoop As Integer
        
    On Error GoTo UWE

    If giNumSounds = 0 Or piIndex < 0 Or piIndex > (giNumSounds - 1) Then
        Exit Function
    End If
    
    If gtSI(piIndex).Handle <> 0 Then
        ' Free the memory that's holding the wave
        GlobalUnlock (gtSI(piIndex).Handle)
        GlobalFree (gtSI(piIndex).Handle)
        
        ' Remove the sound Index!
        gtSI(piIndex).Handle = 0
        gtSI(piIndex).FileName = ""
        
        giNumSounds = giNumSounds - 1
        
        dwsUnloadWave = True
    End If

UWER:
    Exit Function
    
UWE:
    MsgBox "Error '" + Error + "' occurred in DWSTEST:dwsUnloadLoadWave!"
    Resume UWER
End Function


