//------------------------------------------
//	COMTEST - Communication Tester
// v2.0
// 8/12/93
// by Bert Whetstone
//------------------------------------------

#define Uses_TEditor
#define Uses_TSItem
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TStringCollection
#define Uses_TScrollBar
#define Uses_TSortedListBox
#define Uses_TKeys
#define Uses_TApplication
#define Uses_TEvent
#define Uses_TRect
#define Uses_TDialog
#define Uses_TStaticText
#define Uses_TButton
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TScreen
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_MsgBox

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <bios.h>
#include <ctype.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <tv.h>
#include "gadgets.h"
#include "listbox.h"
#include "infoview.h"
#include "getmod.h"


//---------- GENERAL DEFS ------------
#define DATA_FILE			"COMTEST.TXT"
#define INFOVIEW_WIDTH	79
#define MAX_DATA_SIZE	200


//---------- COM DEFS ------------
#define COM_ERROR_MASK	0x8e00
#define COM1		0
#define COM2		1
#define COM3		2
#define COM4		3


//---------- CONTROL ID DEFS -------------
enum buttonID {ID_ABOUT_BUTTON=101,
					ID_AUTOSEND_BUTTON,
					ID_BAUD1200_BUTTON,
					ID_BAUD2400_BUTTON,
					ID_BAUD4800_BUTTON,
					ID_BAUD9600_BUTTON,
					ID_CLEAR_BUTTON,
					ID_COM1_BUTTON,
					ID_COM2_BUTTON,
					ID_COM3_BUTTON,
					ID_COM4_BUTTON,
					ID_QUIT_BUTTON,
					ID_RESET_BUTTON,
					ID_SCREENHEIGHT_BUTTON,
					ID_SEND_BUTTON,
					ID_TILE_BUTTON};


//------------- PUBLIC DATA -------------
	Boolean handler_installed=False;
char main_title[]="ComTest v2.0";
char	*recv_buff;
int	recv_buff_count=0;
int	com_port=COM1;
int	baud_rate=_COM_1200;
unsigned long xmit_count,recv_count;
unsigned int recv_errors;
TClockView	*clock;
InfoView		*info_view;
TEditor		*recv_editor;

char MyPalette[32]={0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,
							0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,
							0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,
							0x3E,0x3F};


//------------ PUBLIC PROTOTYPES -------------
void SetupCom();
void Transmit(char *buff);


//-------------- AUTOSEND DIALOG TRANSFER STRUCT ------------------
typedef struct TransferStruct {
											char count[6];
											char from[6];
											char to[6];
										} TransferStruct;


//-------------- XMIT WINDOW CLASS DECLARATION ------------------
class XmitWindow : public TWindow
{
	int auto_count,auto_from,auto_to;
	TScrollBar	*scroll_bar;
	ListBox		*data_listbox;

public:
	XmitWindow(const TRect& r,const char *Title);
	~XmitWindow();
	void IdleAction();

private:
	TPalette& getPalette() const;
	void handleEvent(TEvent& event);
	void LoadData();
	void SendData();
	void SetupAutoSend();
	void sizeLimits(TPoint &min,TPoint &max);
};


//-------------- RECV WINDOW CLASS DECLARATION ------------------
class RecvWindow : public TWindow
{
public:
	RecvWindow(const TRect& r,const char *Title);
	volatile static void CheckRecv(void);

private:
	void sizeLimits(TPoint &min,TPoint &max);
};


//-------------- APPLICATION CLASS DECLARATION ----------------
class TestApp : public TApplication
{
	XmitWindow	*xmit_win;
	RecvWindow	*recv_win;

public:
	TestApp::TestApp();
	static TMenuBar *initMenuBar(TRect);
	static TStatusLine *initStatusLine(TRect);

private:
	void About();
	void handleEvent(TEvent& event);
	void idle();
	void ScreenHeight();
	void Tile();
};



//-----------------------------------------------
//			XMIT WINDOW FUNCTION DEFINITIONS
//-----------------------------------------------
XmitWindow::XmitWindow(const TRect& Bounds,const char *Title) :
								TWindow(Bounds,Title,0),TWindowInit(&XmitWindow::initFrame)
{
	TRect r=getExtent();
	r.b.x-=2;
	r.b.y--;
	options|=ofTileable;
	flags=wfMove | wfGrow | wfZoom;

	auto_count=0;
	auto_from=0;
	auto_to=0;
	scroll_bar=new TScrollBar(TRect(r.b.x-1,3,r.b.x,r.b.y));
	data_listbox=new ListBox(TRect(2,3,r.b.x-1,r.b.y),1,scroll_bar);
	data_listbox->newList(new TStringCollection(50,10));

	data_listbox->growMode|=gfGrowHiX | gfGrowHiY;
	LoadData();

	insert(new TButton(TRect(2,1,12,3),"~A~uto",ID_AUTOSEND_BUTTON,bfNormal));
	insert(new TButton(TRect(14,1,24,3),"~S~end",ID_SEND_BUTTON,bfDefault));
	insert(new TButton(TRect(26,1,36,3),"~R~eset",ID_RESET_BUTTON,bfNormal));
	insert(new TButton(TRect(38,1,48,3),"~Q~uit",cmQuit,bfNormal));
	insert(scroll_bar);
	insert(data_listbox);
	SetupCom();
}


XmitWindow::~XmitWindow()
{
	if(handler_installed)
		sp_uninstall();
}


TPalette& XmitWindow::getPalette() const
{
static TPalette palette(MyPalette,sizeof(MyPalette)-1);

	return palette;
}


void XmitWindow::handleEvent(TEvent& event)
{
ushort t;

	TWindow::handleEvent(event);
	switch(event.what)
	{
		case evCommand:
			switch(event.message.command)
			{
				case ID_AUTOSEND_BUTTON:
					SetupAutoSend();
					break;

				case ID_RESET_BUTTON:
					SetupCom();
					break;

				case ID_SEND_BUTTON:
					SendData();
					break;

				default:
					return;
			}
			break;

		case evKeyDown:
			switch(event.keyDown.keyCode)
			{
				case kbEnter:
					SendData();
					break;

				default:
					return;
			}
			break;

		case evBroadcast:
			switch(event.message.command)
			{
				case cmListItemSelected:
					SendData();
					break;

				default:
					return;
			}
			break;

		default:
			return;
	}

	data_listbox->select();
	clearEvent(event);
}


void XmitWindow::IdleAction()
{
	if(!auto_count)
		return;

	auto_count--;
	data_listbox->focusItem(auto_from+random(auto_to-auto_from));
	SendData();
}


void XmitWindow::LoadData()
{
static char	buff[MAX_DATA_SIZE];
char	*temp;

	ifstream fp(DATA_FILE,ios::binary);
	if(!fp)
		return;

	while(1)
	{
		fp.getline(buff,sizeof(buff)-2);
		if(fp.eof())
			break;

		strcat(buff,"\n");
		temp=new char[strlen(buff)+1];
		if(!temp)
			break;

		strcpy(temp,buff);
		data_listbox->insert(temp);
	}

	auto_to=data_listbox->range;
}


void XmitWindow::SendData()
{
static char	buff[MAX_DATA_SIZE];

	data_listbox->getText(buff,data_listbox->focused,sizeof(buff));
	Transmit(buff);
}


void XmitWindow::SetupAutoSend()
{
int	t;
TDialog 		*dlg;
TInputLine	*count_input,*from_input,*to_input;
TransferStruct ts;

	dlg=new TDialog(TRect(0,0,27,12),"Auto Send Options");
	if(!dlg)
		return;

	itoa(auto_count,ts.count,10);
	itoa(auto_from,ts.from,10);
	itoa(auto_to,ts.to,10);

	count_input=new TInputLine(TRect(10,2,18,3),sizeof(ts.count));
	from_input=new TInputLine(TRect(10,4,18,5),sizeof(ts.from));
	to_input=new TInputLine(TRect(10,6,18,7),sizeof(ts.to));

	dlg->options|=ofCentered;
	dlg->insert(count_input);
	dlg->insert(new TLabel(TRect(3,2,9,3),"~C~ount",count_input));
	dlg->insert(from_input);
	dlg->insert(new TLabel(TRect(3,4,9,5),"~F~rom",from_input));
	dlg->insert(to_input);
	dlg->insert(new TLabel(TRect(3,6,9,7),"~T~o",to_input));
	dlg->insert(new TButton(TRect(2,9,12,11),"~O~k",cmOK,bfDefault));
	dlg->insert(new TButton(TRect(14,9,24,11),"~C~ancel",cmCancel,bfNormal));
	count_input->select();

	dlg->setData(&ts);

	if(TProgram::deskTop->execView(dlg)==cmCancel)
		return;

	dlg->getData(&ts);
	destroy(dlg);

	auto_count=atoi(ts.count);
	auto_from=atoi(ts.from);
	auto_to=atoi(ts.to);

	if(auto_to<auto_from)
	{
		t=auto_to;
		auto_to=auto_from;
		auto_from=t;
	}

	if(auto_to>data_listbox->range)
		auto_to=data_listbox->range;
}


void XmitWindow::sizeLimits(TPoint &min,TPoint &max)
{
	TWindow::sizeLimits(min,max);
	min.x=37;
	min.y=7;
}



//-----------------------------------------------
//			RECV WINDOW FUNCTION DEFINITIONS
//-----------------------------------------------
RecvWindow::RecvWindow(const TRect& Bounds,const char *Title) :
								TWindow(Bounds,Title,0),TWindowInit(&XmitWindow::initFrame)
{
TScrollBar	*h_scroll_bar;
TScrollBar	*v_scroll_bar;

	options|=ofTileable;
	flags=wfMove | wfGrow | wfZoom;

	TRect r=getExtent();
	r.b.x--;
	r.b.y-=2;
	r.a.x++;
	r.a.y++;
	h_scroll_bar=new TScrollBar(TRect(r.a.x,r.b.y,r.b.x-1,r.b.y+1));
	v_scroll_bar=new TScrollBar(TRect(r.b.x-1,r.a.y,r.b.x,r.b.y));

	r.b.x--;
	recv_editor=new TEditor(r,h_scroll_bar,v_scroll_bar,NULL,10240);
	recv_editor->eventMask&=~(evKeyboard | evMouseDown);

	insert(h_scroll_bar);
	insert(v_scroll_bar);
	insert(recv_editor);
}


void RecvWindow::CheckRecv(void)
{
	recv_buff[recv_buff_count]=get_byte();
	recv_buff_count++;
}


void RecvWindow::sizeLimits(TPoint &min,TPoint &max)
{
	TWindow::sizeLimits(min,max);
	min.x=37;
	min.y=7;
}



//-----------------------------------------------
//			APPLICATION FUNCTION DEFINITIONS
//-----------------------------------------------
TestApp::TestApp() : TProgInit(&TestApp::initStatusLine,
											&TestApp::initMenuBar,
											&TestApp::initDeskTop)
{
TRect r=getExtent();

	r.a.x=r.b.x-9;
	r.b.y=r.a.y+1;
	clock=new TClockView(r);	//Create the clock view.
	insert(clock);

	r=getExtent();
	r.a.x=r.b.x-INFOVIEW_WIDTH;
	r.a.y=r.b.y-1;
	info_view=new InfoView(r);	//Create the InfoView.
	insert(info_view);

	xmit_win=new XmitWindow(TRect(0,0,TDisplay::getCols(),TDisplay::getRows()),
									"Transmission Window");
	recv_win=new RecvWindow(TRect(0,0,TDisplay::getCols(),TDisplay::getRows()),
									"Receive Window");

	deskTop->insert(recv_win);
	deskTop->insert(xmit_win);

	r=getExtent();
	r.b.y-=2;
	deskTop->tile(r);
}


void TestApp::About()
{
char	buff[200];
TDialog *pd;

	pd=new TDialog(TRect(0,0,35,12),"About ComTest");
	if(pd)
	{
		sprintf(buff,"\003%s\n\003Communication Tester\n\003by Bert Whetstone\n\0031993",main_title);
		pd->options|=ofCentered;
		pd->insert(new TStaticText(TRect(1,2,34,7),buff));
		pd->insert(new TButton(TRect(3,9,32,11),"~O~k",cmOK,bfDefault));
		deskTop->execView(pd);
	}

	destroy(pd);
}


void TestApp::handleEvent(TEvent& event)
{
ushort t;

	TApplication::handleEvent(event);
	if(event.what==evCommand)
	{
		switch(event.message.command)
		{
			case ID_CLEAR_BUTTON:
				recv_editor->deleteRange(0,recv_editor->bufLen,False);
				recv_editor->scrollTo(0,0);
				break;

			case ID_ABOUT_BUTTON:
				About();
				break;

			case ID_BAUD1200_BUTTON:
				baud_rate=_COM_1200;
				SetupCom();
				break;

			case ID_BAUD2400_BUTTON:
				baud_rate=_COM_2400;
				SetupCom();
				break;

			case ID_BAUD4800_BUTTON:
				baud_rate=_COM_4800;
				SetupCom();
				break;

			case ID_BAUD9600_BUTTON:
				baud_rate=_COM_9600;
				SetupCom();
				break;

			case ID_COM1_BUTTON:
				com_port=COM1;
				SetupCom();
				break;

			case ID_COM2_BUTTON:
				com_port=COM2;
				SetupCom();
				break;

			case ID_COM3_BUTTON:
				com_port=COM3;
				SetupCom();
				break;

			case ID_COM4_BUTTON:
				com_port=COM4;
				SetupCom();
				break;

			case ID_SCREENHEIGHT_BUTTON:
				ScreenHeight();
				break;

			case ID_TILE_BUTTON:
				Tile();
				break;

			default:
				return;
		}

		clearEvent(event);
	}
}


void TestApp::idle()
{
int	x;

	TProgram::idle();
	clock->update();

	while(recv_buff_count)
	{
		x=recv_buff_count;
		recv_buff_count=0;

		if((recv_editor->bufLen+x)>=recv_editor->bufSize)
			recv_editor->deleteRange(0,x,False);

		recv_editor->insertText(recv_buff,x,False);
		recv_editor->scrollTo(0,recv_editor->curPos.y);
		recv_count+=x;
	}

	info_view->update();
	xmit_win->IdleAction();
}


TMenuBar *TestApp::initMenuBar(TRect r)
{
	r.b.y=r.a.y+1;
	TSubMenu& sys_menu=*new TSubMenu("~F~ile",kbAltF)+
								*new TMenuItem("~A~bout",	ID_ABOUT_BUTTON,			kbAltA)+
								*new TMenuItem("~H~eight",	ID_SCREENHEIGHT_BUTTON,	kbAltH)+
								newLine()+
								*new TMenuItem("~Q~uit",cmQuit,kbAltX);

	TSubMenu& baud_menu=*new TSubMenu("~B~aud",kbAltB)+
								*new TMenuItem("~1~200",ID_BAUD1200_BUTTON,kbAltF1,hcNoContext,"AltF1")+
								*new TMenuItem("~2~400",ID_BAUD2400_BUTTON,kbAltF2,hcNoContext,"AltF2")+
								*new TMenuItem("~4~800",ID_BAUD4800_BUTTON,kbAltF3,hcNoContext,"AltF3")+
								*new TMenuItem("~9~600",ID_BAUD9600_BUTTON,kbAltF4,hcNoContext,"AltF4");

	TSubMenu& com_menu=*new TSubMenu("~C~OM Port",kbAltC)+
								*new TMenuItem("COM ~1~",ID_COM1_BUTTON,kbAltF5,hcNoContext,"AltF5")+
								*new TMenuItem("COM ~2~",ID_COM2_BUTTON,kbAltF6,hcNoContext,"AltF6")+
								*new TMenuItem("COM ~3~",ID_COM3_BUTTON,kbAltF7,hcNoContext,"AltF7")+
								*new TMenuItem("COM ~4~",ID_COM4_BUTTON,kbAltF8,hcNoContext,"AltF8")+
								newLine()+
								*new TMenuItem("~R~eset",ID_RESET_BUTTON,(ushort)0);

	TSubMenu& recv_menu=*new TSubMenu("~R~eceiver",kbAltR)+
								*new TMenuItem("~C~lear",ID_CLEAR_BUTTON,(ushort)0);

	TSubMenu& xmit_menu=*new TSubMenu("~T~ransmitter",kbAltT)+
								*new TMenuItem("~A~uto Send",ID_AUTOSEND_BUTTON,(ushort)0);

	TSubMenu& window_menu=*new TSubMenu("~W~indow",kbAltW)+
								*new TMenuItem("~N~ext",		cmNext,	kbF6,		hcNoContext,"F6")+
								*new TMenuItem("~P~revious",	cmPrev,	kbShiftF6,hcNoContext,"ShiftF6")+
								*new TMenuItem("~S~ize/Move",	cmResize,kbCtrlF5,hcNoContext,"CtrlF5")+
								*new TMenuItem("~T~ile",ID_TILE_BUTTON,kbAltT,	hcNoContext,"AltT")+
								*new TMenuItem("~Z~oom",		cmZoom,	kbF5,		hcNoContext,"F5");

	TSubMenu& full_menu=sys_menu+baud_menu+com_menu+recv_menu+xmit_menu+window_menu;
	return new TMenuBar(r,full_menu);
}


TStatusLine *TestApp::initStatusLine(TRect r)
{
	r.a.y=r.b.y-1;
	return new TStatusLine(r,*new TStatusDef(0,0xFFFF));
}


void TestApp::ScreenHeight()
{
	info_view->hide();
	setScreenMode(TScreen::screenMode^TDisplay::smFont8x8);
	Tile();
	TRect r=getExtent();
	info_view->moveTo(r.b.x-INFOVIEW_WIDTH,r.b.y-1);
	info_view->show();
}


void TestApp::Tile()
{
	TRect r=getExtent();
	r.b.y-=2;
	deskTop->tile(r);
}



//-----------------------------------
//			PROGRAM STARTS HERE
//-----------------------------------
int main(int argc,char *argv[])
{
	if(argc>1)
		com_port=atoi(argv[1]);

	if(argc>3)
	{
		switch(atoi(argv[2]))
		{
			case 1200:
				baud_rate=_COM_1200;
				break;

			case 2400:
				baud_rate=_COM_2400;
				break;

			case 4800:
				baud_rate=_COM_4800;
				break;

			case 9600:
				baud_rate=_COM_9600;
				break;

			default:
				printf("\nInvalid baud rate!\nUse 1200,2400,4800, or 9600");
				return 0;
		}
	}

	recv_buff=(char *)malloc(5*1024);
	if(!recv_buff)
	{
		printf("\nUnable to allocate buffer memory!");
		return 0;
	}

	TestApp comtest;
	TScreen::checkSnow=False;
	comtest.run();
	return 0;
}


void ComError(char *mess,int x)
{
char	buff[30];

	buff[0]=0;
	if(x & 0x0800)
		strcat(buff,"Frame ");

	if(x & 0x0400)
		strcat(buff,"Parity ");

	if(x & 0x0200)
		strcat(buff,"Overrun ");

	if(x & 0x8000)
		strcat(buff,"Timeout");

	messageBox(mfError | mfOKButton,"\003%s - %x\n\003%s",mess,x,buff);
}


void SetupCom()
{
unsigned int	x;

	if(handler_installed)
		sp_uninstall();

	x=bioscom(_COM_INIT,_COM_CHR8 | _COM_STOP1 | _COM_NOPARITY | baud_rate,com_port);
	if(x & COM_ERROR_MASK)
		ComError("Initialization Error",x);

	sp_install(RecvWindow::CheckRecv,com_port);
	handler_installed=True;
	info_view->update();
}


void Transmit(char *buff)
{
unsigned int	x;

	while(*buff)
	{
		x=send_byte(*buff++);
		if(x & COM_ERROR_MASK)
		{
			ComError("Transmission Error",x);
			break;
		}

		xmit_count++;
	}

	info_view->update();
}


