;GETMOD.ASM

PUBLIC	_GET_BYTE
PUBLIC	_SEND_BYTE
PUBLIC	_SP_INSTALL
PUBLIC	_SP_UNINSTALL

CODE SEGMENT BYTE 'CODE'
ASSUME CS:CODE

COM1_VECT	EQU 4*0CH
COM2_VECT	EQU 4*0BH

VECTOR:			DW 0000
COM_NUM:			DW	0000
COM_PORT:		DW 0000
OLD_INT_SEG:	DW	0000
OLD_INT_OFF:	DW	0000
BUFF_SIZE:		DW 0000
BUFF_SEG:		DW	0000
BUFF_OFF:		DW 0000
DATSEG:			DW	0000
EXTRASEG:		DW	0000
BITMASK:			DW	0000
OLD_BITMASK:	DW	0000

_GET_BYTE	PROC FAR
	PUSH	BP
	MOV	BP,SP
	PUSH	DX

	MOV	DX,CS:WORD PTR COM_PORT
	SUB	AH,AH
	IN		AL,DX

	POP	DX
	POP	BP
	RET
_GET_BYTE ENDP

_SEND_BYTE	PROC FAR
	PUSH	BP
	MOV	BP,SP
	PUSH	BX
	PUSH	CX
	PUSH	DX

	CALL	GET_TIME
	MOV	BH,20H
	MOV	BL,AL

	MOV	DX,CS:WORD PTR COM_PORT
	ADD	DX,5					;DX=LINE STATUS
	MOV	AX,[BP+6]
	CMP	AL,00
	JZ		EXIT_SEND_BYTE
	MOV	AH,AL
WAIT_SEND_BYTE:
	IN		AL,DX
	TEST	AL,00011100B		;TEST FOR ERRORS OR BREAK-DETECT.
	JNZ	EXIT_SEND_BYTE
	TEST	AL,00100000B		;TEST FOR TRANSMITTER HOLD REGISTER EMPTY.
	JNZ	WAIT_NO_MORE
	CALL	GET_TIME				;DO TIMEOUT TEST.
	CMP	CL,BL
	JE		WAIT_SEND_BYTE
	MOV	BL,CL
	DEC	BH
	JNZ	WAIT_SEND_BYTE
	OR		AH,80H
	JMP	SHORT EXIT_SEND_BYTE

WAIT_NO_MORE:
	SUB	DX,5
	MOV	AL,AH
	OUT	DX,AL
	SUB	AX,AX
EXIT_SEND_BYTE:
	POP	DX
	POP	CX
	POP	BX
	POP	BP
	RET
_SEND_BYTE ENDP


GET_TIME PROC NEAR
	PUSH	SI
	PUSH	DS

	MOV	CX,40H
	MOV	DS,CX
	MOV	SI,006CH
	MOV	CL,[SI]

	POP	DS
	POP	SI
	RET
GET_TIME ENDP

GET_PORT PROC NEAR
	PUSH	SI
	PUSH	DS

	PUSH	AX
	MOV	AX,40H
	MOV	DS,AX
	SUB	SI,SI
	POP	AX
	SHL	AL,1
	ADD	SI,AX
	LODSW
	MOV	DX,AX

	POP	DS
	POP	SI
	RET
GET_PORT ENDP

SP_HANDLER:
	PUSHF
	CLI
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	PUSH	ES
	PUSH	BP

	MOV	DX,CS:WORD PTR COM_PORT
	ADD	DX,2
CHECK_INTERRUPT:
	IN		AL,DX
	TEST	AL,1
	JNZ	SP_HANDLER_EXIT

	MOV	DS,CS:WORD PTR DATSEG
	MOV	ES,CS:WORD PTR EXTRASEG
	PUSH	DX

LONGCALL:
	DB	9AH
	DW	0000
	DW	0000

	POP	DX
	JMP	CHECK_INTERRUPT
SP_HANDLER_EXIT:
	MOV	AL,20H
	OUT	20H,AL
	POP	BP
	POP	ES
	POP	DS
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POPF
	IRET

_SP_INSTALL PROC FAR
	CLI
	PUSH	BP
	MOV	BP,SP
	PUSH	DX
	PUSH	DI
	PUSH	DS
	PUSH	ES

	PUSH	DS
	POP	AX
	MOV	CS:WORD PTR DATSEG,AX
	PUSH	ES
	POP	AX
	MOV	CS:WORD PTR EXTRASEG,AX

	MOV	AX,[BP+6]
	MOV	CS:WORD PTR LONGCALL+1,AX			;STORE OFFSET OF C HANDLER,
	MOV	AX,[BP+8]
	MOV	CS:WORD PTR LONGCALL+3,AX			;STORE SEGMENT OF C HANDLER.
	MOV	AX,[BP+10]
	MOV	CS:WORD PTR COM_NUM,AX				;STORE COM PORT ID NUMBER.

	MOV	CS:WORD PTR VECTOR,COM1_VECT	;ASSUME COM1 OR COM3.
	MOV	CS:WORD PTR BITMASK,0EFH
	CMP	AX,0000
	JZ		SET_VECT
	CMP	AX,2
	JZ		SET_VECT
	MOV	CS:WORD PTR VECTOR,COM2_VECT	;USE COM2 OR COM4.
	MOV	CS:WORD PTR BITMASK,0F7H
SET_VECT:
	MOV	DI,CS:WORD PTR VECTOR
	SUB	AX,AX
	MOV	ES,AX
	MOV	AX,ES:[DI]
	MOV	CS:WORD PTR OLD_INT_OFF,AX
	MOV	AX,OFFSET SP_HANDLER
	STOSW
	MOV	AX,ES:[DI]
	MOV	CS:WORD PTR OLD_INT_SEG,AX
	MOV	AX,CS
	STOSW

	MOV	AX,CS:WORD PTR COM_NUM
	CALL	GET_PORT
	MOV	CS:WORD PTR COM_PORT,DX
	ADD	DX,4			;DX=MODEM CONTROL REGISTER (3FC).
	MOV	AL,0BH
	OUT	DX,AL
	SUB	DX,3			;DX=INTERUPT ENABLE REGISTER (3F9).
	MOV	AL,01H		;INTERRUPT ON RECEIVE ONLY.
	OUT	DX,AL

	IN		AL,21H
	MOV	CS:WORD PTR OLD_BITMASK,AX
	AND	AX,CS:WORD PTR BITMASK
	OUT	21H,AL

	POP	ES
	POP	DS
	POP	DI
	POP	DX
	POP	BP
	STI
	RET
_SP_INSTALL ENDP

_SP_UNINSTALL PROC FAR
	CLI
	PUSH	DI
	PUSH	ES

	MOV	AX,CS:WORD PTR OLD_BITMASK
	OUT	21H,AL

	SUB	AX,AX
	MOV	ES,AX
	MOV	DI,CS:WORD PTR VECTOR
	MOV	AX,CS:WORD PTR OLD_INT_OFF
	STOSW
	MOV	AX,CS:WORD PTR OLD_INT_SEG
	STOSW

	POP	ES
	POP	DI
	STI
	RET
_SP_UNINSTALL ENDP

	CODE ENDS
	END
