#define Uses_TRect
#define Uses_TView
#define Uses_TDrawBuffer
#include <tv.h>

#include <stdlib.h>
#include <mem.h>
#include <bios.h>
#include "infoview.h"


extern unsigned long xmit_count,recv_count;
extern int baud_rate,com_port;

InfoView::InfoView(TRect& r) : TView(r)
{
	memset(xmit_buff,0,sizeof(xmit_buff));
	memset(recv_buff,0,sizeof(recv_buff));
	memset(baud_buff,0,sizeof(baud_buff));
	memset(com_buff,0,sizeof(com_buff));
}


void InfoView::draw()
{
char c=getColor(2);
TDrawBuffer	buff;

	buff.moveChar(0,' ',c,size.x);

	buff.moveStr(0,"Bytes Sent:",c);
	buff.moveStr(11,xmit_buff,c);

	buff.moveStr(20,"Bytes Received:",c);
	buff.moveStr(35,recv_buff,c);

	buff.moveStr(45,"Baud Rate:",c);
	buff.moveStr(55,baud_buff,c);

	buff.moveStr(65,"COM Port:",c);
	buff.moveStr(74,com_buff,c);

	writeLine(0,0,size.x,1,buff);
}


void InfoView::update()
{
static unsigned long xmit=0,recv=0;
static int baud=0,port=0;
int	b;

	if((xmit!=xmit_count) || (recv!=recv_count) || (port!=com_port) || (baud!=baud_rate))
	{
		xmit=xmit_count;
		recv=recv_count;
		baud=baud_rate;
		port=com_port;

		switch(baud)
		{
			case _COM_1200:
				b=1200;
				break;

			case _COM_2400:
				b=2400;
				break;

			case _COM_4800:
				b=4800;
				break;

			case _COM_9600:
				b=9600;
				break;
		}

		ultoa(xmit,xmit_buff,10);
		ultoa(recv,recv_buff,10);
		itoa(b,baud_buff,10);
		itoa(port+1,com_buff,10);
		drawView();
	}
}

