#define Uses_TApplication
#define Uses_TNSCollection
#define Uses_TCollection
#define Uses_TEvent
#define Uses_TListBox
#include <tv.h>
#include "listbox.h"


void *ListBox::at(ccIndex index)
{
	return list()->at(index);
}


void ListBox::atFree(ccIndex index)
{
	if(!list()->getCount())
		return;

	list()->atFree(index);
	setRange(list()->getCount());
	drawView();
}


ccIndex ListBox::getCount()
{
	return list()->getCount();
}


void ListBox::insert(void *item)
{
	list()->insert(item);
	setRange(list()->getCount());
}


void ListBox::insertDraw(void *item)
{
	insert(item);
	drawView();
}


void ListBox::removeAll()
{
	list()->removeAll();
	setRange(list()->getCount());
	drawView();
}


void ListBox::handleEvent(TEvent& event)
{
	if((event.what==evMouseDown) && (event.mouse.doubleClick))
	{
		message(owner,evBroadcast,cmListItemSelected,this);
		clearEvent(event);
	}

	TListBox::handleEvent(event);
}


