;;
	name	goscom
	page	72,132
	title	'GOSCOM - GoScript driven by Com Port prog.'
;
; PROGRAM TO RUN "GOSCRIPT" FROM SERIAL PORT INPUT
;
; Problem: You are running along in Windows, and you want to print
; PostScript output.  However, being a cheap person, you didn't spend
; thousands on a Laserwriter NTX.  You have a "software" PostScript 
; interpreter.  You have to leave Windows, even if through a batch file,
; and you suffer various kinds of memory and execution conflicts, etc. Sigh.
;
; If you have a second computer lying around, the answer to the 
; problem described is to use that second computer to 
; do the interpretation to drive a printer.   Interpreters such as
; GoScript are fine, they run on second computers, 
; but they only accept input from a file.
;
; I/O re-direction is not the answer, because the dingos at
; Microsoft dod not include a buffered serial port driver in the system i/o
; routines.  And its a pain to move a file.  Thus this silly little program.
;
; Run from the command line, this code sets up and listens
; to a comm port.   A file is created and written consisting of all input
; received thorugh the comm port.  When a diamond character
; (PostScript End-of-Transmission Character) or a hex 1A, ^Z, 
; DOS End-of-File is received, the created file is closed
; and used as input to the GoScript program, which is invoked
; through an EXEC call.
;
; The input to the serial port should preferably have LFs at
; the end of lines.  Most generated PostScript output seems to.  Otherwise,
; we fill a buffer that, in this copy, is 1K long.  (Of course, it can be
; lengthened or shortened as required.  Change the compare in the interrupt
; service routine.)
;
; PostScript output may or may not have an EOT (diamond) character at the end
; of the generated output.  Therefore, one may force printing by pressing the
; p key.  Without an end-of-file character, there is no way to know,
; listening to a serial port, that you've come to the end of the file.
;
; This program will run at 19,200; a given machine may not be fast enough
; to cope with speeds higher than 9,600.  Adjust to suit.
;
; There is some code in this program to send XON/XOFF and to 
; change the DTR line to do handshaking.
; It has not, however, received any testing, and may not be the right answer.
;
; Somebody who wanted to work an improvement would splice in code to 
; cope more cleverly with PostScript "preambles" so-called.  Send me a copy.
;  (The other alternative, and not such a bad one, is a batch file.)
;
; Assembled with Borland's Turbo Assembler, v.2.  B. Reeve.
;
pic_mask	equ	21h	;port addr. 8259A mask reg.
pic_eoi		equ	20h	;port addr. 8259A EOI instr.
;
; Set comm_port=0 for COM1: set comm_port=1 for COM2:
;
comm_port	equ	1	;COM2 set
;
	if	comm_port	;
;	Settings for COM2:
com_data	equ	02F8h	;
com_ier		equ	02F9h	;
com_lcr		equ	02FBh	;
com_mcr		equ	02FCh	;
com_stat	equ	02FDh	;
com_int		equ	0Bh	;
int_mask	equ	08h	;
;
	else	;
;	Settings for COM1:
com_data	equ	03F8h	;Com data port.
com_ier		equ	03F9h	;Com Int. Ena. Reg.
com_lcr		equ	03FBh	;Com Line Contr. REg.
com_mcr		equ	03FCh	;Com Modem Contr Reg.
com_stat 	equ	03FDh	;Com Status Register.
com_int		equ	0Ch	;Com interrupt.
int_mask	equ	10h	;Mask for 8259A int.
				;controller, Com1 is IRQ4.
	endif	;
;
;
lf	equ	0Ah	;Linefeed char for msgs.
cr	equ	0Dh	;Car ret char for msgs.
xon	equ	11h	;XON char.
xoff	equ	13h	;XOFF char.
lf_char	equ	0Ah	;Linefeed character for input stream.
eot_char equ	04h	;End of Postscript stream char.
eof_char equ	1Ah	;Dos EOF char.
;
stdin	equ	0	;Standard input.
stdout	equ	1	;Standard output.
stderr	equ	2	;Standard error.
;
	.model TINY
	.code
	org	100h	;To be a COM file.
;
; Upon Entry -
;
goscom:
;
; Set up stack pointer to stack within our area:
;
	mov	sp,offset stck_area	;
;
; Acquire memory.
;
get_mem:
	mov	bx,cs		;Copy cs to es.
	mov	es,bx		;es now points to our PSP.
	mov	bx,1000h	;64k area - most we can get (?)
	mov	ah,4Ah		;"Setblock" funtion.
	int	21h		;Dos services.
;
	jnc	get_mem_ok	;No carry, no error, continue.
	mov	dx,offset err_mem_msg	;
	mov	cx,err_mem_msgl	;
	mov	bx,stderr	;handle for std err.
	mov	ah,40h		;Write to device.
	int	21h		;Dos services.
get_mem_ok:
;
; Open (Create) file for output:
;
creat_fil:
	xor	ax,ax	;Clear, just for openers.
	mov	ah,3Ch	;Create or truncate file int code.
	xor	cx,cx	;cx=0 file attribute=normal.
	mov	dx,offset ofilnam
	int	21h	; Dos services.
;
	jnc	creat_hdl	;no error, stash handle.
	mov	dx,offset err_creat_msg	;
	mov	cx,err_creat_msgl	;
	mov	bx,stderr	;handle for std err.
	mov	ah,40h		;Write to device.
	int	21h		;Dos services.
;
creat_hdl:
	mov	ofilhdl,ax	;File handle returned in ax.
;
; Do serial port setup:
;
;ser_set:
	mov	ah,00h	;Function 0, serial
			;port initialization.
	mov	al,0E3h	;9600,8,n,1
	mov	dx,comm_port	;Port COM1:=0, COM2:=1.
	int	14h	;Int to set port.
;
; Increase speed to 19,200:
;  -- Comment this out if a particular machine can't go this fast.
;
	mov	dx,com_lcr	;Set "bit 7" of modem line cntrl reg.
	in	al,dx		;get present setting.
	or	al,080H		;Turn on Port Toggle bit.
	out	dx,al		;Send out.
;
	mov	dx,com_data	;Low byte BaudRt divisor.
	mov	al,06h		;Set to 06h.
	out	dx,al		;
;
	mov	dx,com_ier	;High byte BaudRt divisor.
	mov	al,0		;Set to 0.
	out	dx,al		;
;
	mov	dx,com_lcr	;Reset "bit 7" of line cntrl reg.
	in	al,dx		;get present setting.
	and	al,07Fh		;Turn off Port Toggle bit.
	out	dx,al		;Send out.
;
; Set Vector to Our Own Interrupt Handler.
;
	push	es		;
	mov	ah,35h		;Dos serv. 35 is get vector.
	mov	al,com_int	;Ser port COM1:is 0C, COM2 is 0B.
	int	21h		;Dos serv. int.
	mov	sav_intseg,es	;Save old segment add. for
	 			;replace upon exit.
	mov	sav_intofs,bx	;Save old off.
	pop	es		;
;
	mov	ah,25h		;Dos serv. 25 is set new vect.
	mov	al,com_int	;Ser port int. COM1 is 0C, COM2 is 0B.
	mov	dx,offset ser_int	;
	int	21h		;Dos serv. int.
;
	mov	dx,com_mcr	;MCreg. for COM1 is 3FCh, COM2 is 2FCh.
	mov	al,0Bh		;Ena.Ints. DTR, RTS on.
	out	dx,al		;
;
	mov	dx,com_ier	;Int.Ena.Reg for COM1 is 3F9h, COM2 is 2F9h.
	mov	al,01h		;Data Received Int Enable.
	out	dx,al		;
;
	in	al,pic_mask	;Read 8259A int mask.
	and	al,not int_mask	;'reset mask' for com port.
	out	pic_mask,al	;Write back out.
;
; Vars setup:
;
	mov	exec_flg,0	;Zero flags.
	mov	xon_flg,0	;
	mov	ax,0	;
	mov	line_inp,cx	;
	mov	line_ckp,cx	;Zero pointers.
	mov	line_outp,cx	;
;
; Greeting message: "p or q to get out."
;
	mov	dx,offset greet_msg	;
	mov	cx,greet_msgl	;
	mov	bx,stdout	;handle for std output.
	mov	ah,40h		;Write to device.
	int	21h		;Dos services.
;
; Main Loop:
;
main_loop:
	mov	bx,line_ckp	;Pick up check pointer.
	cmp	bx,line_inp	;Have we any new chars in?
	jge	main_xtest	;No, go to xoff and keyb test.
;
	mov	al,[bx+line_bufr] ; pick up character.
;
	inc	bx		;Advance check point one char. 
	mov	line_ckp,bx	;Store new pointer value.
;
	cmp	al,lf_char	;line feed char?
	jne	main_char2	;No, keep checking.	
;
	call	write_line	;Yes, go to write proc.
	jmp	main_loop	;And do main loop.
;
main_char2:
	cmp	al,eot_char	;Diamond char (eot) - end of trans.
	je	end_proc	;Yes, go to finish proc.
	cmp	al,eof_char	;DOS EOF character? (1A hex)
	je	end_proc	;Yes, treat that as end.
;
	jmp	main_loop	;Cycle through.
;
main_xtest:
	cmp	xon_flg,0	;Is input turned off?
	je	main_keytst	;No, continue.
;
	call	write_line	;Output and clear.
;
	mov	dx,com_stat	;03FDh for COM1, Status reg. COM2 is 2FDh.
main_xt_intck:
	in	al,dx		;
	and	al,20H		;Is xmit bufr empty?
	jz	main_xt_intck	;No, circle till ready.
;
	mov	al,xon		;Send xon - Turn on input.
	mov	dx,com_data	;
	out	dx,al		;
;
	mov	dx,com_mcr	;Pick up Modem Cntrl REg.
	in	al,dx		;
	or	al,01h		;Turn on bit 0.
	out	dx,al		;Write back out.
;
	mov	xon_flg,0	;Set flg to com line open.
	jmp	main_loop	;Cycle through.
;
main_keytst:
	mov	ah,06h		;Function 6, read keyboard raw.
	mov	dl,0FFh		;Read requires FF in dl.
	int	21h		;Dos services.
	jz	main_loop	;Nothing, loop back.
;
	cmp	al,'p'	;Quit and print?
	je	end_proc	;Yes, go to end processing.
;
	cmp	al,'q'	;Quit w/o print?
	jne	main_loop	;No, go back to main loop.
	mov	exec_flg,0FFh	;Turn off print flag.
;
;Closeout Processing:
;
end_proc:
	call	write_line	;Output whatever is lying around.
;
	mov	ah,3Eh	;Close file
	mov	bx,ofilhdl	;file handle in bx.
	int	21h	;Dos services.
	jnc	end_pr2	;No carry set if no err, continue.
	mov	dx,offset err_close_msg	;Close error - write msg.
	mov	cx,err_close_msgl	;
	mov	bx,stderr	;handle for std error.
	mov	ah,40h		;Write to device.
	int	21h		;Dos services.
;
end_pr2:
;
; If exec_flg not off, then
; Exec Goscript program, with file 'print.ps' as input.
;
	cmp	exec_flg,0	;Exec flg on?
	jne	exec_fin	;No, jmp around.
;
; Release memory.
;
	mov	bx,cs	;Copy cs to es.
	mov	es,bx	;
	mov	bx,100h	;Keep a 6k area - just for yuks.
	mov	ah,4Ah	;"Setblock" function.
	int	21h	;Dos services.
;
	jnc	gs_exec		;No carry, no error, continue.
	mov	dx,offset err_mem_msg	;
	mov	cx,err_mem_msgl	;
	mov	bx,stderr	;handle for std err.
	mov	ah,40h		;Write to device.
	int	21h		;Dos services.
;
gs_exec:
	push	ds		;Do exec.
	push	es	;
	mov	ax,cs		;Copy cs for es:bx pointer.
	mov	es,ax		;
	mov	cs:stk_seg,ss	;Save stack seg,ofs.
	mov	cs:stk_ofs,sp	;
	mov	ah,4Bh	;Dos EXEC function.	;
	mov	al,00	;Load and execute.
	mov	par_cmd_seg,ds	;Fill in segment.
	mov	bx,offset par_block	;pointer to parameter block.
	mov	dx,offset prog_name	;pointer to "gs.exe" name.
	int	21h	;Dos services.
	mov	ss,cs:stk_seg	;Restore stack seg,ofs.
	mov	sp,cs:stk_ofs	;
	pop	es	;
	pop	ds	;
;
	jnc	gs_exe_done	;No carry, no err, cont.
;
	mov	dx,offset err_exec_msg	;
	mov	cx,err_exec_msgl	;
	mov	bx,stderr	;handle for std err.
	mov	ah,40h		;Write to device.
	int	21h		;Dos services.
;
gs_exe_done:
	jmp	far ptr get_mem		;Start all over again.
					;- at least for now.
exec_fin:
;
; Restore interrupt, interrupt vector.
;
	in	al,pic_mask	;Read 8259A int. mask.
	or	al,int_mask	;
	out	pic_mask,al	;Write back.
;
	push	ds	;
	mov	dx,sav_intofs	;
	mov	ds,sav_intseg	;
	mov	ah,25h	;Set interrupt vector.
	mov	al,com_int	;COM1 is int 0C, COM2 is int 0B.
	pop	ds
;
; Terminate.
;
	mov	ah,4Ch	;Function 4C -Terminate Program
	mov	al,0	;Return code.
	int	21h	;Dos services.
;
;
;Line Output:
;
write_line:
	mov	cx,line_ckp	;Pick up check pointer.
	mov	bx,line_outp	;And output ptr.
	sub	cx,bx		;Minus output pointer.
	je	write_ln_ret	;Zero, Nothing to write, skip.
	mov	ah,40H	;function 40 - write to file.
	mov	bx,ofilhdl	;File handle in bx.
	mov	dx,offset line_bufr	;Ofs of line bufr.
	add	dx,line_outp	;Plus output pointer, points to curr outp.
	int	21h	;Dos services.
;
	jnc	write_ln2	;No write err, continue.
	mov	dx,offset err_writ_msg	;
	mov	cx,err_writ_msgl	;
	mov	bx,stderr	;handle for std err.
	mov	ah,40h		;Write to device.
	int	21h		;Dos services.
;
write_ln2:
	jne	write_ln3	;No diskfull error, continue.
	mov	dx,offset err_dskful_msg	;
	mov	cx,err_dskful_msgl	;
	mov	bx,stderr	;handle for std err.
	mov	ah,40h		;Write to device.
	int	21h		;Dos services.
;
write_ln3:
	mov	bx,line_outp	;Pick up existing output pointer.
	add	bx,ax		;ax has no. of chars written
	mov	line_outp,bx	;New output pointer.
;
	cmp	bx,line_inp	;Have we written
				;everything we've received?
	jne	write_ln_ret	;
	mov	line_inp,0	;If yes,
	mov	line_ckp,0	;Start again with all ptrs.
	mov	line_outp,0	;
;
write_ln_ret:			;
	ret			;
;
;	Interrupt Service Routine:
;	-- Here on interrupt from relevant com port
;
ser_int	proc	far	;Interrupt service routine.
;
	push	ax	;
	push	bx	;
	push	dx	; Save registers.
	push	ds	;
;
	mov	ax,cs	;cs: to ds: - prob unnec, but...
	mov	ds,ax	;I read it in a book.
;
	mov	dx,com_data	;Com port data.
	in	al,dx	;Read in byte.
;
	sti			; Interrupts back on.
	cli			; And clear.
;
	cmp	al,0		;is it a null?
	je	ser_int_retn	;If so, throw it away.
;
	mov	bx,line_inp	;Pick up input pointer.
	mov	[line_bufr+bx],al	;Store character.
	inc	bx		;Increment.
	mov	line_inp,bx	;Store pointer.
;
	cmp	bx,3FFh		;Going over the end?	
	jle	ser_int_retn	;No, store and return.
;
ser_int2:
	mov	dx,com_stat	;03FDh for Com1, Status reg.
ser_int_ck:
	in	al,dx		;
	and	al,20h		;Is xmit bufr empty?
	jz	ser_int_ck	;no, circle till ready.
;
	mov	xon_flg,0FFh	;Set false to ind. line off.
	mov	al,xoff		;Send xoff - softwe handshake.
	mov	dx,com_data	;
	out	dx,al		;
;
	mov	dx,com_mcr	;- hardware handshake.
	in	al,dx		;Pick up modem contrl reg.
	and	al,0FEh		;Turn off bit 0.
	out	dx,al		;Send back out.
;
ser_int_retn:
	mov	al,20H	;Send End of Int. to 8259A.
	out	pic_eoi,al	;
	pop	ds	
	pop	dx	;restore regs.
	pop	bx	;
	pop	ax
	iret
;
ser_int	endp		;
;
exec_flg	db	0	;
xon_flg		db	0	;
;
greet_msg	db	cr,lf,'GosCom: press p to force printout',cr,lf
		db	'              q to quit w/o printing',cr,lf
greet_msgl	equ	$-greet_msg	;length
;
err_mem_msg	db	cr,lf,'Mem Alloc Error',cr,lf
err_mem_msgl	equ	$-err_mem_msg	;length
;
err_creat_msg	db	cr,lf,'Create File Error',cr,lf
err_creat_msgl	equ	$-err_creat_msg	;length
;
err_writ_msg	db	cr,lf,'Write Error',cr,lf
err_writ_msgl	equ	$-err_writ_msg	;length
;
err_dskful_msg	db	cr,lf,'Disk Full Error',cr,lf
err_dskful_msgl	equ	$-err_dskful_msg	;length
;
err_close_msg	db	cr,lf,'Close Error',cr,lf
err_close_msgl	equ	$-err_close_msg	;length
;
err_exec_msg	db	cr,lf,'Exec Error',cr,lf
err_exec_msgl	equ	$-err_exec_msg	;length
;
ofilnam	db	'c:\gos\print.ps',0
ofilhdl	dw	0	;file handle word.
;
prog_name	db	'c:\gos\gs.exe'
;
par_block	label	word	;
		dw	0	;segment address, environment block, N/A.
par_cmd_ofs	dw	offset cmd_tail	;Command parameter list.
par_cmd_seg	dw	0	;To be filled in w/seg.
		dd	-1	;FCBS - not used.
		dd	-1	;
;
cmd_tail	db	16,' c:\gos\print.ps',0Dh	;
;
;
;
stk_seg		dw	0	;Stack save for exec.
stk_ofs		dw	0	;
;
sav_intseg	dw	0	;seg:ofs of old int vect
sav_intofs	dw	0	;for later restore.
;
line_inp	dw	0	;input pointer.
line_outp	dw	0	;output pointer.
line_ckp	dw	0	;check pointer along line.
;
; Stack:
	db	10h dup ('*Stack**')	;
stck_area	equ	$	;pointer at --top-- of stack
;
; 1K line buffer in this version.
;
line_bufr	label byte 	;Line buffer from here.
	db	81h dup ('--Line--')	;Line buffer.
last_byte	label byte	;End of prog.
;
        end	goscom		;
