/*  ASCII - Show ASCII text in a file.

    Version 1.15, created on 03/07/85 at 00:15:43

    BY: Thom Henderson

(C) COPYRIGHT 1985 by System Enhancement Associates; ALL RIGHTS RESERVED

    DESCRIPTION:
         This program prints a list of all ASCII text in a file.  It
         can be used to, among other things, show all text messages
         in an .EXE or .COM file.

    INSTRUCTIONS:
         Run this program with no arguments for complete instructions.

    LANGUAGE:
         Computer Innovations Optimizing C86
*/
#include <stdio.h>

main(num,arg)                          /* system entry point */
int num;                               /* number of arguments */
char *arg[];                           /* pointers to arguments */
{
    FILE *f, *fopen();                 /* file to scan, opener */
    int c;                             /* one character from file */
    long loc = 0;                      /* location in file */
    int len = 0;                       /* length of string so far */
    int wid = 0;                       /* width of output so far */
    char buf[79];                 /* output buffer */
    char *b = buf;                     /* output buffer pointer */
    char *upper();                     /* case converter */

    if(num<2)                          /* no args - give help */
    {    printf("ASCII, Version 1.15, created on 03/07/85 at 00:15:43\n");
         printf("(C) Copyright 1985 by System Enhancement Associates;");
         printf(" ALL RIGHTS RESERVED\n\n");

         printf("You are granted a license to use this product for a");
         printf(" period of TWO WEEKS.\n");
         printf("If you wish to continue using this product once your");
         printf(" two week trial period\n");
         printf("is up, then you must send twenty dollars ($20) to:\n\n");

         printf("    System Enhancement Associates\n");
         printf("    12 Franklin Avenue\n");
         printf("    Clifton, NJ  07011\n\n");

         printf("You are also encouraged to freely copy and distribute");
         printf(" this product,\n");
         printf("provided that no fee is charged for said copying");
         printf(" and/or distribution, and\n");
         printf("provided that it is distributed ONLY in its original,");
         printf(" unmodified form.\n\n\n");

         printf("Usage: ascii <filename>\n\n");
         printf("Where <filename> is any valid DOS 2.0+ path name.\n");
         return(1);
    }

    f = fopen(arg[1],"rb");
    if(!f)
         abort("Unable to read %s",upper(arg[1]));

    while(!feof(f))
    {    c = fgetc(f);                 /* get a character */

         if(c=isascii(c))              /* if ASCII text */
         {    if(!wid)                 /* if start of a line */
              {    sprintf(buf,"%lx: ",loc);
                   while(*b++)         /* find end/length of address */
                        wid++;
                   b--;
              }
              *b++ = c;                /* save the text character */
              len++; wid++;            /* update length/width */

              if(wid>=79)         /* if at edge of screen */
              {    *b = '\0';          /* terminate the text */
                   printf("%s\n",buf); /* dump the buffer */
                   b = buf;            /* restart buffer */
                   wid = 0;
              }
         }

         else                          /* not ASCII text */
         {    if(len>4 && wid)    /* if enough to print */
              {    *b = '\0';          /* then terminate the buffer */
                   printf("%s\n",buf); /* and dump it */
              }
              b = buf;                 /* restart the buffer */
              len = wid = 0;
         }

         loc += 1;                     /* update file location */
    }

    if(len>4 && wid)              /* if anything was left hanging */
    {    *b = '\0';                    /* then terminate the buffer */
         printf("%s\n",buf);           /* and dump it */
    }

    makefnam("X;\\",arg[1],buf);       /* get name with fixed path */
    b = buf + 3;                       /* point to name without path */
    printf("\nLength (%s) = %lx hex\n",upper(b),loc);

    return 0;
}

int isascii(c)                         /* test and map characters */
int c;                                 /* character to test */
{
    if(isprint(c))                     /* if printable */
         return c;                     /* then that is that */
    if(c=='\r')                        /* return */
         return 27;                    /* map to left arrow */
    if(c=='\n')                        /* linefeed */
         return 24;                    /* map to uparrow */
    if(c=='\t')                        /* tab */
         return 26;                    /* map to right arrow */
    return 0;                          /* that's all for now */
}
