/* BootChk.c */

#include <dos.h>
#include <fcntl.h>
#include <stat.h>
#include <stdio.h>
#include <stdlib.h>

#define DESCLEN 25
#define BOOTAREAS 7

int Drive;
int Handle;
unsigned char FileBuf[512];
unsigned char BSbuffer[512];

typedef struct { int End;
                 char Desc[DESCLEN];
               } bootarea;

bootarea BootArea[BOOTAREAS]={ {0x0002, "JMP op code"},
                               {0x000A,  "OEM name & version"},
                               {0x0017,  "BIOS parameter block"},
                               {0x001D,  "Format information"},
                               {0x01BD, "Boot code"},
                               {0x01CD, "Partition info"},
                               {0x01FF, "Boot code"} };

void read_boot_sector()
{
   static union REGS IReg, OReg;
   static struct SREGS SReg;
   int i, Stat;
   static int AL_id[] = {0x00, 0x01, 0x02, 0x04, 0x06, 0x07, 0x08,
           0x0a, 0x0b, 0x0c};
   static char *AL_err[] = { "Write protected\n", "Invalid drive\n",
      "Drive not ready\n", "CRC/Parity error\n", "Seek error\n", 
      "Unknown media\n", "Sector not found\n", "Write error\n", 
      "Read error\n", "General error\n" };
   static int AH_id[]={0x00, 0x02, 0x03, 0x04, 0x08, 0x10, 0x20,
           0x40, 0x80};
   static char *AH_err[] = { "Other errors\n", "Bad address, sector not found\n",
      "Write protect error\n", "DMA failure\n", "Bad CRC\n", "Controller failed\n",
      "Bad seek\n", "Time out\n"};

   IReg.x.ax = Drive-'A';   
   IReg.x.cx = 1; /* read 1 sector */
   IReg.x.dx = 0; /* read sector 0 */
   SReg.ds = _CS; /* segment of target buffer */
   IReg.x.bx = BSbuffer; /* offset of target buffer */

   int86x( 0x25, &IReg, &OReg, &SReg );
   _SP-=2;

   if(OReg.x.cflag > 0)   {
      if(Stat=biosdisk(2, (Drive>='C')?(0x80+Drive-'C'):(Drive-'A'), 0, 0, 1, 1, (void *) BSbuffer)) {
            fputs("Error: unable to read boot sector.\n", stderr);
            for(i=0; (i<10) && (AL_id[i]!=IReg.h.al); i++)
               ;
            if( i<10 ) { fputs( AL_err[i], stderr ); }
            for(i=0; (i<9) && (AH_id[i]!=IReg.h.ah); i++)
               ;
            if( i<9 ) { fputs( AH_err[i], stderr ); }
            
            fputs("Bios read failed too.\n", stderr);
            exit(1);
      }
   }
}


int findbootarea( int ByteNum )
{
   int k;
   
   for(k=0; ByteNum > BootArea[k].End; k++);
   return k;
}


void compare()
{
   int i, c, j;

   c = 0;
   for(i=0; i<512; i++)  {
     if( BSbuffer[i] != FileBuf[i] )  {
       if(c==0)  {
          puts("Byte     Boot Sector      Save File      Area");
          c++;
       }
       j=findbootarea(i);
       printf("%4x      %2x    %c           %2x   %c        %s\n",
                i, (int) BSbuffer[i], BSbuffer[i],
                (int) FileBuf[i], FileBuf[i],
                &BootArea[j].Desc[0] );
     }
   }
   if(c==0)
      puts("Boot Sector is OK.");
}


void show_help()
{
   puts("HELP SCREEN\n");
   puts("   BootChk is a virus detection program. Its purpose is to");
   puts("compare your computer's boot sector with a copy that is known");
   puts("to be uncorrupted. Any differences found are reported by");
   puts("offset in the boot sector, the current value, the 'good' value,");
   puts("and a description of the logical location within the boot");
   puts("sector. The last item is given to help you determine if the");
   puts("change is of any significance to the operation of your computer.");
   puts("\n   BootChk accepts one or two parameters.  If the first is a '?'");
   puts("and only one parm is passed, this help text is displayed.");
   puts("Otherwise, the format is as follows:");
   puts("         bootchk d: filename.ext");
   puts("d:             is the drive whose boot sector you want to check.");
   puts("filename.ext   is the copy of the boot sector that is believed");
   puts("               to be good.");
   puts("\n   If this is the first time you're running this program,");
   puts("filenam.ext will not exist and this program will copy your boot");
   puts("sector to that file. If the file exists when bootchk is run, the");
   puts("comparison is made.");
}


int main( int argc, char *argv[] )
{

   fputs("BootChk v1.0: Copyright (c) 1995 by Bryan L. Leaman. All rights reserved.\n", stderr);

   if ((argc==1) || (argc==2 && argv[1][0]=='?' && argv[1][1]=='\0'))  {
      show_help();
      exit(0);
   }
   if (argc!=3) {
      fputs("Error: wrong number of parameters.\n", stderr);
      exit(1);
   }

   Drive=*argv[1] & 0xDF; /* upper case drive letter */

   read_boot_sector();
   if( (Handle=_open( argv[2], O_RDONLY|O_BINARY )) >= 0 )  {
       fputs("Comparing boot sector.\n", stderr);
       _read( Handle, FileBuf, 512 );
       compare();
       _close(Handle);
   }
   else  {
      if( (Handle=open( argv[2], O_CREAT|O_WRONLY|O_BINARY, S_IWRITE )) < 0 )  {
          fputs("Error: unable to write file.\n", stderr);
          exit(1);
      }
      fputs("Writing backup boot sector.\n", stderr);
      _write( Handle, BSbuffer, 512 );
      _close(Handle);
   }
}

