unit DateSetMain;
{Tom Smith: Date-Time Stamp Utility,
 ver. 1.3 June 26, 1997, for Delphi 3, this is the main form}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, Grids, Outline, DirOutln, Tabs, ExtCtrls, Menus,
  ComCtrls, PDateF, Buttons, ShellAPI, RegistrU;

type
  TDateForm = class(TForm)
    StatusBar: TPanel;
    DirectoryPanel: TPanel;
    FilePanel: TPanel;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Panel1: TPanel;
    LeftPanel: TPanel;
    DirectoryOutline: TDirectoryListBox;
    LeftBottomPanel: TPanel;
    DriveComboBox1: TDriveComboBox;
    Drive_DirLBL: TLabel;
    FilePanelLbl1: TLabel;
    FilePanelLbl2: TLabel;
    RightPanel: TPanel;
    GroupBox1: TGroupBox;
    ListBox1: TListBox;
    Label5: TLabel;
    DelEntryBtn: TButton;
    MiddlePanel: TPanel;
    GroupBox2: TGroupBox;
    FileList: TFileListBox;
    AddSelectionBtn: TButton;
    ClearAllBtn: TButton;
    LoadFileMnu: TMenuItem;
    S1: TMenuItem;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    StatusBar1: TStatusBar;
    StampSettingsGroupBox: TGroupBox;
    DateEdit: TEdit;
    Label2: TLabel;
    Button1: TButton;
    Label4: TLabel;
    Label1: TLabel;
    HourEdit: TEdit;
    UpDown1: TUpDown;
    Label6: TLabel;
    MinEdit: TEdit;
    UpDown2: TUpDown;
    N2: TMenuItem;
    A1: TMenuItem;
    NowBtn: TButton;
    GroupBox3: TGroupBox;
    OpenFileBtn: TSpeedButton;
    SpeedButton1: TSpeedButton;
    ArchiveFileNameLbl: TLabel;
    TimeDisplayEdit: TEdit;
    Timer1: TTimer;
    Label3: TLabel;
    NewDateBtn: TBitBtn;
    OptionsMnu: TMenuItem;
    ShowHintMnu: TMenuItem;
    WindowDefault: TMenuItem;
    Shortcut1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FileListChange(Sender: TObject);
    procedure NewDateBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FileListDblClick(Sender: TObject);
    procedure DelEntryBtnClick(Sender: TObject);
    procedure AddSelectionBtnClick(Sender: TObject);
    procedure ClearAllBtnClick(Sender: TObject);
    procedure S1Click(Sender: TObject);
    procedure LoadFileMnuClick(Sender: TObject);
    procedure InfoShowClick(Sender: TObject);
    procedure NowBtnClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure TimeDisplayEditClick(Sender: TObject);
    procedure ShowHintMnuClick(Sender: TObject);
    procedure OptionsMnuClick(Sender: TObject);
    procedure HourEditClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WindowDefaultClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Shortcut1Click(Sender: TObject);
  private
  {private declarations}
    MinWidth, MinHeight : Integer;
    procedure WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo);
    message WM_GETMINMAXINFO;
    function GetFileSize(const FileName: string): LongInt;
  public
    { Public declarations }
     procedure DisplayHint(Sender: TObject);
     Procedure SetDisplayToNow;

  end;

var
  DateForm: TDateForm;
  TheFileName: string;
  StampDate : Double;
  Time24, HintOn : Boolean;
implementation

uses AboutFrm, ShCutF;

{$R *.DFM}

const
  ProgID = 'Software\DateSet';

function TDateForm.GetFileSize(const FileName: string): LongInt;
var
  SearchRec: TSearchRec;
begin
  if FindFirst(ExpandFileName(FileName), faAnyFile, SearchRec) = 0 then
    Result := SearchRec.Size
  else Result := -1;
end;

procedure TDateForm.DisplayHint(Sender: TObject);
begin
  StatusBar1.Panels.Items[0].Text := Application.Hint;
end;

procedure TDateForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TDateForm.FormCreate(Sender: TObject);
begin
  HintOn := True;
  MinWidth :=  604;
  MinHeight := 300;
  {read settings from registry}
  Top         := GetFromRegistry(0,ProgID+'\Settings','Top',Top);
  Left        := GetFromRegistry(0,ProgID+'\Settings','Left',Left);
  Width       := GetFromRegistry(0,ProgID+'\Settings','Width',Width);
  Height      := GetFromRegistry(0,ProgID+'\Settings','Height',Height);
  HintOn      := GetFromRegistry(0,ProgID+'\Settings','HintOn',HintOn);
  {end of read settings from registry}

  TheFileName := '';
  SetDisplayToNow;
  ArchiveFileNameLbl.Caption := 'No Archive File Loaded';

  Application.ShowHint := HintOn;

  Time24 := False;
  TimeDisplayEdit.Text := FormatDateTime('   hh' + ':' +
         'nn am/pm ', Now);
  Application.OnHint := DisplayHint;
  Application.HintHidePause := 4500; {normal = 2500  millisec}
end;

{Limit minimum width and height}
procedure TDateForm.WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo);
begin
  if Visible then
    Message.MinMaxInfo^.ptMinTrackSize.X := MinWidth;
    Message.MinMaxInfo^.ptMinTrackSize.Y := MinHeight;
end;


{update when files selected for new date/time list changes}
procedure TDateForm.FileListChange(Sender: TObject);
begin
  with ListBox1 do
  begin
    if ItemIndex >= 0 then
    begin
      TheFileName := Items[ItemIndex];
      IF TheFileName <> '' THEN
      Begin
        FilePanelLbl1.Caption := Format(' %s, %d bytes ',
        [TheFileName, GetFileSize(TheFileName)]);

       FilePanelLbl2.Caption := FormatDateTime(' dd mmm yyyy' +', ' + 'hh' + ':' +
         'nn am/pm ', FileDateToDateTime(Fileage(TheFileName)));
      End;
    end
    else
    begin
    FilePanelLbl1.Caption := ' No File Selected ';
    FilePanelLbl2.Caption := ' No File Selected ';
    end;
  end; {end with}
end;

{set selected files to new date/time}
procedure TDateForm.NewDateBtnClick(Sender: TObject);
VAR
  SubjectFileHandle, i : integer;
BEGIN
  IF ListBox1.Items.Count < 1 THEN
          MessageDlg('No files in Date Stamp List,'
        + #13 +  'please place a file(s) in list so' + #13
        + 'program can change the date/time.', mtInformation, [mbOK], 0);
   {loop to update all files in list}
   WITH ListBox1 DO
     BEGIN
       FOR i := 0 TO Items.Count - 1 DO
       BEGIN
        SubjectFileHandle := FileOpen(ITEMS[i] , fmOpenReadWrite);{open subject file}

        {check for firsterror possibility}
        IF SubjectFileHandle <= 0 then
        MessageDlg('Failed to open file,' + #13 +
        'file may be in use.', mtWarning, [mbOK], 0);

        {set file to new date/time and check for error}
        IF  FileSetDate(SubjectFileHandle, DateTimeToFileDate(StampDate + {attempts to set the file date}
        ((StrToInt(HourEdit.Text) / 24)) + (StrToInt(MinEdit.Text) / (24 * 60)))) <> 0 then                         {0 returned if OK}
        MessageDlg('Failed to set time/date,'  + #13 +                   {not 0 gives this error message}
        'file may be in use.', mtWarning, [mbOK], 0);

        FileClose(SubjectFileHandle); {close subject file}
       END; {end of for}
     END; {end with listbox1}

      {update panels}
   WITH ListBox1 do
      begin
          if ItemIndex >= 0 then
          begin
            TheFileName := Items[ItemIndex];
            IF TheFileName <> '' THEN
            Begin
            FilePanelLbl1.Caption := Format(' %s, %d bytes ',
             [TheFileName, GetFileSize(TheFileName)]);
            FilePanelLbl2.Caption := FormatDateTime(' dd mmm yyyy' +', ' + 'hh' + ':' +
             'nn am/pm ', FileDateToDateTime(Fileage(TheFileName)));
            End
            else
            begin
            FilePanelLbl1.Caption := ' No File Selected ';
            FilePanelLbl2.Caption := ' No File Selected ';
            end;
        end;
    end;   {end with listbox1 do}
END;

procedure TDateForm.Button1Click(Sender: TObject);
begin
   DatePicFrm.ShowModal;
end;

procedure TDateForm.FileListDblClick(Sender: TObject);
begin
  ListBox1.Items.add(FileList.FileName);
end;

procedure TDateForm.DelEntryBtnClick(Sender: TObject);
begin
  ListBox1.Items.Delete(ListBox1.ItemIndex);
  IF NOT (ListBox1.SelCount >= 0) THEN
  BEGIN
      FilePanelLbl1.Caption := ' No File Selected ';
      FilePanelLbl2.Caption := ' No File Selected ';
  END;
end;

procedure TDateForm.AddSelectionBtnClick(Sender: TObject);
VAR
   i : integer;

begin
  WITH FileList DO
  BEGIN
   FOR i := 0 TO Items.Count - 1 DO
     IF Selected[i]
     THEN
     BEGIN
        ListBox1.Items.add(ExpandFileName(Items[i]));
     END;
   End; {end of DO}
end;

procedure TDateForm.ClearAllBtnClick(Sender: TObject);
begin
  WITH ListBox1 DO
  BEGIN
    WHILE ListBox1.Items.Count > 0  DO
       Items.Delete(0);
    End; {end of DO}

  FilePanelLbl1.Caption := ' No File Selected ';
  FilePanelLbl2.Caption := ' No File Selected ';
  ArchiveFileNameLbl.Caption := 'No Archive File Loaded';
  OpenDialog1.FileName := '';
  SaveDialog1.FileName := '';
end;

procedure TDateForm.S1Click(Sender: TObject);
begin
IF SaveDialog1.Execute THEN
  Begin
    ListBox1.Items.SaveToFile(SaveDialog1.FileName);
    FileList.Update;
  End;
end;

procedure TDateForm.LoadFileMnuClick(Sender: TObject);
begin
 IF OpenDialog1.Execute THEN
 Begin
   IF UpperCase(ExtractFileExt(OpenDialog1.FileName)) = '.DSA'
   THEN
     Begin
       ListBox1.Items.LoadFromFile(OpenDialog1.FileName);
       ArchiveFileNameLbl.Caption := OpenDialog1.FileName;
       SaveDialog1.FileName := OpenDialog1.FileName;
     End
   ELSE
     Begin
       MessageDlg('You have attempted to load a file which may be incompatible.'
        + #13 +  '             LOAD OPERATION CANCELLED'  + #13 +
       'Date Stamp Archive Files have the extension DSA.', mtInformation, [mbOK], 0)
     End;
 End;
end;

procedure TDateForm.InfoShowClick(Sender: TObject);
begin
 AboutBox.ShowModal;
end;

Procedure TDateForm.SetDisplayToNow;
Begin
  StampDate := Trunc(Date);
  DateEdit.Text :=  ' ' + FormatDateTime('dd mmm yyyy', StampDate);
  HourEdit.Text := IntToStr(Trunc(Time * 24));
  MinEdit.Text := IntToStr(Trunc(60 * Frac(Time * 24)));
End;

procedure TDateForm.NowBtnClick(Sender: TObject);
begin
  SetDisplayToNow;
end;

procedure TDateForm.Timer1Timer(Sender: TObject);
begin
IF Time24 = False
THEN
  Begin
    TimeDisplayEdit.Text := FormatDateTime('   hh' + ':' +
         'nn am/pm ', Now);
     TimeDisplayEdit.Hint :=
     'System Time|System Time, Click to toggle 24 - 12 hour clock, 12 hour ON now'
  End
ELSE
  Begin
    TimeDisplayEdit.Text := FormatDateTime('     hh' + ':' +
         'nn ', Now);
    TimeDisplayEdit.Hint :=
     'System Time|System Time, Click to toggle 24 - 12 hour clock, 24 hour ON now'
  End;
end;

procedure TDateForm.TimeDisplayEditClick(Sender: TObject);
begin
  Time24 := NOT Time24;
  IF Time24 = False
THEN
    TimeDisplayEdit.Text := FormatDateTime('   hh' + ':' +
         'nn am/pm ', Now)
ELSE
    TimeDisplayEdit.Text := FormatDateTime('     hh' + ':' +
         'nn ', Now)
end;

procedure TDateForm.ShowHintMnuClick(Sender: TObject);
begin
   Application.ShowHint := NOT Application.ShowHint;
end;

procedure TDateForm.OptionsMnuClick(Sender: TObject);
begin
  IF Application.Showhint = True
  THEN
  BEGIN
    ShowHintMnu.Hint := 'Fly Over hint is ON, click to turn OFF';
    ShowHintMnu.Caption := '&Hide FlyOver Hint';
  END
  ELSE
  BEGIN
    ShowHintMnu.Hint := 'Fly Over hint is OFF, click to turn ON';
    ShowHintMnu.Caption := '&Show FlyOver Hint';
  END;
end;

procedure TDateForm.HourEditClick(Sender: TObject);
begin
  HourEdit.Text := '0';
  MinEdit.Text := '0';
end;

procedure TDateForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  HintOn := Application.ShowHint;
  SaveInRegistry(HKEY_CURRENT_USER,ProgID+'\Settings','HintOn',HintOn);
  if WindowState=wsNormal then
   begin
    SaveInRegistry(HKEY_CURRENT_USER,ProgID+'\Settings','Top',Top);
    SaveInRegistry(HKEY_CURRENT_USER,ProgID+'\Settings','Left',Left);
    SaveInRegistry(HKEY_CURRENT_USER,ProgID+'\Settings','Width',Width);
    SaveInRegistry(HKEY_CURRENT_USER,ProgID+'\Settings','Height',Height);
   end;
end;

procedure TDateForm.WindowDefaultClick(Sender: TObject);
begin
  DateForm.WindowState := wsNormal;
  width := 604;
  height := 427;
  dateform.position := poScreenCenter;
end;

procedure TDateForm.FormActivate(Sender: TObject);
begin
  TimeDisplayEdit.Text := FormatDateTime('   hh' + ':' +
         'nn am/pm ', Now);
  SetDisplayToNow;
end;

procedure TDateForm.Shortcut1Click(Sender: TObject);
begin
  ScutFrm.ShowModal;
end;

end.

