unit PDateF;
 {provides date selection using a drop-down calendar}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Grids, ExtCtrls, Buttons;

type
  TDatePicFrm = class(TForm)
    DateTimePicker1: TDateTimePicker;
    Label1: TLabel;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    InsertDateBitBtn: TBitBtn;
    procedure InsertButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DatePicFrm: TDatePicFrm;

implementation

uses DateSetMain;

{$R *.DFM}

procedure TDatePicFrm.InsertButtonClick(Sender: TObject);
Var
   DatePicked : Tdatetime;
begin
   DatePicked  := DateTimePicker1.Date;
   StampDate := Trunc(DatePicked);
   DateForm.DateEdit.Text :=  ' ' + FormatDateTime('dd mmm yyyy', DatePicked);
   Close;

 (* REFERENCE INFORMATION on FORMATDATETIME

uses: Unit  SysUtils

Declaration

function FormatDateTime(const Format: string; DateTime: TDateTime): string;

Description

FormatDateTime formats the date-and-time value given by DateTime using the format given
by Format. The following format specifiers are supported:

Specifier	Displays

c	Displays the date using the format given by the ShortDateFormat global variable, followed by the time using the format given by the LongTimeFormat global variable. The time is not displayed if the fractional part of the DateTime value is zero.
d	Displays the day as a number without a leading zero (1-31).
dd	Displays the day as a number with a leading zero (01-31).
ddd	Displays the day as an abbreviation (Sun-Sat) using the strings given by the ShortDayNames global variable.

dddd	Displays the day as a full name (Sunday-Saturday) using the strings given by the LongDayNames global variable.
ddddd	Displays the date using the format given by the ShortDateFormat global variable.
dddddd	Displays the date using the format given by the LongDateFormat global variable.
m	Displays the month as a number without a leading zero (1-12). If the m specifier immediately follows an h or hh specifier, the minute rather than the month is displayed.
mm	Displays the month as a number with a leading zero (01-12). If the mm specifier immediately follows an h or hh specifier, the minute rather than the month is displayed.

mmm	Displays the month as an abbreviation (Jan-Dec) using the strings given by the ShortMonthNames global variable.
mmmm	Displays the month as a full name (January-December) using the strings given by the LongMonthNames global variable.
yy	Displays the year as a two-digit number (00-99).
yyyy	Displays the year as a four-digit number (0000-9999).
h	Displays the hour without a leading zero (0-23).
hh	Displays the hour with a leading zero (00-23).
n	Displays the minute without a leading zero (0-59).

nn	Displays the minute with a leading zero (00-59).
s	Displays the second without a leading zero (0-59).
ss	Displays the second with a leading zero (00-59).
t	Displays the time using the format given by the ShortTimeFormat global variable.
tt	Displays the time using the format given by the LongTimeFormat global variable.
am/pm	Uses the 12-hour clock for the preceding h or hh specifier, and displays 'am' for any hour before noon, and 'pm' for any hour after noon. The am/pm specifier can use lower, upper, or mixed case, and the result is displayed accordingly.

a/p	Uses the 12-hour clock for the preceding h or hh specifier, and displays 'a' for any hour before noon, and 'p' for any hour after noon. The a/p specifier can use lower, upper, or mixed case, and the result is displayed accordingly.
ampm	Uses the 12-hour clock for the preceding h or hh specifier, and displays the contents of the TimeAMString global variable for any hour before noon, and the contents of the TimePMString global variable for any hour after noon.
/	Displays the date separator character given by the DateSeparator global variable.

:	Displays the time separator character given by the TimeSeparator global variable.
'xx'/"xx"	Characters enclosed in single or double quotes are displayed as-is, and do not affect formatting.

Format specifiers may be written in upper case as well as in lower case letters--both
produce the same result.
If the string given by the Format parameter is empty, the date and time value is formatted
as if a 'c' format specifier had been given.*)

end;

procedure TDatePicFrm.FormActivate(Sender: TObject);
begin
   DateTimePicker1.Date := now;
   DateTimePicker1.Time := now;
end;


procedure TDatePicFrm.BitBtn1Click(Sender: TObject);
begin
  close;
end;

end.

