unit RegistrU;
 {unit to read and write to the win95 registry}

interface
{$IFNDEF Win32}
            STOP: This Source is not compatible with Delphi 1.0
{$ENDIF}
uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  StdCtrls, Registry;

procedure SaveInRegistry (_RootKey: HKEY;
                              _Localkey, _Field: String; V: Variant);
function  GetFromRegistry(_RootKey: HKEY;
                          _Localkey, _Field: String; V: Variant): Variant;

{procedure SetRegWindowState(Sender: TForm; _Localkey: String);

procedure GetRegWindowState(Sender: TForm; _Localkey: String); }

implementation

procedure SaveInRegistry (_RootKey: HKEY;
                              _Localkey, _Field: String; V: Variant);
var
  TR: TRegIniFile;
begin
  TR := TRegIniFile.Create('');
  case _RootKey of { default is  RootKey=HKEY_CURRENT_USER  }
    HKEY_CLASSES_ROOT,
    HKEY_CURRENT_USER,
    HKEY_LOCAL_MACHINE,
    HKEY_USERS,
    HKEY_PERFORMANCE_DATA,
    HKEY_CURRENT_CONFIG,
    HKEY_DYN_DATA : TR.RootKey := _RootKey;
  end;
  with TRegistry(TR) do
    begin
      OpenKey(_Localkey,true);
      case VarType(V) of
        varByte, varNull, varInteger,
        varSmallint: WriteInteger (_Field,V);
        varSingle,
        varDouble  : WriteFloat   (_Field,V);
        varCurrency: WriteCurrency(_Field,V);
        varDate    : WriteDateTime(_Field,V);
        varBoolean : WriteBool    (_Field,V);
        varString  : WriteString  (_Field,V);
      end; {case}
      CloseKey;
    end;
  TR.Free;
end;

function GetFromRegistry(_RootKey: HKEY;
                         _Localkey, _Field: String; V: Variant): Variant;
var
  TR: TRegIniFile;
begin
  Result := V;
  TR := TRegIniFile.Create('');
  case _RootKey of { default is  RootKey=HKEY_CURRENT_USER  }
    HKEY_CLASSES_ROOT,
    HKEY_CURRENT_USER,
    HKEY_LOCAL_MACHINE,
    HKEY_USERS,
    HKEY_PERFORMANCE_DATA,
    HKEY_CURRENT_CONFIG,
    HKEY_DYN_DATA : TR.RootKey := _RootKey;
  end;
  with TRegistry(TR) do
   begin
    if OpenKey(_Localkey,false) then
     begin
      if ValueExists(_Field) then
       case VarType(V) of
        varByte, varNull, varInteger,
        varSmallint: Result := ReadInteger (_Field);
        varSingle  : Result := ReadFloat   (_Field);
        varDouble  : Result := ReadFloat   (_Field);
        varCurrency: Result := ReadCurrency(_Field);
        varDate    : Result := ReadDateTime(_Field);
        varBoolean : Result := ReadBool    (_Field);
        varString  : Result := ReadString  (_Field);
       end; {case}
      CloseKey;
     end;
   end;
  TR.Free;
end;

end.
