unit ShCutF;
  {unit to create a desktop shortcut, requires modification of project source file}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, ExtCtrls;

type
  TScutFrm = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ScutFrm: TScutFrm;

implementation

{$R *.DFM}

uses
  ComObj, ActiveX, ShlObj;

procedure TScutFrm.Button1Click(Sender: TObject);
var
  AnObj: IUnknown;
  ShLink: IShellLink;
  PFile: IPersistFile;
  FileName: string;
  WFileName: WideString;
begin
  // access to the two interfaces of the object
  AnObj := CreateComObject (CLSID_ShellLink);
  ShLink := AnObj as IShellLink;
  PFile := AnObj as IPersistFile;
  // get the name of the application file
  FileName := ParamStr (0);
  // set the link properties
  ShLink.SetPath (PChar (FileName));
  ShLink.SetWorkingDirectory (PChar (
    ExtractFilePath (FileName)));
  // save the file, using a WideString!

  IF DirectoryExists ('c:\windows\desktop\') then
  Begin
     WFileName := 'c:\windows\desktop\' + Edit1.Text + '.lnk';
     PFile.Save (PWChar (WFileName), False);
     MessageDlg ('A shortcut to "Date-Time Stamp" has been created on your Desktop',
      mtInformation, [mbOK], 0)
  End
  else
  MessageDlg
  ('You do not have a standard windows setup, the directory c:\Windows\Desktop does not exist. You will have to create the shortcut manually.', mtInformation, [mbOK], 0);

  Close;
end;


procedure TScutFrm.Button2Click(Sender: TObject);
begin
  Close;
end;

end.
