#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>			/* for atoi */

#define TRUE	1
#define FALSE	0 

#define LINELEN 256
#define LITLEN  80
#define NARGS	13
#define TABINT	8			/* tab interval, in columns */

#define FIL 0				/* remember what type arg */
#define LIT 1				/* stored in parmtype */
#define TAB 2
#define STR 3

int ch,
    sflag = 0,				/* TRUE when "-s" flag specified */
    filesact = 0,			/* count of active files */
    filecnt = 0,			/* count of specified file names */
    actarg = 0,				/* actual argument-table index */
    saweof[NARGS],			/* TRUE when this file reaches EOF */
    parmtype[NARGS],			/* type of current argument */
    tabposn[NARGS],			/* TAB POSITION arguments here */
    startcol[NARGS];			/* START COLUMN arguments here */
char literals[NARGS][LITLEN];		/* LITERAL arguments here */
FILE *infiles[NARGS];			/* FILE argument handles here */

extern void exit();
void usage();				/* forward declaration */

main(argc, argv)
int argc;
char *argv[];
    {
    int argno, i, j, k;

    if (argc == 1)				/* informational prompt */
	usage();
/*
 * collect input line arguments, initialize
 */
    tabposn[0] = startcol[0] = 0;
    for (argno = 1; argno < argc; argno++) {
	saweof[argno] = TRUE;
	startcol[argno] = 0;
	tabposn[argno] = 0;
	switch (argv[argno][0]) {
	/*
	 * tab position - the next literal or input line will 
	 * be placed at this column in the output line.
	 */
        case '+':			
	    tabposn[actarg] = atoi(&argv[argno][1])-1;
	    parmtype[actarg++] = TAB;
	    break;			

	case '-':
	    switch (argv[argno][1]) {
	    case 's': case 'S':
		sflag = TRUE;
		break;

	    case 'l': case 'L':
		argno++;			/* NEXT arg is literal */
		if (argno >= argc) {
		    (void)fprintf(stderr, "hc: missing literal argument\n");
		    exit(4);
		    }
		if (strlen(argv[argno]) > LITLEN-1) {
		    (void)fprintf(stderr, "hc: literal %d too long\n", argno-1);
		    exit(3);
		    }
		/*
		 * copy string literal, interpreting backslash notation
		 */
		for (i = j = 0; (ch = argv[argno][j++]) != '\0';)
		    if (ch != '\\')
		        literals[actarg][i++] = ch;
		    else
			switch (argv[argno][j++]) {
			case 'n':			/* newline */
			    literals[actarg][i++] = '\n'; break;
			case 't':			/* horizontal tab */
			    literals[actarg][i++] = '\t'; break;
			case 'v':			/* vertical tab */
			    literals[actarg][i++] = '\v'; break;
			case 'b':			/* backspace */
			    literals[actarg][i++] = '\b'; break;
			case 'r':			/* carriage return */
			    literals[actarg][i++] = '\r'; break;
			case 'f':			/* form feed */
			    literals[actarg][i++] = '\f'; break;
			case '\\':			/* actual backslash */
			    literals[actarg][i++] = '\\'; break;
			case '\'':			/* single quote */
			    literals[actarg][i++] = '\''; break;
			case '\"':			/* double quote */
			    literals[actarg][i++] = '\"'; break;
			case '\0':			/* '\' at end  */
			    literals[actarg][i++] = '\\'; 
			    --j;			/* let FOR see null */
			    break;
			default:			/* not recognized */
			    literals[actarg][i++] = '\\';
			    literals[actarg][i++] = ch;
			    break;
			} /* switch */
		    literals[actarg][i] = '\0';
		    parmtype[actarg++] = LIT;
		    break;

		case '0': case '1': case '2': case '3':
		case '4': case '5': case '6': case '7':
		case '8': case '9':		/* col number */
		    startcol[actarg] = atoi(&argv[argno][1])-1;
		    parmtype[actarg++] = STR;
		    break;

		case '\0':			/* lone '-' is ref to stdin */
		    filesact++;
		    filecnt++;
		    infiles[actarg] = stdin;
		    saweof[actarg] = FALSE;
		    parmtype[actarg++] = FIL;
		    break;
		    
		default:
		    (void)fprintf(stderr, "hc: unrecognized option=%s\n",
				    argv[argno]);
		    usage();
	        } /* inner switch */
		break;

	    default:			/* open the file */
		if (argno > NARGS) {
		    (void)fprintf(stderr, "hc: too many file names\n");
		    continue;
		    }
		if ((infiles[actarg] = fopen(argv[argno], "r")) != NULL) {
		    saweof[actarg] = FALSE;
		    filesact++;
		    filecnt++;
		    }
		else {
		    (void)fprintf(stderr, "hc: can't access %s\n", argv[actarg]);
		    exit(2);
		    }
		actarg++;
		break;
	    } /* outer switch */
	} /* for */
/* 
 * process input lines, generate output
 */

   do {
	char bufin[NARGS][LINELEN],	/* input file line buffers here */
	     intmp[LINELEN],		/* buffer for tab expansion */
	     bufout[LINELEN];		/* output buffer */

 	bufout[0] = '\0';			/* ready for output */
	for (argno = 0; argno < actarg; argno++) {
	    switch (parmtype[argno]) {
		case TAB:			/* pad/truncate bufout */
		    if ((j = tabposn[argno]-strlen(bufout)) < 0)
			bufout[tabposn[argno]] = '\0';
		    else 
			for (; j > 0; j--)
			    strcat(bufout, " ");			
		    break;

		case LIT:			/* output the literal */
		    for (j = strlen(bufout), k = startcol[argno-1];
			(bufout[j++] = literals[argno][k++]) != 0;);
		    bufout[j] = '\0';
		    break;	 	

		case FIL:			/* get next line into intmp */
    		    if (saweof[argno] == TRUE)
			intmp[0] = '\0';
		    else if (fgets(intmp, LINELEN, infiles[argno]) != NULL)
			if (intmp[strlen(intmp)-1] == '\n')
			    intmp[strlen(intmp)-1] = '\0';
			else {
			    (void)fprintf(stderr, "hc: input line length > ");
			    (void)fprintf(stderr, "%d chars, truncated.\n",
				    LINELEN);
			    exit(2);
			    }
		    else {
			intmp[0] = '\0';
			filesact--;
			saweof[argno] = TRUE;
			}
		    /*
		     * expand TABs from intmp into spaces in bufin
		     */			
		    for (i = 0, j = 0; (ch = intmp[j++]) != '\0';)
			if (ch == '\t')
			    for (k = TABINT - (i % TABINT); k-- > 0;)
				bufin[argno][i++] = ' ';
			else
			    bufin[argno][i++] = ch;
		    bufin[argno][i] = '\0';
		/*
		 * move bufin into bufout, if it's not null string
		 */
		    if (bufin[argno][0] != '\0') {
			for (j = strlen(bufout), k = startcol[argno-1];
			    (bufout[j++] = bufin[argno][k++]) != 0;);
			bufout[j] = '\0';
			}
		    break;
		} /* switch */
	    } /* for */

	/*
	 * compress tabs in bufout
	 */
	if (!sflag) {
	    int sp;

	    strcpy(intmp, bufout);
	    for (i = 0, j = 0, sp = 0; (ch = intmp[j++]) != '\0';) {
		if (ch == ' ') {
		    sp++;
		    if ((sp > 1) && ((j % TABINT) == 0)) {
			bufout[i++] = '\t';
			sp = 0;
			}
		    }
		else {
		    while (sp > 0) {
		        bufout[i++] = ' ';
			sp--;
		        }
		    bufout[i++] = ch;
		    }
		}
	    bufout[i] = '\0';
	    }

	/*
	 * remove trailing blanks
	 */
	if (tabposn[actarg-1] == 0) {
	    j = strlen(bufout);
	    while (bufout[--j] == ' ')
		;
	    bufout[j+1] = '\0';
	    }
/*
 * if there were input files specified, and all files have reached EOF,
 * don't bother to output this line.
 */
	if ((filecnt != 0) && (filesact != 0)) {
	    fputs(bufout, stdout);
	    fputc('\n', stdout);
	    }
	} while (filesact > 0);
     exit(0);				/* successful return */
     } /* hc routine */


void usage() {
    (void)fprintf(stderr, "usage:");
    (void)fprintf(stderr, "  hc [-s] [+tab | -col | -l \"str\" | filename] ...\n");
    exit(2);
    }
