
 SYNOPSIS
      hc [-s] [+tab | -col | -l str | filename] ...

 DESCRIPTION

      hc  concatenates files horizontally.   It concatenates correspon-
      ding lines from files.   The effects of hc are best visualized by 
      imagining  the files to be printed on long strips of  paper  with 
      Velcro  strips  on the left and right margins;   hc sticks  these 
      files together to make one wide file on the standard output.

      Besides file names,  the command line can contain tab  positions, 
      column numbers, and literal strings.  A maximum of thirteen files 
      can be specified.

      a  TAB  POSITION  is denoted by a positive  decimal  number.   It 
      specifies  that  the next item should be placed at  a  particular 
      column.   The  first column number is one.   For example,  a  tab 
      position of five would cause the next item to be placed at column 
      5 in the output.   If the last argument is a tab  position,  then 
      each  line of output will contain enough trailing spaces to bring 
      it to that column.

      a START POSITION is denoted by a negative decimal.  It  specifies 
      the  left margin of the next file to be concatenated.   The first 
      column is number one, and normally the left margin number is one.  
      For  a start column number greater than one,  the  first  (col-1) 
      characters of each line of the next file are discarded.

      a LITERAL STRING is preceded by a '-l' flag. It may be surrounded
      by double quotes (under DOS, at least).  It specifies  characters
      to  be  inserted in every output line at its relative position in
      the argument list.   In an extension to  the  Knowlogy  HC,  this
      version interprets the standard C backslashed escape codes.   The
      following  command  interleaves lines from the two files, separa-
      ting them by a '\n' or newline:
              hc file1 -l "\n" file2

      Of necessity, all tabs are expanded to spaces upon input, so that 
      columns can be determined.  On output, spaces are compressed back 
      to  tabs,  and,  unless a TAB POSITION argument follows the  last 
      file name, trailing spaces are removed from each line.

      All  files but the longest are conceptually padded at the  bottom 
      with  zero-length  lines to bring all files to bring to the  same 
      length.   That is, concatenation continues until the end of every 
      file is encountered.   However,  if there are one or more literal 
      strings in the argument list, at least one line of output will be 
      written even if all files are empty or no files are specified.

      The -s flag prevents the output from including any tabs; that is, 
      the normal tab compression of the output line is suppressed.

 EXAMPLES

      Assume the files A, B, and C, whose contents are as follows:

      00000000011111111112
      12345678901234567890
      -- this is file A --
      Little Miss Muffet
      Sat on her tuffet,
      Eating her curds
        and whey.
      Along came a spider
      Who sat down
        beside her,
      And frightened
        Miss Muffet away.

      000000000111111111122222222223
      123456789012345678901234567890
           -- this is file B --
      Four score and seven years
      ago, our fathers brought forth
      upon this continent a new
      nation, conceived in liberty,
      and dedicated to the
      proposition that all men are
      created equal.

      0000000001
      1234567890
      - file C -
      gimme a U
      gimme an N
      gimme an I
      gimme a C
      gimme an A
      whazzat
        spell?
      whazzat
        spell?
      arright!
      
 Example: hc A B C            simply concatenate the files, making
                              no attempt to justify any margins.

      000000000111111111120000000001111111111222222222230000000001
      123456789012345678901234567890123456789012345678901234567890
      -- this is file A --     -- this is file B --- file C -
      Little Miss MuffetFour score and seven yearsgimme a U
      Sat on her tuffet,ago, our fathers brought forthgimme an N
      Eating her curdsupon this continent a newgimme an I
        and whey.nation, conceived in liberty,gimme a C
      Along came a spiderand dedicated to thegimme an A
      Who sat downproposition that all men arewhazzat
        beside her,created equal.  spell?
      And frightenedwhazzat
        Miss Muffet away.  spell?
      arright!
      
 Example: hc A +21 B +51 C    This concatenates the three files,
                              with file A starting at column 1,
                              file B starting at column 21, and
                              file C starting at column 51.

      000000000111111111120000000001111111111222222222230000000001
      123456789012345678901234567890123456789012345678901234567890
      -- this is file A --     -- this is file B --     - file C -
      Little Miss Muffet  Four score and seven years    gimme a U
      Sat on her tuffet,  ago, our fathers brought forthgimme an N
      Eating her curds    upon this continent a new     gimme an I
        and whey.         nation, conceived in liberty, gimme a C
      Along came a spider and dedicated to the          gimme an A
      Who sat down        proposition that all men are  whazzat
        beside her,       created equal.                  spell?
      And frightened                                    whazzat
        Miss Muffet away.                                 spell?
                                                        arright!

 Example: hc B +40 A          Concatenate files B, starting at column 1,
                              and A, starting at column 40.  The two files
                              are displayed side by side for comparison
                              viewing.

      000000000111111111122222222223         00000000011111111112
      123456789012345678901234567890         12345678901234567890
           -- this is file B --              -- this is file A --
      Four score and seven years             Little Miss Muffet
      ago, our fathers brought forth         Sat on her tuffet,
      upon this continent a new              Eating her curds
      nation, conceived in liberty,            and whey.
      and dedicated to the                   Along came a spider
      proposition that all men are           Who sat down
      created equal.                           beside her,
                                             And frightened
                                               Miss Muffet away.


 Example: hc -5 B +17         Chop the first 4 and last 5 columns off
                              of file B.
      0000011111111112
      5678901234567890
       -- this is file
       score and seven
       our fathers bro
       this continent 
      on, conceived in
      dedicated to the
      osition that all
      ted equal.      


 Example: hc -s -5 A +10 +15 -5 C +50 Concatenate file A (starting with
                                      its fifth column), and cut it off
      000001111     000001            when it reaches column 9 (just be-
      567890123     567890            fore column 10);  then add file B
      his is fi     le C -            (startint with its fifth column)
      le Miss M     e a U             beginning at column 15;  then pad
      on her tu     e an N            out with spaces through column 49
      ng her cu     e an I            (just before column 50).  Don't
      d whey.       e a C             compress spaces to tabs.
      g came a      e an A                             
      sat down      zat                                
      side her,     ell?                               
      frightene     zat                                
      ss Muffet     ell?                               
                    ght!                               
                                                       

 Example: hc A "-----" B      Concatenate files A and B, with
                              five dashes between them.

      00000000011111111112-----000000000111111111122222222223
      12345678901234567890-----123456789012345678901234567890
      -- this is file A -------     -- this is file B --
      Little Miss Muffet-----Four score and seven years
      Sat on her tuffet,-----ago, our fathers brought forth
      Eating her curds-----upon this continent a new
        and whey.-----nation, conceived in liberty,
      Along came a spider-----and dedicated to the
      Who sat down-----proposition that all men are
        beside her,-----created equal.
      And frightened-----
        Miss Muffet away.-----


 Example: hc "| " A +24 "|| " C +38 "|"       
                                      Concatenate files A and C,
                                      with vertical walls sur-
                                      rounding them.

      | 00000000011111111112 || 0000000001 |
      | 12345678901234567890 || 1234567890 |
      | -- this is file A -- || - file C - |
      | Little Miss Muffet   || gimme a U  |
      | Sat on her tuffet,   || gimme an N |
      | Eating her curds     || gimme an I |
      |   and whey.          || gimme a C  |
      | Along came a spider  || gimme an A |
      | Who sat down         || whazzat    |
      |   beside her,        ||   spell?   |
      | And frightened       || whazzat    |
      |   Miss Muffet away.  ||   spell?   |
      |                      || arright!   |


 Example: ls ? | hc -s "sp " - " | pr" > tmp

      sp A  | pr                      This example builds a shell
      sp B  | pr                      script to be run.  The script
      sp C  | pr                      will run the spelling checker
      sp D  | pr                      on each file and print its
                                      output.

 Example: hc -s input > tmp           Expand tabs to spaces while
                                      copying input to tmp.

 Example: ... | hc - > tmp            Compact spaces to tabs while
                                      copying stdin to tmp.

 From the Unica hc utility published by Knowlogy, Inc. in 1982, for
 use under CP/M.  As far as I know, Knowlogy no longer exists.  The
 above documentation is quoted nearly verbatim from the Unica manual.
 My thanks to Knowlogy's people for a most useful design.

 Comments and bugs to:
 Bill Cox     (714)631-4452 (voice)
