;************************************************************************
;*                                                                      *
;*      HTYPE (C) 1997 RonSoft.                                         * 
;*                                                                      *
;*      A simple utility that writes out files in hex and ascii.        *
;*                                                                      *
;*      Usage:                                                          *
;*      Htype [path] <filename>.                                        *
;*                                                                      *
;*      Comments, suggestions ?                                         *
;*                                                                      *
;*      Ronald Nordberg.                                                *
;*      Silvervgen 3                                                   *
;*      907 50 Ume                                                     *
;*      Sweden                                                          *
;*      christine.martinson@swipnet.se                                  *
;*      http://home2.swipnet.se/~w-20064                                *
;*                                                                      *
;*      ALL PUBLIC DOMAIN FREEWARE.                                     *
;*      Give me credits if You use the code.                            *
;*                                                                      *
;************************************************************************

                                        ;some euqates for readability
kbd             equ     16h             ;keyboard irq
msdos           equ     21h             ;MSDOS irq

reset           equ     0dh             ;disk reset
dfopen          equ     0fh             ;open disk file
dfclose         equ     10h             ;close disk file
searchf         equ     11h             ;search first
searchn         equ     12h             ;search next
seqread         equ     14h             ;sequential disk read
seqwrite        equ     15h             ;     "       "  write
setdta          equ     1ah             ;set disk transfer area address
createf         equ     3ch             ;create file with handle
openf           equ     3dh             ;open file with handle
closef          equ     3eh             ;close file with handle
readf           equ     3fh             ;read from file with handle
writef          equ     40h             ;write to file with handle
setfp           equ     42h             ;set file pointer
allocmem        equ     48h             ;allocate memory
freemem         equ     49h             ;free memory
changebs        equ     4ah             ;change block size
findfirst       equ     4eh             ;find first file
exit            equ     4c00h           ;msdos exit

[BITS 16]                               ;NASM stuff
[ORG 100h]
[SEGMENT .text]

        mov     ax,cs                   ;get code segment
        mov     ds,ax                   ;use it now
                
        mov     si,0080h                ;DOS command line page 0
        lodsb                           ;load size of command line
        cmp     al,1                    ;anything on command line ?
        jbe     usage                   ;noo, show usage
        cbw                             ;extend AL to AX
        xchg    bx,ax                   ;swap size to bx for indexing
        mov     byte [bx+si],0          ;null terminate command line
        call    parse                   ;parse command line
        jmp     main                    ;go on with main
usage:  mov     bx,utext                ;pointer usage text
        call    write                   ;write it out
        jmp     nomem                   ;skip this        
main:        
        mov    bx,progend             ;program end address
        mov    ax,es                    ;segment of the program beginning
        sub    bx,ax                    ;memory size needed for ourselves
        shr    bx,4                     ;make it paragraphs
        mov    ah,changebs              ;modify memory block
        int    msdos                    ;free memory
        jnc    resok
        mov    bx,errt0                 ;error
        jmp    errout
resok:
        mov     ah,setdta               ;set our DTA-area
        mov     dx,mydta                ;our DTA-structure
        int     msdos
        
        mov     ah,findfirst            ;see if the file out there
        mov     cx,0fh                  ;all files
        mov     dx,inbuff               ;our NULL terminated filname
        int     msdos                   ;do the stuff
        jnc     found                   ;it was there
        mov     bx,errt1                ;error, let them know
        call    write
        mov     bx,inbuff               ;wich file 
        call    write
        mov     bx,errt2                ;we couldn't find
        jmp     errout                  
found:
        mov     ebx,[mydta+26]          ;get filesize
        mov     [filesize],ebx          ;save it
        mov     [bcount],ebx            ;and there

        mov     ah,openf                ;open file
        mov     al,00h                  ;READ ONLY
        mov     dx,inbuff               ;filename
        int     msdos                   ;do the request
                                        ;*** no checking, its there !
        mov     [filehandle],ax         ;save file handle
        mov     dword [count],0         ;our fake address
readlop:
        mov     cx,20                   ;do 20 rows each time
readloop:
        push    cx                      ;save loop count
        mov     ah,readf
        mov     bx,[filehandle]         ;filehandle
        cmp     dword [bcount],16       ;>=16 bytes left ?
        jge     aword                   ;yeahh
        mov     cx,[bcount]             ;no, get whats left
        jmp     noword
aword:  mov     cx,16                   ;read the bytes
noword: mov     dx,inline               ;file read buffer
        int     msdos                   ;do the read
        mov     si,inline               ;get source buffer
doline:
        call    binhex                  ;the "address" stuff
        mov     bx,numbuff              ;convert to hex ascii
        call    write                   ;write it out
        call    binhexb                 ;convert a line
        mov     bx,outline              ;get output buffer
        call    write                   ;write it out
        
goon1:  add     dword [count],10h       ;increase "address"
        add     si,16                   ;incrase source offset
        cmp     dword [bcount],0        ;end of line ?
        jle     quit                    ;yeahh
        pop     cx                      ;no, restore loop count
        loop    readloop                ;next line

        pusha                           ;save it all
        mov     bx,text
        call    write
        mov     ah,0                    ;wanna see next screen  ?
        int     kbd                     ;chek out keyboard buffer
        and     al,0DFh                 ;force UPPER CASE
        cmp     al,"Q"                  ;next page ?
        jne     noquit                  ;nooo
        popa                            ;restore
        jmp     quit                    ;quit
noquit: popa                            ;restore
        cmp     dword [bcount],0        ;end of file ?
        jg      readlop                 ;nooo
        jmp     quit                    ;yes

errout: call    write                   ;show errormessage
quit:
        cmp     word [filehandle],0     ;any filehandle
        je      nomem                   ;noo
        mov     bx,[filehandle]         ;yeahh, get it
        mov     ah,closef               ;function
        int     msdos                   ;close file
nomem:  xor     eax,eax                 ;clean out that
        mov     ax,exit                 ;MS-DOS successful exit
        int     msdos                   ;back to the operating system

;************************************************************************
;       Fill outline with byte values and ascii chars.                  *
;************************************************************************
binhexb:
        pusha                           ;save the regs
        mov     di,outline              ;get output buffer
        mov     cx,80                   ;fill it with
        mov     al,32                   ;blankspaces
        repe    stosb
        mov     di,outline              ;get the start
        mov     word [acount],0         ;asc output counter
        mov     cx,16                   ;do 16 bytes
bloop:  push    cx                      ;save count
        sub     dword [bcount],1        ;decrease filesize count
        cmp     dword [bcount],0        ;end of file ?
        jge     noend                   ;noo
        pop     cx                      ;yeahh, restore
        jmp     fout                    ;skip
noend:  add     word [acount],1         ;increase ascii chars count
        lodsb
        mov     dl,al                   ;get value
        mov     cx,2                    ;2 nibbles
convhexb:
        push    cx                      ;save that
        mov     cl, 4                   ;4 bits
        rol     dl, cl                  ;rotate source left
        mov     al, dl                  ;move digit into AL
        and     al, 15                  ;clear high nibble
        daa                             ;adjust AL if A through F
        add     al, 240                 ;bump the carry
        adc     al, 40h                 ;convert HEX to ASCII
        stosb                           ;copy to buffer
        pop     cx                      ;get digit counter
        loop    convhexb                ;next digit
        mov     al,32                   ;copy a SPACE
        stosb
        pop     cx                      ;restore loop counter
        loop    bloop                   ;loop on

fout:   mov     di,outline              ;output buffer
        add     di,50                   ;offset ASCII stuff
        sub     si,[acount]             ;adjust source back
        mov     cx,[acount]             ;counter
cpasc:  lodsb                           ;load AL
        cmp     al,32                   ;al > SPACE ?
        jge      nozero                 ;yeahh, copy it
fill:   mov     al,'.'                  ;noo, copy a .
nozero: stosb                           ;store
        loop    cpasc                   ;go on
        mov     al,13                   ;copy the carriage
        stosb
        mov     al,10                   ;copy linefeed
        stosb
        mov     al,0                    ;and null terminate
        stosb
        popa
        ret                             ;done

;************************************************************************
;*      Convert bin DWORD to HEX ascii. Input EDX. Result in Numbuff    *
;************************************************************************
binhex: pusha       
        mov     di,numbuff              ;destination buffer
        mov     edx,[count]             ;binary number
        mov     cx,8                    ;eight nibbles
convhex:
        push    cx                      ;save counter
        mov     cl, 4                   ;4 bits
        rol     edx, cl                 ;rotate source left
        mov     al, dl                  ;move digit into AL
        and     al, 15                  ;clear high nibble
        daa                             ;adjust AL if A through F
        add     al, 240                 ;bump the carry
        adc     al, 40h                 ;convert HEX to ASCII
        stosb                           ;copy to buffer
        pop     cx                      ;get digit counter
        loop    convhex                 ;next digit
        mov     al,32                   ;copy a space
        stosb
        mov     al,0                    ;null terminate
        stosb
        popa
        ret

;*************************************************************************
;*       Writes out the NULL terminated text supplied in BX.             *
;*       OR writes out data,BX and size,CX if called at lwrite.          *
;*************************************************************************
write:  pusha
        mov     si,bx                   ;copy to SI
        mov     cx,0                    ;clear count
wloop:  lodsb                           ;load AL with SI
        cmp     al,0                    ;end of line ?
        je      lwrite                   ;yeahh
        inc     cx                      ;no, incrase byte count
        jmp     wloop                   ;test next byte
lwrite: mov     dx,bx                   ;text address in DX
        mov     bx,1                    ;filehandle standard output = 1
        mov     ah,writef               ;MS-DOS writefile with handle is 040
        int     msdos                   ;write buffer to standard output
        popa
        ret                             ;done

;*************************************************************************
;*      My kind of command line parsing. It just checks if there's      
;*      any blankspaces between the options. The parameters ends up                               
;*      in the inbuff separated by 0:s, binary zeroes.                  
;*************************************************************************
parse:  
        mov     di,inbuff               ;our buffer
dospc:  cmp     byte [si],32            ;any leading spaces ?
        jne     nospc
        inc     si                      ;dump that
        jmp     dospc
nospc:  mov     cx,1                    ;were here, so we got one arg
copy1:  lodsb                           ;load byte SI to AL
        cmp     al,0                    ;0 ?(end of line)
        je      done                    ;yeahh
        cmp     al,32                   ;SPACE ?
        je      cop2                    ;yeah
        stosb                           ;noo, move AL to DI, incrase DI
        jmp     copy1                   ;go on
cop2:   mov     byte [di],0                 ;null terminate
        add     cx,1
        inc     di                      ;dump that byte(SPACE)
        jmp     copy1                   ;back
done:   mov     byte [di],0                 ;null terminate
        ret                             ;return

;*************************** DATA STUFF **********************************

filesize        dd 0
bcount          dd 0
count           dd 0
inbuff          times 64 dw 0           ;128 byte command line buffer
mydta           times 32 dw 0           ;use 64 bytes as DTA
inline          times 8 dw 0            ;buffer file read input
outline         times 40 dw 0           ;buffer output line
numbuff         times 5 dw 0            ;word ascii number buffer
filehandle      dw 0                    ;misc storage 
foffset         dw 0
memsize         dw 0
address         dw 0
psize           dw 0
;count           dw 0
acount          dw 0

utext:
                db      "HType. (C) 1997 RonSoft",13,10
                db      "Usage: Htype [path] <filname>.",13,10
text:           db      "Any key = next screen. Q = quit.",13,10,0
errt0:          db      "Memory resize error.",13,10,0
errt1:          db      "File ",0
errt2:          db      " not found !",13,10,0

progend:
        END
