unit KDSK;{string key against copy for floppy Copyright (C) BTI}
 Unit description:

 abbreviations:
 ------------
 DSK = floppy
 DD  = hard drive
 err_I/O = read or write error on drive

 types & constants:
 ------------------
 dimkey=20;{key length (in characters)}
 type strkey=string[dimkey];{key value (string)}

 integer  : 2 octets signed [-32768,32767]
 longint  : 4 octets signed [-2147483648,2147473647]
 byte     : 1 octet unsigned [0,255]
 word     : 2 octets unsigned [0,65535]
 char     : 1 octet [#0,#255] (a character)
 pchar    : 4 octets (pointer on string A Zero Terminal)
 string   : 1 octet in start (contains string length) + 1 by char.
            (string limited from 0 to 255 characters)

 Parameters are passed by value (variables are backup) except if they are
 preceded by the word 'var' (passed by variable: it's the address of the
 parameter that is transmitted).

 If you use the String Pascal convention (fct dll2xxx), always pass
 the string by value (ignore the word 'var'). In this convention, it's
 always the string parameter address that is passed.

 variables:
 ---------
 nkey = application ID [1,65535]
 chem = DOS path to use (floppy or hard drive)
 ChemDSK = floppy unit
 ChemDD  = hard drive directory
 clef    = string key
 err     = error code
 pass    = ncustomer+password to access the DLL

 functions (all):
 ----------------
procedure about;{KD version number}

 functions (units only):
 ----------------------
function keyreset(chemDSK:string):byte;{reset chemDSK->0ifOK}
function keycopie(chemDSK,chemDD:string;nkey:word):byte;{copy key DSK to DD->0ifOK}
function keyread(chem:string;var clef:strkey;nkey:word):byte;{->0ifOK}
function keywrit(chem:string;clef:strkey;nkey:word):byte;{->0ifOK}
function keydeinst(chemDD:string;nkey:word):byte;{uninstall chemDD->0ifOK}

 functions (dll convention Pchar Windows):
 ----------------------------------------
function dllkeyreset(pass,chemDSK:pchar):byte;{reset chemDSK->0ifOK}
function dllkeycopie(pass,chemDSK,chemDD:pchar;nkey:word):byte;{copy key DSK to DD->0ifOK}
function dllkeyread(pass,chem:pchar;var clef:pchar;nkey:word):byte;{->0ifOK}
function dllkeywrit(pass,chem,clef:pchar;nkey:word):byte;{->0ifOK}
function dllkeydeinst(pass,chemDD:pchar;nkey:word):byte;{uninstall chemDD->0ifOK}

 functions (dll convention String Pascal): for VB3
 ----------------------------------------
function dll2keyreset(pass,chemDSK:string):integer;{reset chem(DSK)->0ifOK}
function dll2keycopie(pass,chemDSK,chemDD:string;nkey:word):integer;{copy key DSK to DD->0ifOK}
function dll2keyread(pass,chem:string;var clef:string;nkey:word):integer;{->0ifOK}
function dll2keywrit(pass,chem,clef:string;nkey:word):integer;{->0ifOK}
function dll2keydeinst(pass,chemDD:string;nkey:word):integer;{uninstall chem(DD)->0ifOK}

 error codes & explanations:
 -------------------------------
function keyreset(chemDSK:string):byte;{reset chemDSK->0ifOK}
{*err:DSK: 0=ok, 1=err_I/O, 2=path_not_exist, 3=DD not support*}
{note: to use only if you get problems with I/O DSK}

function keycopie(chemDSK,chemDD:string;nkey:word):byte;{copy key DSK to DD ->0ifOK}
{copy floppy key (chemDSK) to an hard drive directory (chemDD)}
{note: nkey: key number for chem (<=65535 key/dir)}
{*err:
      DSK: 3=only with KDD unit
      DD:
      0=ok, 1=err_I/O, 2=path_not_exist, 3=bad DSK or DD RAM or Remote,
      4=no_key (material incompatible), 7=already_install, 9=act_of_piraty
*}

function keyread(chem:string;var clef:strkey;nkey:word):byte;{->0ifOK}
{note: nkey: key number for chem (<=65535 key/dir)}
	{*err:DD/DSK: 0=ok, 1=err_I/O, 3=bad DSK or DD RAM
      DD only: 2=path_not_exist, 4=no_key, 9=act_of_piracy
*}

function keywrit(chem:string;clef:strkey;nkey:word):byte;{->0ifOK}
{note: nkey: key number for chem (<=65535 key/dir)}
{*err:DD/DSK: 0=ok, 1=err_I/O, 3=bad DSK or DD RAM
      DD only: 2=path_not_exist, 4=no_key (incompatible), 9=act_of_piracy
*}

function keydeinst(chemDD:string;nkey:word):byte;{uninstall chemDD->0ifOK}
{note: nkey: key number for chem (<=65535 key/dir)}
{*err:DSK: 3=only with KDD unit
      DD:  0=ok, 2=path_not_exist, 3=bad DSK or DD RAM
*}

{*fin*}
end.



