unit KP;{date-counter key against copy Copyright (C) BTI}
 Unit description:

 abbreviations:
 ------------
 DSK = floppy
 DD  = hard drive
 err_I/O = read or write error on drive

 types & constants:
 ------------------
 integer  : 2 octets signed [-32768,32767]
 longint  : 4 octets signed [-2147483648,2147473647]
 byte     : 1 octet unsigned [0,255]
 word     : 2 octets unsigned [0,65535]
 char     : 1 octet [#0,#255] (a character)
 pchar    : 4 octets (pointer on string A Zero Terminal)
 string   : 1 octet in start (contains string length) + 1 by char.
            (string limited from 0 to 255 characters)

 Parameters are passed by value (variables are backup) except if they are
 preceded by the word 'var' (passed by variable: it's the address of the
 parameter that is transmitted).

 If you use the String Pascal convention (fct dll2xxx), always pass
 the string by value (ignore the word 'var'). In this convention, it's
 always the string parameter address that is passed.

 variables:
 ---------
 nkey = application ID [1,65535]
 chem = DOS path to use (floppy or hard drive)
 ChemDSK = floppy unit
 ChemDD  = hard drive directory
 err     = error code
 pw    = password for update (or '')
 datel = limit date (jj/mm/aaaa)
 nbuse = use counter
 poste = station number (ex: getenv(IDPOSTE) in BP) (if networks)
 nbusersl = simultaneous networks users number (if networks)
 desinst  = true for an uninstallation (false for an installation)
 pass     = ncustomer+password to access the DLL

 functions (all):
 ----------------
procedure about;{KD version number}

 functions (units only):
 ----------------------
function keyreset(chemDSK:string):byte;{reset chemDSK->0ifOK}
function keyPtest(poste:string4;chem:string;nkey:word;pw:string;
  var datel:string10; var nbuse:longint; var nbusersl:word;
  var message:string):byte;{test DD/DSK & increase network cpt->err=0ifOK}
function KeyPexit(poste:string4;chem:string;nkey:word):byte;{decrease networks cpt->err=0ifOK}
function KeyPreset(chem:string;nkey:word):byte;{reset network cpt->err=0ifOK}
function keyPinstal(poste:string4;desinst:boolean;chemDSK,chemDD:string;
  nkey:word;var message:string):byte;{->0ifOK}
function keyPdeinst(poste:string4;chem:string;nkey:word;var message:string):byte;{destroy key DD->0ifOK}
function keyPmajPcode(poste:string4;chem:string;nkey:word;
  var pcCompt,pcDate:string):byte;{update pre-code->0ifOK}

 functions (dll convention Pchar Windows):
 ----------------------------------------
function dllkeyreset(pass,chemDSK:pchar;nkey:word):byte;{reset chem(DSK)->0ifOK}
function dllkeyPtest(pass,poste,chem:pchar;nkey:word;pw:pchar;var datel:pchar;
  var nbuse:longint; var nbusersl:word; var message:pchar):byte;
  {test DD/DSK & increase network cpt->err=0ifOK}
function dllKeyPexit(pass,poste,chem:pchar;nkey:word):byte;{decrease cpt network->err=0ifOK}
function dllKeyPreset(pass,chem:pchar;nkey:word):byte;{reset cpt network->err=0ifOK}
function dllkeyPinstal(pass,poste:pchar;desinst:boolean;chemDSK,chemDD:pchar;
  nkey:word;var message:pchar):byte;{->0ifOK}
function dllkeyPdeinst(pass,poste,chem:pchar;nkey:word;
  var message:pchar):byte;{destroy key (DD only) ->0ifOK}
function dllkeyPmajPcode(pass,poste,chem:pchar;nkey:word;
  var pcCompt,pcDate:pchar):byte;{->0ifOK}

 functions (dll convention String Pascal): for VB3
 ----------------------------------------
function dll2keyreset(pass,chemDSK:string;nkey:word):integer;{reset chem(DSK)->0ifOK}
function dll2keyPtest(pass,poste,chem:string;nkey:word;pw:string;var datel:string;
  var nbuse:longint; var nbusersl:word; var message:string):integer;
  {test DD/DSK & increase network cpt->err=0ifOK}
function dll2KeyPexit(pass,poste,chem:string;nkey:word):integer;{decrease cpt network->err=0ifOK}
function dll2KeyPreset(pass,chem:string;nkey:word):integer;{reset cpt network->err=0ifOK}
function dll2keyPinstal(pass,poste:string;desinst:integer;chemDSK,chemDD:string;
  nkey:word;var message:string):integer;{->0ifOK}
function dll2keyPdeinst(pass,poste,chem:string;nkey:word;
  var message:string):integer;{destroy key (DD only) ->0ifOK}
function dll2keyPmajPcode(pass,poste,chem:string;nkey:word;
  var pcCompt,pcDate:string):integer;{->0ifOK}


 error codes & explanations:
 -------------------------------
function keyreset(chemDSK:string):byte;{reset chemDSK->0ifOK}
{*err:DSK: 0=ok, 1=err_I/O, 2=path_not_exist, 3=DD not support*}
{note: to use only if you get problems with I/O DSK}

function keyPtest(poste:string4;chem:string;nkey:word;pw:string;var datel:string10;
  var nbuse:longint; var nbusersl:word; var message:string):byte;
  {test DD/DSK & increase network cpt->err=0ifOK}
{*err
   0=ok, 1=err_I/O, 2=path_not_exist, 3=bad DD or DSK,
   4=no_key, 9=act_of_piracy, 10=no_Poste(network), 11=no_More(network)
  12=already_in(network)
  200=BadDate, 201=UpdateLock, 202=BadUpdateCode, 203=CptEmpty, 204=OutOfDate
*}
{* pw = function (in upper-case or lower-case):
{ if pw='' : TEST & DEC COUNTER Nbuse of 1 unit (idem 'I-1') }
{ if pw='T': QUICK TEST, last used date & counter (nbuse) not change}
{ if pw='In': TEST & INC COUNTER Nbuse by n units (1 by default)}
{ if pw='Dn~x': DATE update for +n days [0=infinite,65535] with update code=x}
{ if pw='Cn~x': COUNTER update for +n keys [0=infinite,65535] with update code=x}
{ if pw='Mx'  : EASY DATE update with update code=x (no pre-code)}
{* note: pw='T' is equal to 'I0' without Update of the last used date*}
{* note: Update don't decrease the use counter (nbuse)*}
{* no_key : protection key not find*}
{* no_Poste: station number not define (if network)*}
{* no_More : highest simultaneous users number is reach (if network)*}
{* already_in : station number already active (retry)*}
{* always followed by KeyPexit (even if an error occur)*}
{* if KeyPexit is not done, KeyPtest give error n12*}

function KeyPexit(poste:string4;chem:string;nkey:word):byte;{decrease network cpt->err=0ifOK}
{* useful only for network version with simultaneous user control active *}
{* to insert (if nbusersl<>0) in the exit procedure (decrease access cpt)*}
{* always after KeyPtest (can be use many time)*}
{* err: 0=ok, 1=err_I/O, 10=no_Poste(network)*}
{* no_Poste: station number not define (if network)*}

function KeyPreset(chem:string;nkey:word):byte;{reset cpt network->err=0ifOK}
{* reset the simultaneous network user counter to zero (for nkey) *}
{* this function must be reserved for an exceptionally use *}
{* err: 0=ok, 1=err_I/O (ex: if reset already made or not useful) *}

function keyPinstal(poste:string4;desinst:boolean;chemDSK,chemDD:string;
  nkey:word;var message:string):byte;{->0ifOK}
{err: 0=ok, 1=err_I/O, 2=path_not_exist, 3=bad DSK or DD RAM or Remote,
      4=no_key (material incompatible), 7=already install, 8=install_cpt=0,
      9=act_of_piracy 10=no_Poste (if network), 200=BadDate,
      201=DirectoryFull}
{*notes:
 nkey: key number for chemDSK & chemDD (<=65535 keys/directory)}
 desinst: true for an uninstallation (false for an installation)
 update the install counter & destroy the previous DD key if necessary
 possible only if today date > date of the key (if not error 200)
 create chemDD if necessary (if not error 201)
*}

function keyPdeinst(poste:string4;chem:string;nkey:word;var message:string):byte;{destroy key DD->0ifOK}
{err: 0=ok, 1=err_I/O, 2=path_not_exist, 3=bad DSK or DD RAM,
      10=no_Poste (if network)}
{*note: erase chemDD if empty*}

function keyPmajPcode(poste:string4;chem:string;nkey:word;
  var pcCompt,pcDate:string):byte;{pre-code maj->0ifOK}
{* must be use JUST BEFORE the effective update by KeyPtest*}
{* must be inserted in an update key menu in the protected soft*}
{* gives update pre-code to use, KPMAJ give the definitive codes*}
{* RAPPEL: KPMAJ must NOT be distribute to yours customers!*}
{*err:
      DD/DSK: 0=ok, 1=err_I/O, 3=RAMDD (if DD) or bad drive (if DSK)
	      4=no_key (nkey or customer defer)
      DD only:
      2=path_not_exist, 9=act_of_piracy, 10=no_poste (if network)
*}

{*fin*}
end.



