
/*********************************************************/
/* EXPAND.C - Support code for expanding                 */
/* filenames with wild cards.                            */
/* Written in Turbo C                                    */
/* 15-SEP-89                                             */
/* By M. Ratcliff                                        */
/*********************************************************/

/* System include files */

#include <dos.h>
#include <dir.h>
#include <stdio.h>
#include <string.h>

#include "expand.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

/****************************************/
/* Get a filename, using the specified  */
/* path and filename with (optionally)  */
/* wild card characters.  Return a ptr  */
/* to the filename and path, if found.  */
/* If no more filenames are available   */
/* return a NULL character pointer.     */
/****************************************/

#define FNLEN   14

static int      foundfirst = FALSE;
static char     fn[FNLEN*4];

static char     drive[MAXDRIVE];
static char     dir[MAXDIR];
static char     file[MAXFILE];
static char     ext[MAXEXT];
int             elements;

/******************************
* GetFilename - Get a file name
* Expand wild cards if needed.
* Use findfirst() and findnext()
* functions of DOS to get the
* job done.
*/

char *GetFilename( const char *filew)

{ /* GetFilename begin */

static struct  ffblk filbuf;
static int     result;
static int     atrib;
char           *resFile;

/* If path == NULL then don't specify one */

if (foundfirst == FALSE )
  {
  /* We've got to start up the file find */
  atrib = 0;
  elements = fnsplit( filew, drive, dir, file, ext );
  result = findfirst(filew, &filbuf, atrib );
  if (result < 0)
    {
    resFile = NULL;     /* No files found */
    foundfirst = FALSE;
    }
  else
    {
    fnmerge(fn, drive, dir, NULL, NULL );
    strcat(fn, filbuf.ff_name );
    strupr(fn);
    resFile = fn;
    foundfirst = TRUE;
    }
  }
else
  {
  result = findnext(&filbuf);
  if (result >= 0)
    {
    fnmerge(fn, drive, dir, NULL, NULL );
    strcat(fn, filbuf.ff_name);
    strupr(fn);
    resFile = fn;
    }
  else
    {
    resFile = NULL;
    foundfirst = FALSE;
    }
  }

return(resFile);

} /* GetFilename end */

