
/************************************/
/* lines of code counter            */
/* Output: lines of source code     */
/*         lines of comments        */
/*         blank lines              */
/*         total lines in file      */
/*                                  */
/* By Matthew J. W. Ratcliff        */
/*                                  */
/* To compile with TURBO C          */
/*                                  */
/* Compile and link with TINY model */
/* for small executable. Ignore     */
/* stack warning from linker.       */
/* When done, rename to .COM file.  */
/*                                  */
/* tcc -w -mt loc.c expand.c        */
/* rename expand.exe expand.com     */
/************************************/

#include <stdio.h>
#include <string.h>

#include "expand.h"

/***********************************************************/
/* sPtr = first_nwhite_notdigit( line_of_code, line_len ); */
/* Return a pointer to the first character in a            */
/* line that is not either a digit, nor white              */
/* space character. Return NULL if unsuccessful            */
/*                                                         */
/* Note that all control characters (< ascii 32) are       */
/* are considered white space. So, if you have a ^L page   */
/* brake line, all by itself, it will end up counting as   */
/* a blank line. As it should                              */
/***********************************************************/

char *first_nwhite_notdigit( char *string, const int len );
void main( int argc, char **argv );



#define STRSZ   80
#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif


void main( int argc, char **argv )
{

unsigned long lines_of_code;
unsigned long lines_of_comments;
unsigned long blank_lines;
unsigned long commented_code;
unsigned long total_lines;
unsigned long all_locd;
unsigned long all_locm;
unsigned long all_bl;
unsigned long all_cc;
unsigned long all_tl;
int           pct_locd;
int           pct_locm;
int           pct_bl;
int           pct_cc;
int           argcinx;
int           nextarg;
int           total_files;

char          start_of_comment[STRSZ]; /* Start of comment delimiter */
int           soclen;                  /* Length of comment delim.   */
char          end_of_comment[STRSZ];   /* end of comment delimiter   */
int           eoclen;                  /* Length of end comment delim*/


char          source_file[STRSZ];
char          *srcPtr;
char          line_of_code[320];
char          *sPtr;                   /* Start of line of code */

FILE          *fPtr;
char          *cFgot;
int           line_len;
int           in_comment_block;
int           work;
char          *startC;
char          *endC;

/*********************************************************/
/* Lines of Code program                                 */
/*********************************************************/

puts("LOC - Lines of Code counter, by Mat*Rat");

if (argc > 1)
  {
  strncpy(start_of_comment, argv[1], 79);
  /***************************************/
  /* Use the a pair of parenthesis () to */
  /* indicate null string.  "" and '' are*/
  /* not necessarily passed by C to the  */
  /* executing program.                  */
  /***************************************/
  work = strcmp(start_of_comment, "()");
  if (work == 0)
    *start_of_comment = '\0';
  soclen = strlen(start_of_comment);
  }
else
  {
  /*
  Request start of comment delimeter string
  */
  puts("START of comment delimeter string ?");
  puts("[RETURN only to count all non-blank lines as program code.]");
  gets(start_of_comment);
  soclen = strlen(start_of_comment);
  }
if (argc > 2)
  {
  strncpy(end_of_comment, argv[2], 79);
  /***************************************/
  /* Use the a pair of parenthesis () to */
  /* indicate null string.  "" and '' are*/
  /* not necessarily passed by C to the  */
  /* executing program.                  */
  /***************************************/
  work = strcmp(end_of_comment, "()");
  if (work == 0)
    *end_of_comment = '\0';
  eoclen = strlen(end_of_comment);
  }
else
  {
  /*
  Request end of comment delimeter string
  */
  puts("END of comment delimeter string ?");
  puts("[RETURN only of comments terminate at end of line.]");
  gets(end_of_comment);
  eoclen = strlen(end_of_comment);
  }

puts("File                       Lines of  Comment   Blank     Commented Total");
puts("                           Code   %  Lines  %  Lines  %  Code   %  Lines");
puts("==========================|=====|===|=====|===|=====|===|=====|===|=====");
/*    filename.ext         xxxxx xxx xxxxx xxx xxxxx xxx xxxxx xxx xxxxx */

argcinx     = argc;
nextarg     = 3;

total_files = 0;
all_locd    = (unsigned long)0;
all_locm    = (unsigned long)0;
all_bl      = (unsigned long)0;
all_cc      = (unsigned long)0;
all_tl      = (unsigned long)0;

/* Force loop once, even if filename isn't on argument line */
/* If multiple files in argument, loop through all of them  */

if (argcinx <= nextarg)
  argcinx = nextarg+1;

while(nextarg < argcinx)
  {
  if (argc > 3)
    {
    strncpy(source_file, argv[nextarg], 79);
    nextarg++;
    }
  else
    {
    puts("Program source filename to count LOC ? ");
    gets( source_file );
    }

  do
    {
    srcPtr = GetFilename(source_file);
    if (srcPtr != NULL)
      {
      fPtr = fopen(srcPtr, "r");

      if (fPtr == NULL)
        printf("Cannot open file %s for read.\n", srcPtr);
      else
        {
        total_files = total_files + 1;
        /*
        Begin
        */
        in_comment_block      = FALSE;
        lines_of_code         = (unsigned long)0;
        lines_of_comments     = (unsigned long)0;
        blank_lines           = (unsigned long)0;
        commented_code        = (unsigned long)0;
        cFgot                 = fgets( line_of_code, 319, fPtr );
        while (cFgot != NULL)
          {
          line_len = strlen(line_of_code);
          if (line_len > 0)
            {
            if (line_of_code[line_len-1] == '\n')
              {
              line_len--;
              line_of_code[line_len] = '\0';
              }
            }
          if (line_len == 0)
            blank_lines = blank_lines + (unsigned long)1;
          else
            {
            sPtr = first_nwhite_notdigit( line_of_code, line_len );
            if (sPtr == NULL)
              blank_lines = blank_lines + (unsigned long)1;
            else if (soclen != 0)
              {
              startC = strstr( sPtr, start_of_comment );
              if (eoclen != 0)
                endC = strstr( sPtr, end_of_comment );
              else
                endC = NULL;
              /*************************************************/
              /* startC points to start of comment on current  */
              /* line_of_code, or is NULL if none found.       */
              /* endC points to end of comment on current      */
              /* line_of_code, or is NULL if none found.       */
              /*************************************************/
              if ( (in_comment_block == TRUE) && (endC != NULL) )
                {
                lines_of_comments = lines_of_comments + (unsigned long)1;
                in_comment_block = FALSE;
                }
              else if ( (in_comment_block == FALSE) && (startC == sPtr) )
                {
                lines_of_comments = lines_of_comments + (unsigned long)1;
                in_comment_block = TRUE;
                if ( (endC > startC) || (eoclen == 0) )
                  in_comment_block = FALSE;
                }
              else if ( (in_comment_block == FALSE) && (startC > sPtr) )
                {
                lines_of_code = lines_of_code  + (unsigned long)1;
                commented_code= commented_code + (unsigned long)1;
                if ( (endC < startC) && (eoclen != 0) )
                  in_comment_block = TRUE;
                }
              else if (in_comment_block == TRUE)
                {
                lines_of_comments = lines_of_comments + (unsigned long)1;
                if (eoclen == 0)
                  in_comment_block = FALSE;
                }
              else
                lines_of_code = lines_of_code + (unsigned long)1;
              }
            else
              { /* !soclen - count all non blank lines as code */
              lines_of_code = lines_of_code + (unsigned long)1;
              }
            }
          cFgot                 = fgets( line_of_code, 319, fPtr );
          } /* end cFgot */
        fclose( fPtr );
        /* Report */
        total_lines = lines_of_code + lines_of_comments + blank_lines;
        if (total_lines != 0)
          {
          pct_locd = (int)( ((unsigned long)100*lines_of_code)/total_lines );
          pct_locm = (int)( ((unsigned long)100*lines_of_comments)/total_lines);
          pct_bl   = (int)( ((unsigned long)100*blank_lines)/total_lines);
          pct_cc   = (int)( ((unsigned long)100*commented_code)/total_lines);
          }
        else
          {
          pct_locd = 0;
          pct_locm = 0;
          pct_bl   = 0;
          pct_cc   = 0;
          }
          sPtr = srcPtr;
          work = strlen(srcPtr);
          if (work > 26)
            sPtr = &srcPtr[work-26];
          printf("%26s %5lu %3d %5lu %3d %5lu %3d %5lu %3d %5lu\n",
                  sPtr,
                  lines_of_code,      pct_locd,
                  lines_of_comments,  pct_locm,
                  blank_lines,        pct_bl,
                  commented_code,     pct_cc,
                  total_lines );

        all_locd    = all_locd + lines_of_code;
        all_locm    = all_locm + lines_of_comments;
        all_bl      = all_bl   + blank_lines;
        all_cc      = all_cc   + commented_code;
        all_tl      = all_tl   + total_lines;
        } /* fPtr !NULL */
      } /* if !srcPtr */
    }
  while (srcPtr != NULL);
  } /* while !done with command line */
  if (total_files > 1)
    {
    if (all_tl != 0)
      {
      pct_locd = (int)( ((unsigned long)100*all_locd)/all_tl );
      pct_locm = (int)( ((unsigned long)100*all_locm)/all_tl);
      pct_bl   = (int)( ((unsigned long)100*all_bl)/all_tl);
      pct_cc   = (int)( ((unsigned long)100*all_cc)/all_tl);
      }
    else
      {
      pct_locd = 0;
      pct_locm = 0;
      pct_bl   = 0;
      pct_cc   = 0;
      }
    puts("==========================|=====|===|=====|===|=====|===|=====|===|=====");
    printf("%26s %5lu %3d %5lu %3d %5lu %3d %5lu %3d %5lu\n",
            "Totals:",
            all_locd,   pct_locd,
            all_locm,   pct_locm,
            all_bl,     pct_bl,
            all_cc,     pct_cc,
            all_tl );

    puts("==========================|=====|===|=====|===|=====|===|=====|===|=====");
    puts("File                       Lines of  Comment   Blank     Commented Total");
    puts("                           Code   %  Lines  %  Lines  %  Code   %  Lines");
    }

} /* MAIN */

/***********************************************************/
/* sPtr = first_nwhite_notdigit( line_of_code, line_len ); */
/* Return a pointer to the first character in a            */
/* line that is not either a digit, nor white              */
/* space character. Return NULL if unsuccessful            */
/*                                                         */
/* Note that all control characters (< ascii 32) are       */
/* are considered white space. So, if you have a ^L page   */
/* brake line, all by itself, it will end up counting as   */
/* a blank line. As it should                              */
/***********************************************************/

char *first_nwhite_notdigit( char *string, const int len )

{ /* first_nwhite_notdigit begin */


int     i;
int     got_it;
char    *fnW;


fnW     = string;
got_it  = FALSE;
i       = 0;

while (!got_it)
  {
  if ( ( (*fnW > '9') && (*fnW <= '~') ) ||
       ( (*fnW >= '!') && (*fnW < '0') ) )
    got_it = TRUE;
  else if (*fnW == '\0')
    {
    got_it = TRUE;
    fnW = NULL;
    }
  else
    {
    fnW++;
    i++;
    }
  if (i > len)
    {
    fnW    = NULL;
    got_it = TRUE;
    }
  } /* end while !got_it */

return( fnW );

} /* first_nwhite_notdigit end */

