unit Zap;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, FileCtrl, ComCtrls, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    FileListBox: TFileListBox;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    SecureBtn: TButton;
    CloseBtn: TBitBtn;
    FileLabel: TLabel;
    ProgressBar1: TProgressBar;
    ProgressBarLabel: TLabel;
    { Menu Selections }
    MainMenu1: TMainMenu;
    mmOptions: TMenuItem;
    mmHelp: TMenuItem;
    { Option Items }
    oDisableWarning: TMenuItem;
    OptionsSeparator1: TMenuItem;
    oExit: TMenuItem;
    { Help Items }
    hContents: TMenuItem;
    HelpSeparator1: TMenuItem;
    hAbout: TMenuItem;
    hSearchforHelpOn: TMenuItem;
    hHowToUseHelp: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure SecureBtnClick(Sender: TObject);
    { Menu Methods }
    procedure oExitClick(Sender: TObject);
    procedure oDisableWarningClick(Sender: TObject);
    procedure hContentsClick(Sender: TObject);
    procedure hSearchforHelpOnClick(Sender: TObject);
    procedure hHowToUseHelpClick(Sender: TObject);
    procedure hAboutClick(Sender: TObject);
  private
    { Private declarations }
    procedure DisplayHint(Sender: TObject);
  public
    { Public declarations }
    function VerifyDelete(const FName : string): boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

//------------------------- METHODS SPECIFIC TO OUR FORM ---------------------

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnHint := DisplayHint;
end;

procedure TForm1.DisplayHint(Sender: TObject);
begin
  StatusBar1.Panels.Items[0].Text := Application.Hint;
end;

procedure TForm1.oDisableWarningClick(Sender: TObject);
begin
  oDisableWarning.checked := not oDisableWarning.checked;
end;

procedure TForm1.oExitClick(Sender: TObject);
begin
   Close;
end;

procedure TForm1.hContentsClick(Sender: TObject);
begin
  Application.HelpContext(0);
end;

procedure TForm1.hSearchforHelpOnClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_PARTIALKEY, 0);
end;

procedure TForm1.hHowToUseHelpClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TForm1.hAboutClick(Sender: TObject);
begin
  MessageDlg('ZapFile (Security Delete)' + #$0D#$0A +
              'Freeware version' + #$0D#$0A +
              'Compliments of Pacific Rim Software' + #$0D#$0A +
              '              1997',
              mtInformation, [mbOk], 0);
end;


//----------------------------- DELETE THE FILE ------------------------------

procedure TForm1.SecureBtnClick(Sender: TObject);
{ Crypto standard to securely delete a file requires it be overwritten
  at least three times before actual deletion.  This algorithm assumes
  the government standard is intentionally false and overwrites the file
  100 times before deletion. }
const
  ERROR_MSG = 'Error trying to delete file.';
type
  TBuffer = array[0..8191] of char;
var
  i : integer;           // loop control
  DF:   file;            // untyped file to delete
  Buf,
  Temp : ^TBuffer;       // hold new text to write to file
  ReadCnt,
  WriteCnt : integer;    // number 1 byte 'records' read or written
  BookMark : integer;    // remember comboBox display location
begin
  with FileListBox do
  begin
    { If no file is selected, abort the button press. }
    if ItemIndex < 0 then
    begin
      MessageDlg('You must select a file to delete.', mtInformation, [mbOk], 0);
      abort
    end;
    { If DisableWarnings is checked, no dialog will appear. However, if
      not, then VerifyDelete() will honor user's request.  }
    if Selected[ItemIndex] then             // something must be selected
      begin
        if VerifyDelete(FileName) then
          begin
            BookMark := ItemIndex;          // remember where we are
            New(Buf);                       // allocate memory for Buf
            New(Temp);                      // allocate memory for Temp
            try
              Cursor := crHourglass;        // no user input allowed
             { process the file 100 times.}
             for i := 0 to 99 do begin
               try                           // catch file opening error
                 AssignFile(DF, FileName);   // open the file
                 Reset(DF,1);                // set record size to 1 byte
                 repeat
                   try                       // catch file i/o error
                     BlockRead(DF, Temp^, sizeOf(Temp^), readCnt);
                     { Fill write buffer with just enough characters. }
                     FillChar(Buf^, readCnt, chr(i + 27));
                     { Return file pointer to last read position. }
                     Seek(DF, FilePos(DF)- readCnt);
                     { Overwrite with new characters. }
                     BlockWrite(DF, Buf^, readCnt, writeCnt);
                   except
                     MessageDlg(ERROR_MSG, mtError, [mbOk], 0);
                   end;
                 until (readCnt = 0) or (writeCnt < readCnt);
                 ProgressBar1.StepIt;        // show our progress
               finally
                 CloseFile(DF);
               end;
             end;
              { When we finally get here the disk area has been rewritten
                one hundred times with just one character.  It is unlikely
                anything will peek through using a disk analysis tool. }
              DeleteFile(FileName);
              Update;                        // show the file is gone...
              ItemIndex := BookMark;         // but keep our position
            finally
              Dispose(Buf);                  // release memory
              Dispose(Temp);
              Cursor := crDefault            // allow User input
            end
          end
      end  { if selected }
  end;
  ProgressBar1.Position := 0;               // go back to the beginning
end;

function TForm1.VerifyDelete(const FName : string): boolean;
{ User may not want to be prompted each time to delete a file.  If
  MenuItem oDisableWarning is checked, no dialog will appear.  Otherwise
  user gets a chance to cancel the operation.  }
begin
  if oDisableWarning.checked then
    result := true                           // skip all the rest
  else
    if MessageDlg('Do you wish to delete ' + FName,
         mtWarning, mbYesNoCancel, 0) = mrYES then
      result := true
    else
      result := false;
end;

end.
