/*	TYPES.H
	Public Domain 1993	Keith L. Robertson
	This file is placed in the public domain by the author.

	Contains short definitions of numeric types and Max and Min values.
	Also, binary and trinary 'max' and 'min' macros.
*/
#ifndef TYPES_H
#define TYPES_H 1


typedef void		VOID;

typedef int		BOOL;		/* Use for interface */
typedef unsigned char	BOOLE;		/* Use for implementation */
#define			false		(0)
#define			true		(1)

typedef char*		 STRING;
typedef const char*	CSTRING;
typedef char		 STRING_BUF [];
typedef const char	CSTRING_BUF [];


typedef unsigned char	UCHAR;
typedef   signed char	SCHAR;
typedef		 char	 CHAR;
#define		Min_schar	(0x80)
#define		Max_schar	(0x7f)
#define		Max_uchar	(0xff)
#if	_CHAR_UNSIGNED
    #define	Min_char	(0)
    #define	Max_char	Max_uchar
#else
    #define	Min_char	Min_schar
    #define	Max_char	Min_uchar
#endif


typedef unsigned short	USHORT;
typedef		 short	 SHORT;
#define		Min_short	(0x8000)
#define		Max_short	(0x7fff)
#define		Max_ushort	(0xffff)


typedef unsigned long	ULONG;
typedef		 long	 LONG;
#define		Min_long	((LONG) 0x80000000)
#define		Max_long	((LONG) 0x7fffffff)
#define		Max_ulong	((ULONG)0xffffffff)


typedef unsigned int	UINT;
typedef		 int	 INT;
#if	sizeof(int) != 4	/* Not ANSI.  May not work on all compilers. */
    #define	Min_int		Min_short
    #define	Max_int		Max_short
    #define	Max_uint	Max_ushort
#else
    #define	Min_int		Min_long
    #define	Max_int		Max_long
    #define	Max_uint	Max_ulong
#endif


typedef	unsigned	SIZE_T;
typedef float		FLOAT;
typedef double		DOUBLE;


/*	Divide: rounding up, or just round	*/
#define		div_up(numer,denom)	(((numer)+((denom)-1))/(denom))
#define		div_round(numer,denom)	(((numer)+((denom)/2))/(denom))


/*	For efficiency, do not use expressions as max or min arguments */
#define		max(a,b)	((a)>(b) ? (a) : (b))
#define		min(a,b)	((a)<(b) ? (a) : (b))
#define		max3(a,b,c)	((a)>(b) ? max((a),(c)) : max((b),(c)))
#define		min3(a,b,c)	((a)<(b) ? min((a),(c)) : min((b),(c)))


#endif  /* TYPES_H */
