{**************************************************************************
  BASEAPP.PAS, MyApp Main program

  Copyright (C) 1996, BitSoft Development, L.L.C.

  Generated by Turbo Vision Resource WorkShop
***************************************************************************}

{ This is the skeleton file generated by Turbo Vision Resource Workshop.
  We have modified it a little, in order to use all the resources we have
  created for this sample application.  All the changes have been documented
  in the code. }

program BASEAPP;

uses
  Drivers, Objects, Views, Dialogs, Menus, Validate, App,
  { Add the constants unit to the uses clause. }
  Types;

var
  ResFile: PResourceFile;

type
  TMyApp = Object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

constructor TMyApp.Init;
begin
  ResFile := New(PResourceFile, Init(New(PBufStream, Init('BASEAPP.RES',
    stOpenRead, 4096))));
  RegisterObjects;
  RegisterViews;
  RegisterDialogs;
  RegisterValidate;
  RegisterMenus;
  RegisterApp;
  inherited Init;
  { In most cases, you will want to disable these when there are no
    windows open in the desktop. }
  DisableCommands([cmSave, cmSaveAs, cmSaveAll]);
end;

destructor TMyApp.Done;
begin
  inherited Done;
  Dispose(ResFile, Done);
end;

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  case Event.What of
    evCommand:
      case Event.Command of
        { Add the event handler for displaying the "About..." box. }
        cmAbout : ExecuteDialog(PDialog(ResFile^.Get('AboutBox')), nil);
      end;
  end;
end;

procedure TMyApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := PMenuBar(ResFile^.Get('SampleMenu'));
  MenuBar^.ChangeBounds(R);
end;

procedure TMyApp.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := PStatusLine(ResFile^.Get('SampleStatus'));
  StatusLine^.ChangeBounds(R);
end;

var
  MyApp: TMyApp;

begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.

