/****************************************************************************
**                                                                         **
**	Description..: FileNumberer                                            **
**  Version......: 1.00.001                                                **
**                                                                         **
**  Input........: 4DigitStartNumber(HEX) FileSpecs                        **
**                                                                         **
**                                               (c) Blue Nose Productions **
****************************************************************************/
#include <stdlib.h>			// atol()
#include <string.h>			//strcmpi()
#include <stdio.h>			//FILE*
//----------------------------------------------------------------------------
#define TRUE			1
#define FALSE			0
//----------------------------------------------------------------------------
char 	*CopyRight		="sD d >< Blue Nose Productions\n",
		*MSG_DONE		="Renamed %s to %s                 \r";
//----------------------------------------------------------------------------
inline char *GetExtension(const char *src)
{
	return strrchr(src,'.');
}
//----------------------------------------------------------------------------
int main(int argc,char **argv)
{
	printf(CopyRight);
	if (argc<2)
	{
		printf("FileNum <4DigitStartNumber(HEX)> <FileSpecs>\n");
		printf("Example: FileNum.Exe 0001 *.mod\n");
		return FALSE;
	}

	char	NameBuf[11];
	int		start;
	sscanf(argv[1],"%4x",&start);

	for (int i=2;i<argc;i++)
	{
		sprintf(NameBuf,"%.4x%s",start,GetExtension(argv[i]));
		rename(argv[i],NameBuf);
		printf(MSG_DONE,argv[i],NameBuf);
		start++;
	}
	return 0;
}
//----------------------------------------------------------------------------
