/*
    simple.pov  -  anim8 animator demo
     A box moving above a checkered plane.

    demo by mark willis
    maw01@mindspring.com
    not copyrighted - distribute this file freely
*/

camera {
  location  <-50.0, -140.0, 50.0>
  direction <0.0, 0.0, 1.0>
  sky       <0.0, 0.0, 1.0>
  up        <0.0, 0.0, 1.0>
  right     <0.0, 0.0, 1.333>
  look_at   <20.0, 0.0, 50.0>
}

light_source { <500.0, -900.0, 280.0>  color rgb <1.0, 1.0, 1.0> }
light_source { <-500.0, -800.0, 390.0> color rgb <0.8, 0.7, 0.4> }
light_source { <200.0, -400.0, 490.0>  color rgb <0.5, 0.6, 0.9> }

fog {color red 0.3 green 0.4 blue 0.6 distance 2000}

plane {   // ground
  z,0
  texture {
    pigment {
      checker
        color rgb <0.5, 0.5, 0.7>
        color rgb <0.4, 0.4, 0.5>
    }
    scale <80.0, 80.0, 1.0>
  }
  translate <0.0, 0.0, -10.0>
  rotate <0.0, 0.0, 20.0>
}

#declare dim = 10.0
object {  // cube
  box {<-dim,-dim,-dim>,<dim,dim,dim>}
  texture {
    pigment { color rgb <0.4, 0.45, 0.5> }
    finish {
      ambient      0.3
      diffuse      0.7
      brilliance   0.4
      phong        1.00
    }
  }
  translate < %object1 translate% > // <-- **** ANIM8 ANIMATION COMMAND ****
}


