
//      ANIM8 demo for VIVID raytracer

#define plum   (.9 .7 .9)

studio {
	from %camera translate%   // <---**** ANIM8
	at %sphere translate%     // <---**** ANIM8
	up 0 0 1
	angle 60
	res %w% %h%   // <-- ************ ANIM8 macros *************
	aspect 4/3
	antialias adaptive
	threshold 4
	bkg plum
	haze .001
}
light { type point falloff 0 position 500 -900 480 color 1 1 1 }
light { type point falloff 0 position -500 -800 290 color .8 .7 .4 }
light { type point falloff 0 position 200 -400 190 color .5 .6 .9 }


surface { diff (.5 .5 .7) }
ring {
	center 0 0 -10
	normal 0 0 1
	radius 50000
}
	
surface {
    diff (.3 .4 .7)
    shine 500 (1 1 1)
}
sphere {
    center %sphere translate%
    radius 4
}

surface {
    diff (.2 .3 .3)
    shine 500 (1 1 1)
}
transform {
    scale      10
    rotate     0 0 0
    translate  %cube translate% // <-- **** ANIM8 ANIMATION COMMAND ****
}

// #include cube.vo
polygon { points 4
    vertex (-1 -1 -1) vertex (1 -1 -1) vertex (1 1 -1) vertex (-1 1 -1) }
polygon { points 4
    vertex (-1 -1 -1) vertex (-1 1 -1) vertex (-1 1 1) vertex (-1 -1 1) }
polygon { points 4
    vertex (-1 1 -1) vertex (1 1 -1) vertex (1 1 1) vertex (-1 1 1) }
polygon { points 4
    vertex (1 1 -1) vertex (1 -1 -1) vertex (1 -1 1) vertex (1 1 1) }
polygon { points 4
    vertex (1 -1 -1) vertex (-1 -1 -1) vertex (-1 -1 1) vertex (1 -1 1) }
polygon { points 4
    vertex (-1 -1 1) vertex (-1 1 1) vertex (1 1 1) vertex (1 -1 1) }


