/*
   Test file for PCG version 1.2
   Patrick LeBlanc  May/23/96
     Shows the use of a linear path for rotating an object.  
*/
#include "colors.inc"
#include "textures.inc"
#include "plane.inc" // my paper airplane
#include "island.inc" // my island texture
// this includes the PCG generated curve vectors
#include "spline.inc"

camera {
  location Camspot
  look_at <50,10,50>
}

light_source {
  <-10,100,-200> White
  looks_like {
    sphere {
     <0,0,0>,40
     pigment { Orange }
     finish { ambient 1 }
    }
  }
}

plane {
  y,2
  pigment { Blue filter .75 }
  normal { waves 6 frequency 3 turbulence 10 }
  finish { Shiny }
}

plane {
  y,1
  pigment { White }
}

object {   // island
  height_field {
    tga "ISL.TGA"
    water_level 0.0
    smooth
  }
  texture {
    isl
    scale <1,1.1,1>
  }
  scale <100, 15, 100>
}

// taken directly from the povray 3 docs 
sky_sphere {
 pigment {
   gradient y
   color_map {
    [ 0.4 CornflowerBlue ]
    [ 1.0 MidnightBlue ]
   }
 }
}

// this plane is much bigger than it appears, so no_shadow was needed
// to stop it from shadowing a lot of the water
object {
  Plane
  no_shadow
  scale 2.4

  rotate x * ( xrotzrot.y + 3 )  // linear spline
  rotate z * xrotzrot.x  // linear spline

  // omigod, I used the clock variable
  rotate y * ((clock * 360) + 50 ) // default 50 + rotate with camera

  // stick the paper plane about halfway between the cam and the
  // middle of the look_at point, then apply some small changes to x,y,z
  // so the thing doesn't just stand still there.
  translate ((<50,10,50> + Camspot) * .55) + xposyposzpos
}
