#include "colors.inc"
#include "textures.inc"

// for the pcg generated vectors
#include "spline.inc"

camera {
 location <18,3,-15> 
 look_at <12,5,0>
}

// a constant light source
light_source {
  <-2,10,-20> color White * 1.6 
  fade_distance 15
  fade_power 2
}
light_source {
  <-2,11,-19> color White * 1.3
  shadowless
}

// a bright flashing strobe controlled in 'lights.dat'
light_source {
  <18,10,-20> color rgb <1.45,1.45,1.5> * Strobe.x
  fade_distance 50
  fade_power 2
}


// Some textures
#declare RED =
  texture {
    pigment { Red }
    finish {
      phong 1
      reflection .2
    }
    normal { bumps .3 turbulence 4 }
  }

#declare Wavy_Water =
texture {
   pigment {
     color rgbf<0.137, 0.557, 0.420, 0.698>
   }
   normal {
     waves 1.0000
     frequency 3.000
     // alter phase to animate from 5 -> 1
     phase WaterPhase.x
   }
   finish {
     diffuse 0.430
     ambient 0.450
     phong 0.260
     phong_size 20.300
     reflection 0.430
     refraction 1
     ior 1.330
     specular 0.400
     roughness 0.0010
     brilliance 2.380
   }
}

// the objects
#declare pcg_P = union {
  cone { 
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 6.0>
    texture { RED }
    rotate 180.0*x
    translate  <-0.449159, 1.470023, 3.329341>
  }
  torus { 
    1.5, 0.5  rotate -x*90
    scale <1.2, 1.0, 1.0>
    texture { RED }
    rotate <90.0, -90.0, 0.0>
    //rotate the torus like nuts
    rotate x*(TorTurn.x*180)
    translate  <1.066338, 1.43383, 2.293272>
  }
  scale 1.1
  translate  <0.406655, -0.302228, 0.0>
}

#declare pcg_C = union {
  object {
    bicubic_patch { type 1 flatness 0.01 u_steps 4 v_steps 4,
      <3.680785, -2.000000, 6.265169>, <2.077273, -2.000000, 4.122228>, <2.498714, -2.000000, 2.892792>, <3.679514, -2.000000, 2.422713>, 
      <3.536146, -1.000000, 5.640944>, <1.932633, -1.000000, 2.314233>, <2.354075, -1.000000, 1.084797>, <3.534874, -1.000000, 0.614718>, 
      <3.536146, 0.000000, 5.640944>, <1.932633, 0.000000, 2.314233>, <2.354075, 0.000000, 1.084797>, <3.534874, 0.000000, 0.614718>, 
      <3.680785, 1.000000, 6.265169>, <2.077273, 1.000000, 4.122228>, <2.498714, 1.000000, 2.892792>, <3.679514, 1.000000, 2.422713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.01 u_steps 4 v_steps 4,
      <3.679514, -2.000000, 2.422713>, <4.860313, -2.000000, 1.952634>, <5.860313, -2.000000, 1.952634>, <6.860313, -2.000000, 1.952634>, 
      <3.534874, -1.000000, 0.614718>, <4.715674, -1.000000, 0.144640>, <5.715674, -1.000000, 0.144640>, <6.715674, -1.000000, 0.144640>, 
      <3.534874, 0.000000, 0.614718>, <4.715674, 0.000000, 0.144640>, <5.715674, 0.000000, 0.144640>, <6.715674, 0.000000, 0.144640>, 
      <3.679514, 1.000000, 2.422713>, <4.860313, 1.000000, 1.952634>, <5.860313, 1.000000, 1.952634>, <6.860313, 1.000000, 1.952634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.01 u_steps 4 v_steps 4,
      <6.860313, -2.000000, 1.952634>, <7.860313, -2.000000, 1.952634>, <8.860313, -2.000000, 1.952634>, <9.679514, -2.000000, 2.422713>, 
      <6.715674, -1.000000, 0.144640>, <7.715674, -1.000000, 0.144640>, <8.715674, -1.000000, 0.144640>, <9.534874, -1.000000, 0.614718>, 
      <6.715674, 0.000000, 0.144640>, <7.715674, 0.000000, 0.144640>, <8.715674, 0.000000, 0.144640>, <9.534874, 0.000000, 0.614718>, 
      <6.860313, 1.000000, 1.952634>, <7.860313, 1.000000, 1.952634>, <8.860313, 1.000000, 1.952634>, <9.679514, 1.000000, 2.422713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.01 u_steps 4 v_steps 4,
      <9.679514, -2.000000, 2.422713>, <10.498714, -2.000000, 2.892792>, <12.077273, -2.000000, 4.122228>, <10.546080, -2.000000, 6.554449>, 
      <9.534874, -1.000000, 0.614718>, <10.354075, -1.000000, 1.084797>, <11.932633, -1.000000, 2.314233>, <10.401441, -1.000000, 5.930223>, 
      <9.534874, 0.000000, 0.614718>, <10.354075, 0.000000, 1.084797>, <11.932633, 0.000000, 2.314233>, <10.401441, 0.000000, 5.930223>, 
      <9.679514, 1.000000, 2.422713>, <10.498714, 1.000000, 2.892792>, <12.077273, 1.000000, 4.122228>, <10.546080, 1.000000, 6.554449>
    }
  }
  texture {
    Lightening2 rotate -x*45 scale <3,5,3>
    finish { phong 1 reflection .5 }
    // rotate the texture for a crazy effect
    rotate y*Ctext.x
    rotate x*(Ctext.x/1.5)
    rotate z*(Ctext.x/3)
  }
  scale 0.85536
  rotate <-180.0, -90.0, 0.0>
  translate  <4.1, 0.897586, -4.940266>
}

#declare pcg_G =
  blob {
    threshold 1

    sphere { 
      BLOB1,1.4,1
      translate  <14.909902, 1.465429, -1.712624>
    }
    sphere { 
      BLOB2,1.4,1
      translate  <15.21213, 1.34331, 3.223763>
    }
    sphere { 
      BLOB3,1.4,1
      translate  <16.421041, 1.221191, -2.317079>
    }
    sphere { 
      BLOB4,1.4,1
      translate  <16.421041, 1.221191, -1.410396>
    }
    sphere { 
      BLOB5,1.4,1
      translate  <16.48517, 1.221191, -0.604455>
    }
    sphere { 
      BLOB6,1.4,1
      translate  <15.795209, 1.465429, 0.0>
   }
    sphere { 
      BLOB7,1.4,1
      translate  <15.111387, 1.34331, 0.302228>
    }
    sphere { 
      BLOB8,1.4,1
      translate  <14.28407, 1.587548, 0.302228>
    }
    sphere { 
      BLOB9,1.4,1
      translate  <14.183328, 1.34331, -2.317079>
    }
    sphere { 
      BLOB10,1.4,1
      translate  <13.499506, 1.34331, -2.317079>
    }
    sphere { 
      BLOB11,1.4,1
      translate  <12.89505, 1.221191, -2.115594>
    }
    sphere { 
      BLOB12,1.4,1
      translate  <12.009744, 1.465429, -1.712624>
    }
    sphere { 
      BLOB13,1.4,1
      translate  <11.441901, 1.34331, -0.906683>
    }
    sphere { 
      BLOB14,1.4,1
      translate  <14.226081, 1.34331, 3.52599>
    }
    sphere { 
      BLOB15,1.4,1
      translate  <13.298021, 1.34331, 3.425248>
   }
    sphere { 
      BLOB16,1.4,1
      translate  <12.470704, 1.465429, 3.12302>
    }
    sphere { 
      BLOB17,1.4,1
      translate  <11.945614, 1.465429, 2.317079>
    }
    sphere { 
      BLOB18,1.4,1
      translate  <11.504917, 1.34331, 0.014605>
    }
    sphere { 
      BLOB19,1.4,1
      translate  <11.413523, 1.465429, 1.012477>
    }
    texture { Soft_Silver }
    translate  <0.288277, -0.100743, 0.488476>
  } // end of blob

union {
  object { pcg_P }
  object { pcg_C }
  object { pcg_G }
  rotate -90.0*x
  translate  <2.21338, 2.930858, 0.0>
}

// a water-like object.  3 X 3 units on x,y plane from 0 -> 3
object {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <-1.492063, -2.000000, -0.490422>, <-0.824849, -2.000000, 0.367817>, <0.437877, -2.000000, -0.945814>, <1.490422, -2.000000, 0.000000>, 
      <-1.492063, -1.000000, -0.490422>, <-0.824849, -1.000000, 0.367817>, <0.437877, -1.000000, -0.945814>, <1.490422, -1.000000, 0.000000>, 
      <-1.492063, 0.000000, -0.490422>, <-0.824849, 0.000000, 0.367817>, <0.437877, 0.000000, -0.945814>, <1.490422, 0.000000, 0.000000>, 
      <-1.492063, 1.000000, -0.490422>, <-0.824849, 1.000000, 0.367817>, <0.437877, 1.000000, -0.945814>, <1.490422, 1.000000, 0.000000>
    }
  }
  texture {
    Wavy_Water
  }

  // rotate a bit
  rotate -y*35
  rotate -x*20

  // don't alter this line
  translate  <1.519194, 2.003572, 0.0>

  scale <6.5,3,3>
  // move into position
  translate <-2,1,3>
}

// a blatant and shameless plug flying back and forth
text {
  ttf "timrom.ttf", "Patrick's Curve Generator", .4, 0
  rotate -x*20
  scale <6,8,6>
  // Pan2 spline for banner in 'banner.dat'
  translate <Pan2.x,13,8>
  texture { Polished_Brass }
}

