// SPLINE GENERATOR SAMPLE: BOUNCING BALL ANIMATION
// ************************************************

camera {location <5, 40, -70> look_at <0, 7, 0> angle 30}
light_source {<5, 80, -40> rgb 1
   spotlight point_at <0, 0, 0> radius 5 falloff 20}

disc {<0, 0, 0>, y, 40
   texture {checker
      texture {
         pigment {marble color_map {[.8 rgb 0] [1 rgb .7]}
            turbulence .8 scale .6}
         finish {ambient 0 diffuse 1 reflection .6}}
      texture {
         pigment {marble color_map {[.8 rgb 1] [1 rgb .3]}
            turbulence .8 scale .6 translate <-100, 0, 0>}
         finish {ambient 0 diffuse 1 reflection .8}}
      scale 8}}

#include "Unsmooth.spl"
#declare scale_factor = (10 - spline_pos.y) / 20

sphere {<0, 1, 0>, 1
   pigment {rgb <1, 0 ,0>}
   finish {phong .6 phong_size 5}
   scale <2 + scale_factor, 2 - scale_factor, 2 + scale_factor>
   translate spline_pos}
