// ***********************************************************
// SPLINE GENERATOR INCLUDE FILE FOR PERSISTENCE OF VISION 3.x
//    ABSOLUTE POSITION SPLINE GENERATOR
// ***********************************************************
//
// Created by Chris Colefax, February 1997
//
// See "Spline.txt" for more information.
//
// ***********************************************************

// CHECK DECLARED VARIABLES AND SET DEFAULT VALUES
// ***********************************************
   #declare _SP_tempver = version
   #ifndef (point1)  #declare point1 = <0, 0, 0>  #end
   #ifndef (point2)  #declare point2 = <0, 0, 0>  #end
   #ifndef (point0)  #declare point0 = point1     #end
   #ifndef (point3)  #declare point3 = point2     #end

   #ifndef (spline_clock)     #declare spline_clock = clock  #end
   #ifndef (spline_segments)  #declare spline_segments  = 1  #end
   #ifndef (spline_loop)      #declare spline_loop  = false  #end
   #ifndef (_SP_curseg)       #declare _SP_curseg   = 0      #end

   #declare spline_segments = int (spline_segments)
   #if (spline_segments = 0)  #declare spline_segments = 1                      #end
   #if (spline_segments < 0)  #declare spline_segments = abs (spline_segments)  #end

// CHECK FOR SPLINE LOOP
// *********************
   #if (spline_loop != false & _SP_curseg = 0)
      #declare _SP_point1      = point1
      #declare _SP_point0      = point0
      #declare spline_segments = spline_segments + 1
   #end

// CHECK SPLINE CLOCK VALUE
// ************************
   #declare _SP_clock = spline_clock
   #if (_SP_clock != 1)  #declare _SP_clock = mod (spline_clock, 1)  #end
   #if (_SP_clock < 0)   #declare _SP_clock = _SP_clock + 1          #end

// CALCULATE SPLINE POSITION
// *************************
   #if (_SP_clock >= (_SP_curseg / spline_segments) & _SP_clock < ((_SP_curseg + 1) / spline_segments))
      #declare _SP_clock  = mod (_SP_clock * spline_segments, 1)
      #declare spline_pos =
         pow(1 - _SP_clock, 3) *     point1 +
         pow(1 - _SP_clock, 2) * 3 * _SP_clock         * (point1 + point1 - point0) +
         (1 - _SP_clock)       * 3 * pow(_SP_clock, 2) * (point2 + point2 - point3) +
         pow(_SP_clock, 3)     *     point2
   #else
      #if (_SP_clock = 1 & _SP_curseg + 1 = spline_segments)
         #declare spline_pos = point2
      #end
   #end

// PREPARE FOR NEXT SEGMENT
// ************************
   #declare point0 = point2 + point2 - point3
   #declare point1 = point2
   #declare point2 = point3

   #declare _SP_curseg = _SP_curseg + 1
   #if (_SP_curseg >= spline_segments)  #declare _SP_curseg = 0  #end

// CLOSE SPLINE FOR LOOPED SPLINES
// *******************************
   #if (spline_loop != false & _SP_curseg + 1 = spline_segments)
      #declare point2 = _SP_point1
      #declare point3 = point2 + point2 - _SP_point0
      #include "Spline.inc"
   #end

   #version _SP_tempver
