// SPLINE GENERATOR SAMPLE: SPLINE BASED OBJECT
// ********************************************

camera {location <0, 70, -20> look_at <0, 0, 0> angle 40}
light_source {<10, 60, 10> rgb 1}

#declare Smoothness = 50

union {
   #declare Smoothness = (1 / Smoothness)
   #declare Count = 0 #while (Count < 1)
      #declare spline_clock = Count #include "Smooth.spl"
      #declare CurPoint = spline_pos
      #declare CurRadius = (1 - abs(Count * 2 - 1)) * 3

      #ifdef (PrevPoint)
         sphere {PrevPoint, PrevRadius}
         cone {PrevPoint, PrevRadius, CurPoint, CurRadius}
      #end

      #declare PrevPoint = CurPoint
      #declare PrevRadius = CurRadius
   #declare Count = Count + Smoothness #end

   pigment {bozo color_map {[0 rgb <0, .2, .7>] [1 rgb <.2, .6, 1>]}
      scale 10}
   normal {bumps .5 scale .75}
   finish {phong .3}}
