{* SEG.H -------------------------------------------------------*
 * This Defined the SEGDATA-Structure used by SEG and THINHELP	*
 * To Store Data-Correspondence between Positionon on the Srceen*
 * and Help-Topic						*
 *--------------------------------------------------------------*}

unit seg;

interface

uses WinTypes;

{* File-Structure of .SEG-Files had to be revised between JPANI Version 1.x
   and ThinHelp. The new .SEG-Files are not Compatible to the old ones and
   old Files have to be converted by SEG.EXE

   The main Reason for the Change in the File Structure is that we Felt it
   to be neccessary to support Longer Macro-Strings especially in respect to
   for Windows Help V4.0.

   There are also some more Dummy-Datafields for future enhancements as we
   plan to implement several additional Features.

   To show the incompatibility of the Files the new SEG-Files to now use
   a different SEG_MAGIC number.
*}

const FILENAMELENGTH=	256;		{ Maximum Length of a File-Name for .HPJ and .JPG/.BMP-File }
const MAX_SEGINFOS=     600;		{ Maximum Number of SEGJUMP-Entries in one SEG-File. }
const MACROLENGTH=     8000;		{ Maximum Length of a Macro-String... more or less a random Number... }
const HOTSPOTIDLENGTH=  200;		{ Maximum Length of a Macro-String... more or less a random Number... }

const SEG_MAGIC=12199;                   { Magic Number to show it's really one of our SEG-Files }

const SI_JUMP  =0;			{ Markes Hotspot type: Jump   }
const SI_POPUP =1;			{			Popup }
const SI_MACRO =2;			{			Macro }


{  SEGSTRINGs for Macros and Context-Strings have unlimeted Strings-Lengths
   When loeaded into memory, the Application Program (THNHLP.DLL) stores
   a Pointer to the String, on the Hard-Disk an offset into the SEG-File
   is to be used instead.

   The End of the String is to be detected by the trailing Zero as usual in C

   Note that the Strings-Length is not limited by the way this File-Format is
   defined but THNHLP.DLL 16-Bit will not allow to use more than about 4-8 KByte
   of Strings at one time.
}
type SEGSTRING = LongInt;                  { Byte-Offset from the Beginning of the SEG-File }


{  SEGJUMP Structure defines one rectangular Hotspot-area that is connected to a
   Context-String or Macro-Reference.
}
type PSEGJUMP = ^TSEGJUMP;
     TSEGJUMP = RECORD
	   {  Rectangular Area for the Segment.
              Note: This is NOT binary compatible To a RECT-Structure on WIN32 }
           left, top, right, bottom : Word;

           {  WinHelp Macro-String to be executed when the user clicks onto the Hotspot.
              For SI_POPUP and SI_JUMP this member contains the Context-String used for the Jump }
	   macro        : SEGSTRING;

           {  The Hostspot Id is the String that SHED also allows to enter for our
              Hotspot. It may be used later for special effects. }
           HotspotId    : SEGSTRING;

           {  Metafiles can be huge Pictures and are stored by Position into the file. }
           metapos      : LongInt;	   { Position of the Metafile in the SEG File }
           metalen      : LongInt;	   { Length of the Metafile Information in the SEG File. }

           { Style-Control Flags }             
           flags        : LongInt;         { SI_xxxx Style Flags }

           { Variables reseved for future Definition. Must be Zero. }
           adwReserved  : Array[0..8] of LongInt;
    End;

type PSEGINFOHEADER = ^TSEGINFOHEADER;
     TSEGINFOHEADER = Record
           Magic                      : Word; { Should Contain SEG_MAGIC }

           SegJumpCount               : Word; { Number of Segments currently available }

           Width, Height              : Word; { Width and Height need to show ALL Hotspots }

           {--------- Design-Time-only Information ----------------------------}
           PictureFileName:array[0..FILENAMELENGTH-1] of char;{ Filename of the Picture File shown at Design-Time}
           HpjFileName    :array[0..FILENAMELENGTH-1] of char;{ Filename of the .HPJ - File  }

           {--------- Help THNHLP to save memory ------------------------------}
           HeaderAndStringSize : LongInt;		 { Size of SEGINFOHEADER+SEGJUMP+Strings without Metafiles }

           { Variables reserved for future Definition. Must be Zero.}
           dwReserved : array[0..9] of LongInt;
     End;

{  A SEG_File consists of one SEGINFOHEADER-Structure followed by
   SegJumpCount SEGJUMP-Structures, which may be followed by
   Metafile- and String-Data.

   There are no Metafile- or string-Informations between the SEGJUMPs
   or the SEGINFOHEADER and the SEGJUMPs

         +-------------------+-----------------+
  0x000: | SEGINFOHEADER     | SegJumpCount=3  |
         +-------------------+-----------------+
  0x208: | SEGJUMP           | macro.dw=0x2aa  | --\
         +-------------------+-----------------+   |
  0x23e: | SEGJUMP           | macro.dw=0x2b2  | --+--\
         +-------------------+-----------------+   |  |
  0x27e: | SEGJUMP           | macro.dw=0x2bd  | --+--+--\
         +-------------------+-----------------+   |  |  |
                                                   |  |  |
  0x2aa: "Print()\0" <-----------------------------/  |  |
                                                      |  |
  0x2b2: "JI(`',`ID_CONTENTS')\0" <-------------------/  |
                                                         |
  0x2bd: "About()\0" <-----------------------------------/



   SEG.EXE sorts the SEGJUMP-records by the size of the Rectangular
   Area, so big Areas will be at the End of the File, thus scanning
   from the Beginning of the File will find the smallest SEGJUMP
   matching a given Point;

   The maximum Length of the File excluding Metafiles is 65535 Bytes, thus
   limiting SegInfoCount to MAX_SEGINFOS.

   the metapos and metalen-Fields of a SEGJUMP give the starting-Position of a Metafile-
   Byte-relative to the beginning of the File. The Metafile-Data is metalen bytes long.

   The "PictureFileName" and "HpjFileName"-Members are only used during SEG Editiing.
   The are not requred by ThinHelp.
}

Function SegGetJump(header : PSEGINFOHEADER; number : Integer) : PSEGJUMP;
Function SegGetString(header : PSEGINFOHEADER; mystring : SEGSTRING ) : PChar;

implementation

Function SegGetJump(header : PSEGINFOHEADER; number : Integer) : PSEGJUMP;
begin
  SegGetJump:= PSEGJUMP(pchar(header) + sizeof(TSEGINFOHEADER) + number * sizeof(TSEGJUMP));
end;

Function SegGetString(header : PSEGINFOHEADER; mystring : SEGSTRING ) : PChar;
Begin
  SegGetString:=pchar(header) + LongInt(myString);
End;

End.

