{* SHGIMPOR.C --------------------------------------------------*
 * Import-Support for SHG-Files by Help Access Library          *
 *
 * (C) 1996-1997 Herd Software Development
 * Rudolf-Virchow-Str. 8/68642 Brstadt / Germany
 *--------------------------------------------------------------*}

unit shgimpor;

interface

uses WinTypes;

{$IFDEF WIN32}
const HLPACCESS_DLL_NAME = 'HLPACC32.DLL';
{$ELSE}
const HLPACCESS_DLL_NAME = 'HLPACC16';
{$ENDIF}

{  Documented in "Microsoft Windows 3.1 Programmer's
   Referenece Volume 4, Resources. Not in WINDOWS.H.
   This is the header for a Placeable Metafile        }
type PMETAFILEHEADER = ^TMETAFILEHEADER;
     TMETAFILEHEADER  = Record
                         key : LongInt;
                         hmf : Word;   { must be 0 }
                         bbox: Record
                                  left, top, right, bottom : Word;
                               End;
                         inch: Word;
                         reserved: LongInt; { must be 0 }
                         checksum: Word;
                       End;

     PHandle         = ^THandle;


{* -----------------------------------------------
 * SHGImport
 *
 * Does convert a Memory-Block that signifies an SHG-File into
 * a DIB-Bitmap and Segmentation-Information in SEG-File Format
 *
 * Returns:
 * TRUE : On Successfull Execution
 * FALSE: On Errors
 * -----------------------------------------------*}
Function SHGImport(          
		hwParent     : THandle;  	  { Parent-Window for error Messages }
		SHGData      : Pointer;   	  { Input Data Block }
                lphDib       : PHandle;    	  { DIB-Handle }
                lphMetaFile  : PHandle;	  { Metafile-Handle for SHG containing WMF }
                lpMetaFileHeader : PMETAFILEHEADER;{ Will be filled with Informations on placeable Metafiles }
                lphSegInfo       : PHandle  	  { Segmentation Informations }
		) : BOOL; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}




{* -----------------------------------------------
 * SHGExport
 *
 * Does convert a DIB-Handle and a SEGINFOHEADER-Structure
 * Into a memory Block in SHG-File Format
 *
 * Returns:
 * SHG-Memory Block
 * NULL : On Errors
 * -----------------------------------------------*}
Function SHGExport(
		hwParent : THandle;  	  { Parent-Window for error Messages }
                hDib     : THandle;    	  { DIB-Handle }
                hSegInfo : THandle	  { Segmentation Informations }
		) : THandle;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

implementation

Function SHGImport(
		hwParent     : THandle;  	  { Parent-Window for error Messages }
		SHGData      : Pointer;   	  { Input Data Block }
                lphDib       : PHandle;    	  { DIB-Handle }
                lphMetaFile  : PHandle;	  { Metafile-Handle for SHG containing WMF }
                lpMetaFileHeader : PMETAFILEHEADER;{ Will be filled with Informations on placeable Metafiles }
                lphSegInfo       : PHandle  	  { Segmentation Informations }
		) : BOOL; external HLPACCESS_DLL_NAME;

Function SHGExport(
		hwParent : THandle;  	  { Parent-Window for error Messages }
                hDib     : THandle;    	  { DIB-Handle }
                hSegInfo : THandle	  { Segmentation Informations }
		) : THandle; external HLPACCESS_DLL_NAME;

Begin

End.

