#include <windows.h>
#pragma argsused
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include "hlpacces.h"


typedef struct
        { HIFS   ifs;
        } APPLICATION_PRIVATE_DATA, FAR *LPAPPLICATION_PRIVATE_DATA;



typedef struct
        {
          DWORD TopicOffset,    /* TopicOffset that needs to be found */
                BestOffset,     /* Best match for the offset we had till Now */
                BestHash;       /* Hash-Code for this best Match we had */
        } SCAN_PRIVATE_DATA, FAR *LPSCAN_PRIVATE_DATA;


        BOOL CALLBACK ContextEnumerationProcedure(DWORD dwHashValue, DWORD dwTopicOffset, LPARAM lParam)
        {
          LPSCAN_PRIVATE_DATA dta = (LPSCAN_PRIVATE_DATA) lParam;

          if (abs(  dwTopicOffset - dta->TopicOffset) <
              abs(dta->BestOffset - dta->TopicOffset)
             )
             { dta->BestOffset = dwTopicOffset;
               dta->BestHash   = dwHashValue;
             }

          return TRUE;

        }





/* FindBestContextIdForTopicOffsez
 *
 * Tries to find a Context-String that fits to open the given TopicOffset
 */
DWORD FindBestHashForTopicOffset(
        HIFS   ifs,
        DWORD  TopicOffset)
{
  SCAN_PRIVATE_DATA dta;

  memset(&dta, 0, sizeof(dta));
  dta.TopicOffset = TopicOffset;
  dta.BestOffset  = 0x7fffffffL;

  HlpEnumContext(ifs, ContextEnumerationProcedure, (LPARAM)(LPSTR)&dta);

  return dta.BestHash;
}


	BOOL FAR PASCAL TitleEnumerationProcedure(LPCSTR lpszTitle, DWORD dwTopicOffset, LPARAM lParam)
	{ LPAPPLICATION_PRIVATE_DATA appdta = (LPAPPLICATION_PRIVATE_DATA) lParam;
          DWORD  Hash;
          char   ContextString[50];

//          HlpTopicSeek(topic, dwTopicOffset);
          Hash = FindBestHashForTopicOffset(appdta->ifs, dwTopicOffset);


        //  printf("TopicOffset:%08lx\tTitle:\"%Fs\"\n", dwTopicOffset, lpszTitle);

          HlpCreateStringForHashValue(Hash, ContextString);
          while (strlen(ContextString)<15) lstrcat(ContextString," ");

          printf("%s\t%s\n", ContextString, lpszTitle);

	  return TRUE;
	}


main(int argc, char **argv)
{ HIFS   ifs;
  APPLICATION_PRIVATE_DATA appdta;

  if (argc>1)
  {
      if (NULL!=(appdta.ifs   = IFSOpen(argv[1])))
      {
	 HlpEnumTitles(appdta.ifs, TitleEnumerationProcedure, (LPARAM)&appdta);
	 IFSClose(appdta.ifs);
      } else
         printf("File could not be opened\n");

  }
  else
    printf("THASHLST: Simple Example program for Help Access Library\n"
           "          Enumerates the List of Topics (|TTLBTREE) contained in a\n"
           "          Help or Media Viewer File with the associated Context Id\n"
           "          String created form the Hash-Value.\n"
           "Usage: THASHLST Filename\n"
           "(C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany");

  return 0;
}
