/* Simple Example program listing the Keywords of a Help file */
#include <windows.h>
#pragma argsused
#include <time.h>
#include <stdio.h>
#include "hlpacces.h"

#ifdef __WIN32__
# define _export		// Microsoft C can't stand that
#endif


typedef struct
        {
          HIFS     ifs;
          HIFSFILE hKWData;
        } TKWLIST, FAR*LPTKWLIST;

	BOOL FAR PASCAL _export KWEnumProc(LPCSTR lpszKeyWord, DWORD dwDataOffset, UINT uDataCount, LPARAM lParam)
	{
          LPTKWLIST tKWList=(LPTKWLIST)lParam;
          int       i;
          DWORD     dwTopicOffset, dwTopicOffsetStart;
          char      szTopicTitle[1024];

          printf("Offset:0x%08lx Count:0x%04x KW:%s\n", dwDataOffset, uDataCount, lpszKeyWord);

          IFSSeekFile(tKWList->hKWData, dwDataOffset, SEEK_SET);

          for (i=0; i<uDataCount; ++i)
          {
            IFSReadFile(tKWList->hKWData, &dwTopicOffset, sizeof(dwTopicOffset));
            if (HlpGetTopicTitle(tKWList->ifs, dwTopicOffset, szTopicTitle, sizeof(szTopicTitle), &dwTopicOffsetStart))
                 printf("  TopicOffset: 0x%08x  TopicOffsetStart: 0x%08lx  Title:%s\n", dwTopicOffset, dwTopicOffsetStart, szTopicTitle);
            else printf("  TopicOffset: 0x%08x: ERROR\n\n", dwTopicOffset);

          }

	  return TRUE;
	}


main(int argc, char **argv)
{ LPCSTR    StartKeyWord,
            KWListName;

  char      szKWBTree[50],
            szKWData[50];

  TKWLIST   tKWList;

  if (argc>1)
  {
    { HIFS ifs = IFSOpen(argv[1]);

      if (ifs)
      {
         StartKeyWord= argc>2 ? argv[2] : "";
         KWListName  = argc>3 ? argv[3] : "K";

         sprintf(szKWBTree, "|%sWBTREE", KWListName);
         sprintf(szKWData , "|%sWDATA" , KWListName);

         tKWList.hKWData = IFSOpenFile(ifs, szKWData);
         tKWList.ifs     = ifs;

         if (tKWList.hKWData!=NULL)
         {
            HlpEnumKeyWords(ifs, KWEnumProc, StartKeyWord, szKWBTree, (LPARAM)(LPSTR)&tKWList);
            IFSCloseFile(tKWList.hKWData);
         }
         else
           printf("Internal File \"%s\" not found\n", szKWData);

	 IFSClose(ifs);
      } else
         printf("File could not be opened\n");
    }


  }
  else
    printf("TKWLIST : Simple Example program for Help Access Library\n"
           "          Lists the Keywords contained in a Help File\n"
           "Usage: TKWLIST Filename [StartKeyWord] [List]\n"
           "(C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany");

  return 0;
}