/* TRTF.C    Simple Example program for Help Access Library
             Generates RTF-Output for a Topic

   (C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany"
*/


#include <windows.h>
#pragma argsused
#include <time.h>
#include <stdio.h>
#include "hlpacces.h"

void RtfPutc(BYTE ch, FILE *rtf);
void RtfPuts(FILE *rtf, LPCSTR String);


#ifdef __WIN32__
# define _export	// Microsoft C can't stand that
#endif


/* The ENUMERATION_PRIVATE_DATA-Struktucture is just used to show how the
   Application can Transfer a Pointer to an application-defined object
   to the callback-Function by use of the lParam-Parameter.

   The HlpTopicEnumerate-Function does not stop enumeration until the
   Callback-Functions tells it to stop by returning Zero.

   In This example we want to enumerate only once Topics contents,
   so we have to cancel enumeration when the seconds topic Title is
   to be enumerated.

   So we set our marker when the First enumeration took place.
*/

typedef struct
        {
          BOOL TitleEnumerated;                /* TRUE after Title has been enumerated first */
        }
          ENUMERATION_PRIVATE_DATA, FAR *LPENUMERATION_PRIVATE_DATA;   


        /* TopicEnumerationProcedure
         *
         * This is the callback-Function this application defined for the call to
         * HlpTopicEnumerate to Enumerate the TOPIC-Files contents
         */
	BOOL FAR PASCAL _export TopicEnumerationProcedure(
                LPCSTR    lpszTopicText,   // Text to be transfered to the Application program
                DWORD     dummy,           // resevred
                TEXTTYPE  eTextType,       // type of Text-String transfered to the Application
                LPARAM    lParam)          // Application-Defined user Data
	{
          LPENUMERATION_PRIVATE_DATA dta = (LPENUMERATION_PRIVATE_DATA) lParam;

          switch (eTextType)
          {
             case TOPIC_RTF_INIT:                // RTF Control strings: Initialization
             case TOPIC_RTF_TEXT:                // RTF Control strings: Text Data
             case TOPIC_RTF_EXIT:                // RTF Control strings: End of File Marker
                    printf("%s\n", lpszTopicText);// Just forward it.
                     break;

             case TOPIC_EWX:                    // Embedded-Window Text
             case TOPIC_TEXT:                   // Normal Text...
                     RtfPuts(stdout, lpszTopicText);
                     break;

             case TOPIC_TITLE:                  // Next topic's title
                     if (dta->TitleEnumerated)
                          return FALSE;         // Cancel Enumeration, No more Topics to Enumerate.
                     else
                          dta->TitleEnumerated=TRUE;
                     break;
          }

	  return TRUE;                          // Continue enumeration
	}


main(int argc, char **argv)
{ HIFS   ifs;
  HTOPIC topic;
  DWORD  TopicOffset;
  ENUMERATION_PRIVATE_DATA dta;
  memset(&dta, 0, sizeof(dta));

  if (argc>2)
  { sscanf(argv[2], "%lx", &TopicOffset);

    { ifs = IFSOpen(argv[1]);                   // Open the .HLP-File file system

      if (ifs)
      {
         topic = HlpTopicOpen(ifs, HTO_FONTS | /*HTO_CONTEXT | */HTO_KEYWORDS);          // Open TOPIC-File and load Phrases etc.
         if (topic)
         {
           //------------ Enumerate the Topic ------------------------------
           HlpTopicSeek(     topic, TopicOffset);   
           HlpTopicEnumerate(topic, TopicEnumerationProcedure, (LPARAM)&dta);
           HlpTopicClose(topic);
         }
         else
           printf("HlpTopicOpen: Topic-File could not be opened. Maybe it is not a Help-File?\n");

	 IFSClose(ifs);
      } else
         printf("IFSOpen: File could not be opened\n");
    }
  }
  else
    printf("TRTF    : Simple Example program for Help Access Library\n"
           "          Generates RTF-Output for a Topic\n"
           "USAGE   : TRTF Filename TopicOffset\n"
           "EXAMPLE : TRTF c:\\windows\\winfile.hlp 00000000\n"
           "INFO    : Use example-Program TENUMTTL to retrieve valid TopicOffsets\n"
           "(C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany");

  return 0;
}






/* RtfPutc -----------------------------------------------------*
 * Write Char as RTF-Character					*
 *--------------------------------------------------------------*/
void RtfPutc(BYTE ch, FILE *rtf)
{ static int egal=0;
  if (ch > 0x80)
       fprintf(rtf, "\\'%02x", ch);
  else switch (ch)
       {
	 case '\\': fprintf(rtf, "\\\\") ; break;
	 case '{' : fprintf(rtf, "\\{")  ; break;
	 case '}' : fprintf(rtf, "\\}")  ; break;
	 case '\t': fprintf(rtf, "\\tab "); break;
	 case '\n': fprintf(rtf, "\\par "); break;
	 case '\r': fprintf(rtf, "\\line "); break;
	 default  : if (ch<' ')
			 fprintf(rtf, "(0x%02x)", ch);
		    else fputc(ch, rtf);
       }
  if (!(egal++%64))
       fputc('\n', rtf);
}


void RtfPuts(FILE *rtf, LPCSTR String)
{
  while (*String)
    RtfPutc((BYTE) *String++, rtf);
}

